/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class TableSelectionLayout
extends VerticalLayout {
    private Set<Table> selectedTablesSet;
    private final Set<Table> originalSelectedTablesSet;
    private static final long serialVersionUID = 1L;
    public Grid<String> listOfTablesGrid;
    public ComboBox<String> catalogSelect;
    public ComboBox<String> schemaSelect;
    private String filterCriteria = null;
    private TextField filterField;
    private IDatabasePlatform databasePlatform;
    private List<String> excludedTables;
    private String excludeTablesRegex;

    public TableSelectionLayout(IDatabasePlatform databasePlatform, Set<Table> selectedSet, String excludeTablesRegex) {
        this("Please select from the following tables", databasePlatform, selectedSet, null, excludeTablesRegex);
    }

    public TableSelectionLayout(String titleKey, IDatabasePlatform databasePlatform, Set<Table> selectedSet) {
        this(titleKey, databasePlatform, selectedSet, null, null);
    }

    public TableSelectionLayout(String titleKey, IDatabasePlatform databasePlatform, Set<Table> selectedSet, List<String> excludedTables, String excludeTablesRegex) {
        this.setSizeFull();
        this.setMargin(false);
        this.setSpacing(true);
        this.selectedTablesSet = selectedSet;
        this.originalSelectedTablesSet = selectedSet;
        this.databasePlatform = databasePlatform;
        this.excludedTables = excludedTables;
        this.excludeTablesRegex = excludeTablesRegex;
        this.createTableSelectionLayout(titleKey);
    }

    protected void createTableSelectionLayout(String titleKey) {
        this.add(new Component[]{new Span(titleKey)});
        HorizontalLayout schemaChooserLayout = new HorizontalLayout();
        schemaChooserLayout.setSpacing(true);
        this.add(new Component[]{schemaChooserLayout});
        this.catalogSelect = new ComboBox("Catalog");
        this.catalogSelect.setItems((ComboBox.ItemFilter & Serializable)(catalog, filter) -> !CommonUiUtils.isFilteredOut(catalog, filter), this.getCatalogs());
        schemaChooserLayout.add(new Component[]{this.catalogSelect});
        if (this.selectedTablesSet.iterator().hasNext()) {
            this.catalogSelect.setValue((Object)this.selectedTablesSet.iterator().next().getCatalog());
        } else {
            this.catalogSelect.setValue((Object)this.databasePlatform.getDefaultCatalog());
        }
        this.schemaSelect = new ComboBox("Schema");
        schemaChooserLayout.add(new Component[]{this.schemaSelect});
        schemaChooserLayout.addAndExpand(new Component[]{new Span()});
        this.filterField = new TextField();
        this.filterField.setPrefixComponent((Component)new Icon(VaadinIcon.SEARCH));
        this.filterField.setPlaceholder("Filter Tables");
        this.filterField.setValueChangeMode(ValueChangeMode.LAZY);
        this.filterField.setValueChangeTimeout(200);
        this.filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.filterField.setValue((String)event.getValue());
            this.refreshTableOfTables();
        });
        schemaChooserLayout.add(new Component[]{this.filterField});
        schemaChooserLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.filterField});
        this.listOfTablesGrid = new Grid();
        this.listOfTablesGrid.setSizeFull();
        this.listOfTablesGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.listOfTablesGrid.addItemClickListener((ComponentEventListener & Serializable)event -> {
            if (event.getColumn() != null) {
                this.listOfTablesGrid.deselectAll();
                this.listOfTablesGrid.select((Object)((String)event.getItem()));
            }
        });
        this.listOfTablesGrid.addSelectionListener((SelectionListener & Serializable)event -> {
            this.selectedTablesSet.clear();
            this.selectedTablesSet.addAll(this.originalSelectedTablesSet);
            for (String table : this.listOfTablesGrid.getSelectedItems()) {
                this.selectedTablesSet.add(new Table(table));
            }
            this.selectionChanged();
        });
        this.listOfTablesGrid.addColumn((ValueProvider & Serializable)table -> table);
        this.addAndExpand(new Component[]{this.listOfTablesGrid});
        this.refreshSchemas();
        this.schemaSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.refreshTableOfTables());
        this.catalogSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.refreshSchemas();
            this.refreshTableOfTables();
        });
        Button selectAllLink = new Button("Select All");
        selectAllLink.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_TERTIARY_INLINE});
        selectAllLink.addClickListener((ComponentEventListener & Serializable)event -> this.selectAll());
        Button selectNoneLink = new Button("Select None");
        selectNoneLink.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_TERTIARY_INLINE});
        selectNoneLink.addClickListener((ComponentEventListener & Serializable)event -> this.selectNone());
        HorizontalLayout selectAllFooter = new HorizontalLayout();
        selectAllFooter.setWidth("100%");
        selectAllFooter.setSpacing(true);
        selectAllFooter.add(new Component[]{selectAllLink, selectNoneLink});
        this.add(new Component[]{selectAllFooter});
        this.refreshTableOfTables();
    }

    public String getSelectedSchema() {
        String schemaName = (String)this.schemaSelect.getValue();
        if (schemaName != null && schemaName.equals(this.databasePlatform.getDefaultSchema())) {
            schemaName = null;
        }
        return StringUtils.isBlank((CharSequence)schemaName) ? null : schemaName;
    }

    public String getSelectedCatalog() {
        String catalogName = (String)this.catalogSelect.getValue();
        if (catalogName != null && catalogName.equals(this.databasePlatform.getDefaultCatalog())) {
            catalogName = null;
        }
        return StringUtils.isBlank((CharSequence)catalogName) ? null : catalogName;
    }

    protected void refreshSchemas() {
        List<String> schemas = this.getSchemas();
        if (schemas != null && schemas.size() == 0) {
            this.refreshTableOfTables();
            return;
        }
        this.schemaSelect.setItems((ComboBox.ItemFilter & Serializable)(schema, filter) -> !CommonUiUtils.isFilteredOut(schema, filter), schemas);
        if (this.selectedTablesSet.iterator().hasNext()) {
            this.schemaSelect.setValue((Object)this.selectedTablesSet.iterator().next().getSchema());
        } else {
            this.schemaSelect.setValue((Object)this.databasePlatform.getDefaultSchema());
        }
    }

    protected void refreshTableOfTables() {
        List<String> tables = this.getTables();
        String filter = this.filterField == null ? "" : this.filterField.getValue();
        ArrayList<String> filteredTables = new ArrayList<String>();
        for (String table : tables) {
            if (this.excludedTables != null && this.excludedTables.contains(table.toLowerCase()) || !this.display(this.getSelectedCatalog(), this.getSelectedSchema(), table) || CommonUiUtils.isFilteredOut(table, filter)) continue;
            filteredTables.add(table);
        }
        this.listOfTablesGrid.setItems(filteredTables);
    }

    protected void selectionChanged() {
    }

    public List<String> getSelectedTables() {
        return new ArrayList<String>(this.listOfTablesGrid.getSelectedItems());
    }

    public void selectAll() {
        for (String table : this.listOfTablesGrid.getDataProvider().fetch(new Query()).collect(Collectors.toList())) {
            this.listOfTablesGrid.select((Object)table);
        }
        this.selectionChanged();
    }

    public void selectNone() {
        this.listOfTablesGrid.deselectAll();
        this.selectionChanged();
    }

    public List<String> getSchemas() {
        return this.databasePlatform.getDdlReader().getSchemaNames((String)this.catalogSelect.getValue());
    }

    public List<String> getCatalogs() {
        return this.databasePlatform.getDdlReader().getCatalogNames();
    }

    public List<String> getTables() {
        List tableNames = this.databasePlatform.getDdlReader().getTableNames((String)this.catalogSelect.getValue(), (String)this.schemaSelect.getValue(), new String[]{"TABLE"});
        Iterator iter = tableNames.iterator();
        while (iter.hasNext()) {
            String tableName = (String)iter.next();
            if (!tableName.matches(this.excludeTablesRegex) && !tableName.toUpperCase().matches(this.excludeTablesRegex) && !tableName.toLowerCase().matches(this.excludeTablesRegex)) continue;
            iter.remove();
        }
        return tableNames;
    }

    public List<String> getExcludedTables() {
        return this.excludedTables;
    }

    public void setExcludedTables(List<String> excludedTables) {
        this.excludedTables = excludedTables;
    }

    protected boolean display(String catalog, String schema, String table) {
        return true;
    }

    protected boolean select(String catalog, String schema, String table) {
        for (Table t : this.selectedTablesSet) {
            if (!table.equals(t.getName())) continue;
            return true;
        }
        return false;
    }
}

