/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.server.Command;
import de.f0rce.ace.AceEditor;
import de.f0rce.ace.enums.AceMode;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.symmetric.io.data.DbExport;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.sqlexplorer.AbstractMetaDataGridCreator;
import org.jumpmind.vaadin.ui.sqlexplorer.ColumnMetaDataTableCreator;
import org.jumpmind.vaadin.ui.sqlexplorer.ExportedKeysMetaDataTableCreator;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.IInfoPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.ImportedKeysMetaDataTableCreator;
import org.jumpmind.vaadin.ui.sqlexplorer.IndexMetaDataTableCreator;
import org.jumpmind.vaadin.ui.sqlexplorer.PrimaryKeyMetaDataTableCreator;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlExplorer;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInfoPanel
extends VerticalLayout
implements IInfoPanel {
    private static final Logger log = LoggerFactory.getLogger(TableInfoPanel.class);
    private static final long serialVersionUID = 1L;
    SqlExplorer explorer;
    TabSheet tabSheet;
    String selectedCaption;

    public TableInfoPanel(Table table, String user, IDb db, Settings settings, String selectedTabCaption) {
        this(table, user, db, settings, null, selectedTabCaption);
    }

    public TableInfoPanel(Table table, String user, IDb db, Settings settings, SqlExplorer explorer, String selectedTabCaption) {
        this.explorer = explorer;
        this.setSizeFull();
        this.tabSheet = CommonUiUtils.createTabSheet();
        this.tabSheet.setAutoselect(false);
        this.tabSheet.addSelectedTabChangeListener((ComponentEventListener<Tabs.SelectedChangeEvent>)(ComponentEventListener & Serializable)event -> {
            TabSheet.EnhancedTab selectedTab = this.tabSheet.getSelectedTab();
            if (selectedTab != null) {
                this.selectedCaption = selectedTab.getName();
                Component selectedComponent = selectedTab.getComponent();
                if (selectedComponent != null) {
                    if (!(selectedComponent instanceof AceEditor)) {
                        boolean isInit = Boolean.TRUE.equals(ComponentUtil.getData((Component)selectedComponent, (String)"isInit"));
                        AbstractMetaDataGridCreator creator = (AbstractMetaDataGridCreator)ComponentUtil.getData((Component)selectedComponent, (String)"creator");
                        if (this.selectedCaption.equals("Data") && isInit) {
                            this.refreshData(table, user, db, settings, false);
                        } else if (creator != null) {
                            this.populate((VerticalLayout)selectedComponent);
                        }
                    } else if (((Boolean)ComponentUtil.getData((Component)selectedComponent, (String)"data")).booleanValue()) {
                        this.populateSource(table, db, (AceEditor)selectedComponent);
                    }
                }
            }
        });
        this.add(new Component[]{this.tabSheet});
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)db.getPlatform().getSqlTemplate();
        this.tabSheet.add((Component)this.create(new ColumnMetaDataTableCreator(sqlTemplate, table, settings)), "Columns");
        this.tabSheet.add((Component)this.create(new PrimaryKeyMetaDataTableCreator(sqlTemplate, table, settings)), "Primary Keys");
        this.tabSheet.add((Component)this.create(new IndexMetaDataTableCreator(sqlTemplate, table, settings)), "Indexes");
        if (db.getPlatform().getDatabaseInfo().isForeignKeysSupported()) {
            this.tabSheet.add((Component)this.create(new ImportedKeysMetaDataTableCreator(sqlTemplate, table, settings)), "Imported Keys");
            this.tabSheet.add((Component)this.create(new ExportedKeysMetaDataTableCreator(sqlTemplate, table, settings)), "Exported Keys");
        }
        this.refreshData(table, user, db, settings, true);
        AceEditor editor = CommonUiUtils.createAceEditor();
        ComponentUtil.setData((Component)editor, (String)"data", (Object)true);
        this.tabSheet.add((Component)editor, "Source");
        Iterator<Component> i = this.tabSheet.iterator();
        while (i.hasNext()) {
            Component component = i.next();
            TabSheet.EnhancedTab tab = this.tabSheet.getTab(component);
            if (!tab.getName().equals(selectedTabCaption)) continue;
            this.tabSheet.setSelectedTab(component);
            break;
        }
        if (this.tabSheet.getSelectedTab() == null) {
            this.tabSheet.setSelectedTab("Columns");
        }
    }

    @Override
    public String getSelectedTabCaption() {
        return this.selectedCaption;
    }

    protected void refreshData(final Table table, final String user, final IDb db, final Settings settings, boolean isInit) {
        if (!isInit && this.tabSheet.getTabCount() >= 2) {
            this.tabSheet.remove(this.tabSheet.getTab(1).getName());
        }
        IDatabasePlatform platform = db.getPlatform();
        DmlStatement dml = platform.createDmlStatement(DmlStatement.DmlType.SELECT_ALL, table, null);
        HorizontalLayout executingLayout = new HorizontalLayout();
        executingLayout.setSizeFull();
        ProgressBar p = new ProgressBar();
        p.setIndeterminate(true);
        executingLayout.add(new Component[]{p});
        ComponentUtil.setData((Component)executingLayout, (String)"isInit", (Object)isInit);
        this.tabSheet.add((Component)executingLayout, "Data", isInit ? null : new Icon(VaadinIcon.SPINNER), 1);
        if (!isInit) {
            this.tabSheet.setSelectedTab((Component)executingLayout);
        }
        SqlRunner runner = new SqlRunner(dml.getSql(), false, user, db, settings, this.explorer, new SqlRunner.ISqlRunnerListener(){
            private static final long serialVersionUID = 1L;

            @Override
            public void writeSql(String sql) {
                TableInfoPanel.this.explorer.openQueryWindow(db).appendSql(sql);
            }

            @Override
            public void reExecute(String sql) {
                TableInfoPanel.this.refreshData(table, user, db, settings, false);
            }

            @Override
            public void finished(VaadinIcon icon, List<Component> results, long executionTimeInMs, boolean transactionStarted, boolean transactionEnded) {
                UI ui = TableInfoPanel.this.getUI().orElse(null);
                if (ui != null) {
                    ui.access((Command & Serializable)() -> {
                        TableInfoPanel.this.tabSheet.remove("Data");
                        VerticalLayout layout = new VerticalLayout();
                        layout.setMargin(true);
                        layout.setSizeFull();
                        if (results.size() > 0) {
                            layout.add(new Component[]{(Component)results.get(0)});
                        }
                        TableInfoPanel.this.tabSheet.add((Component)layout, "Data", null, 1);
                        TableInfoPanel.this.tabSheet.setSelectedTab((Component)layout);
                    });
                }
            }
        });
        runner.setShowSqlOnResults(false);
        runner.setLogAtDebug(true);
        if (!isInit) {
            runner.start();
        }
    }

    protected VerticalLayout create(AbstractMetaDataGridCreator creator) {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(false);
        layout.setSizeFull();
        ComponentUtil.setData((Component)layout, (String)"creator", (Object)creator);
        return layout;
    }

    protected void populate(VerticalLayout layout) {
        AbstractMetaDataGridCreator creator = (AbstractMetaDataGridCreator)ComponentUtil.getData((Component)layout, (String)"creator");
        ColumnVisibilityToggler columnVisibilityToggler = new ColumnVisibilityToggler();
        Grid<List<Object>> grid = creator.create(columnVisibilityToggler);
        layout.add(new Component[]{columnVisibilityToggler});
        layout.setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{columnVisibilityToggler});
        layout.add(new Component[]{grid});
        layout.expand(new Component[]{grid});
        ComponentUtil.setData((Component)layout, (String)"creator", null);
    }

    protected void populateSource(Table table, IDb db, AceEditor oldTab) {
        try {
            if (this.tabSheet.getTab((Component)oldTab) != null) {
                this.tabSheet.remove(this.tabSheet.getTab((Component)oldTab).getName());
            }
            DbExport export = new DbExport(db.getPlatform());
            export.setNoCreateInfo(false);
            export.setNoData(true);
            export.setCatalog(table.getCatalog());
            export.setSchema(table.getSchema());
            export.setFormat(DbExport.Format.SQL);
            AceEditor editor = CommonUiUtils.createAceEditor();
            editor.setMode(AceMode.sql);
            editor.setValue(export.exportTables(new Table[]{table}));
            ComponentUtil.setData((Component)editor, (String)"data", (Object)false);
            this.tabSheet.add((Component)editor, "Source");
            this.tabSheet.setSelectedTab((Component)editor);
        }
        catch (IOException e) {
            log.warn("Failed to export the create information", (Throwable)e);
        }
    }

    @Override
    public void selected() {
    }

    @Override
    public void unselected() {
    }
}

