/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.ISettingsProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.QueryPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlHistory;

public class SqlHistoryDialog
extends ResizableDialog {
    private static final long serialVersionUID = 1L;
    private final Grid<SqlHistory> grid;
    private final TreeSet<SqlHistory> sqlHistories;
    private QueryPanel queryPanel;
    private ISettingsProvider settingsProvider;

    public SqlHistoryDialog(ISettingsProvider settingsProvider, QueryPanel queryPanel) {
        super("Sql History");
        this.settingsProvider = settingsProvider;
        this.queryPanel = queryPanel;
        VerticalLayout mainLayout = new VerticalLayout();
        mainLayout.setSizeFull();
        mainLayout.setMargin(false);
        mainLayout.setSpacing(true);
        this.add((Component)mainLayout, 1);
        this.sqlHistories = new TreeSet<SqlHistory>(settingsProvider.get().getSqlHistory());
        this.grid = new Grid();
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.addColumn((ValueProvider & Serializable)history -> StringUtils.abbreviate((String)history.getSqlStatement(), (int)50)).setKey("sqlStatement").setHeader("SQL");
        this.grid.addColumn((ValueProvider & Serializable)history -> String.format("%1$tY-%1$tm-%1$td %1$tk:%1$tM:%1$tS", history.getLastExecuteTime())).setHeader("Time").setWidth("150px");
        this.grid.addColumn((ValueProvider & Serializable)history -> CommonUiUtils.formatDuration(history.getLastExecuteDuration())).setHeader("Duration").setWidth("120px").setFlexGrow(0);
        this.grid.addColumn((ValueProvider & Serializable)history -> history.getExecuteCount()).setHeader("Count").setWidth("120px").setFlexGrow(0);
        for (Grid.Column column : this.grid.getColumns()) {
            column.setResizable(true);
        }
        HeaderRow filteringHeader = this.grid.appendHeaderRow();
        HeaderRow.HeaderCell logTextFilterCell = (HeaderRow.HeaderCell)filteringHeader.getCell(this.grid.getColumnByKey("sqlStatement"));
        TextField filterField = new TextField();
        filterField.setValueChangeMode(ValueChangeMode.EAGER);
        filterField.setPlaceholder("Filter");
        filterField.getElement().setAttribute("theme", "font-size-xs");
        filterField.setWidth("100%");
        filterField.addThemeName("small");
        filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.filter((String)event.getValue()));
        logTextFilterCell.setComponent((Component)filterField);
        this.grid.addItemClickListener((ComponentEventListener & Serializable)event -> {
            if (event.getColumn() != null) {
                this.grid.deselectAll();
                this.grid.select((Object)((SqlHistory)event.getItem()));
            }
            if (event.getClickCount() == 2) {
                this.select();
            }
        });
        this.grid.setHeight("120px");
        this.grid.setWidthFull();
        mainLayout.addAndExpand(new Component[]{this.grid});
        this.grid.setItems(this.sqlHistories);
        Button cancelButton = new Button("Cancel");
        cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.close());
        Button applyButton = CommonUiUtils.createPrimaryButton("Select");
        applyButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        applyButton.addClickListener((ComponentEventListener & Serializable)event -> this.select());
        this.buildButtonFooter(new Component[]{cancelButton, applyButton});
    }

    private void filter(String filter) {
        TreeSet<SqlHistory> histories = new TreeSet<SqlHistory>(this.settingsProvider.get().getSqlHistory());
        ArrayList<SqlHistory> filteredHistories = new ArrayList<SqlHistory>();
        for (SqlHistory history : histories) {
            if (CommonUiUtils.isFilteredOut(history.getSqlStatement(), filter)) continue;
            filteredHistories.add(history);
        }
        this.grid.setItems(filteredHistories);
    }

    protected void select() {
        Set histories = this.grid.getSelectedItems();
        if (histories != null && histories.size() > 0) {
            String delimiter = this.settingsProvider.get().getProperties().get("sql.explorer.delimiter");
            for (SqlHistory history : this.sqlHistories.descendingSet()) {
                String sql;
                if (!histories.contains(history)) continue;
                this.queryPanel.appendSql(sql + ((sql = history.getSqlStatement()).trim().endsWith(delimiter) ? "" : delimiter));
            }
            this.close();
        }
    }
}

