/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.tabs.Tab;
import org.jumpmind.vaadin.ui.common.NotifyDialog;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.sqlexplorer.QueryPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlExplorer;

public class SqlExplorerTabPanel
extends TabSheet {
    private static final long serialVersionUID = 1L;
    private SqlExplorer sqlExplorer;

    public SqlExplorerTabPanel(SqlExplorer sqlExplorer) {
        this.sqlExplorer = sqlExplorer;
        this.setSizeFull();
    }

    @Override
    public void remove(TabSheet.EnhancedTab tab) {
        Component component = tab.getComponent();
        if (component != null && component instanceof QueryPanel && ((QueryPanel)component).commitButtonValue) {
            NotifyDialog.show("Cannot Close Tab", "You must commit or rollback queries before closing this tab.", null, NotificationVariant.LUMO_CONTRAST);
        } else {
            int tabCount = this.tabList.size();
            if (tab.isSelected() && tabCount > 1) {
                int index = this.tabList.indexOf((Object)tab);
                if (index < tabCount - 1) {
                    this.tabs.setSelectedIndex(index + 1);
                } else {
                    this.tabs.setSelectedIndex(index - 1);
                }
            }
            this.tabs.remove(new Tab[]{tab});
            this.tabList.remove((Object)tab);
            if (tabCount <= 1) {
                this.content.removeAll();
                this.sqlExplorer.resetContentMenuBar();
            }
        }
    }
}

