/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import de.f0rce.ace.AceEditor;
import de.f0rce.ace.enums.AceMode;
import de.f0rce.ace.events.AceSelectionChanged;
import java.io.Serializable;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.CustomSplitLayout;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.sqlexplorer.IButtonBar;
import org.jumpmind.vaadin.ui.sqlexplorer.IContentTab;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.ISettingsProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlHistory;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlRunner;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlSuggester;
import org.jumpmind.vaadin.ui.sqlexplorer.TabularResultLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPanel
extends CustomSplitLayout
implements IContentTab {
    private static final Logger log = LoggerFactory.getLogger(QueryPanel.class);
    private static final long serialVersionUID = 1L;
    AceEditor sqlArea;
    IDb db;
    ComponentEventListener<AceSelectionChanged> selectionChangeListener;
    Registration selectionChangeRegistration;
    List<ShortcutRegistration> shortcutRegistrations;
    boolean requestedExecutionAtCursor = false;
    boolean requestedScriptExecution = false;
    boolean commitButtonValue = false;
    boolean rollbackButtonValue = false;
    IButtonBar buttonBar;
    TabSheet resultsTabs;
    TabSheet.EnhancedTab errorTab;
    int maxNumberOfResultTabs = 10;
    ISettingsProvider settingsProvider;
    String user;
    Connection connection;
    Span status;
    transient SqlSuggester suggester;
    boolean canceled = false;
    VerticalLayout emptyResults;
    Map<Component, String> resultStatuses;
    TabSheet.EnhancedTab generalResultsTab;
    private AceEditor editor;
    transient Set<SqlRunner> runnersInProgress = new HashSet<SqlRunner>();

    public QueryPanel(IDb db, ISettingsProvider settingsProvider, IButtonBar buttonBar, String user) {
        this.settingsProvider = settingsProvider;
        this.db = db;
        this.user = user;
        this.buttonBar = buttonBar;
        this.sqlArea = this.buildSqlEditor();
        this.shortcutRegistrations = new ArrayList<ShortcutRegistration>();
        this.setOrientation(SplitLayout.Orientation.VERTICAL);
        this.setHeightFull();
        VerticalLayout resultsLayout = new VerticalLayout();
        resultsLayout.setMargin(false);
        resultsLayout.setSpacing(false);
        resultsLayout.setSizeFull();
        this.resultsTabs = CommonUiUtils.createTabSheet();
        this.resultsTabs.setHeight("90px");
        this.resultsTabs.getStyle().set("margin-bottom", "20px");
        this.resultStatuses = new HashMap<Component, String>();
        HorizontalLayout statusBar = new HorizontalLayout();
        statusBar.setMargin(false);
        statusBar.setWidthFull();
        this.status = new Span("No Results");
        this.status.getElement().setAttribute("theme", "font-size-s");
        statusBar.add(new Component[]{this.status});
        this.setSelectedTabChangeListener();
        resultsLayout.add(new Component[]{this.resultsTabs, statusBar});
        resultsLayout.expand(new Component[]{this.resultsTabs});
        this.addToPrimary(new Component[]{this.sqlArea});
        this.addToSecondary(new Component[]{resultsLayout});
        this.setSplitterPosition(50.0);
        this.emptyResults = new VerticalLayout();
        this.emptyResults.setSizeFull();
        Span span = new Span("New results will appear here");
        span.setWidth(null);
        this.emptyResults.add(new Component[]{span});
        this.emptyResults.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{span});
        this.resultStatuses.put((Component)this.emptyResults, "No Results");
        if (!settingsProvider.get().getProperties().is("sql.explorer.show.results.in.new.tabs")) {
            this.createGeneralResultsTab();
        }
    }

    public IDb getDb() {
        return this.db;
    }

    protected AceEditor buildSqlEditor() {
        this.editor = CommonUiUtils.createAceEditor();
        this.editor.setMode(AceMode.sql);
        this.editor.addValueChangeListener((ComponentEventListener & Serializable)event -> this.setButtonsEnabled());
        this.editor.addSyncCompletedListener((ComponentEventListener & Serializable)event -> {
            if (!this.editor.getValue().equals("")) {
                if (this.requestedExecutionAtCursor) {
                    if (this.execute(false) && !this.settingsProvider.get().getProperties().is("sql.explorer.auto.commit")) {
                        this.setButtonsEnabled();
                    }
                    this.requestedExecutionAtCursor = false;
                } else if (this.requestedScriptExecution) {
                    if (this.execute(true) && !this.settingsProvider.get().getProperties().is("sql.explorer.auto.commit")) {
                        this.setButtonsEnabled();
                    }
                    this.requestedScriptExecution = false;
                }
            } else {
                this.requestedExecutionAtCursor = false;
                this.requestedScriptExecution = false;
            }
        });
        boolean autoSuggestEnabled = this.settingsProvider.get().getProperties().is("sql.explorer.auto.complete");
        this.setAutoCompleteEnabled(autoSuggestEnabled);
        this.selectionChangeListener = new DummyChangeListener();
        return this.editor;
    }

    public AceEditor getSqlEditor() {
        return this.editor;
    }

    public void syncSqlEditor() {
        this.editor.sync();
    }

    public IButtonBar getButtonBar() {
        return this.buttonBar;
    }

    protected void setSelectedTabChangeListener() {
        this.resultsTabs.addSelectedTabChangeListener((ComponentEventListener<Tabs.SelectedChangeEvent>)(ComponentEventListener & Serializable)event -> {
            if (this.resultsTabs.getSelectedTab() != null) {
                Component tab = this.resultsTabs.getSelectedTab().getComponent();
                String st = this.resultStatuses.get(tab);
                if (st == null && tab instanceof VerticalLayout && ((VerticalLayout)tab).getComponentCount() > 0) {
                    st = this.resultStatuses.get(((VerticalLayout)tab).getComponentAt(0));
                }
                if (st == null) {
                    st = "No Results";
                }
                this.status.setText(st);
            }
        });
    }

    public TabSheet.EnhancedTab getGeneralResultsTab() {
        return this.generalResultsTab;
    }

    public void createGeneralResultsTab() {
        if (this.generalResultsTab == null) {
            VerticalLayout generalResultsPanel = new VerticalLayout();
            generalResultsPanel.setSizeFull();
            this.generalResultsTab = this.resultsTabs.add((Component)generalResultsPanel, "Results", 0);
            this.resetGeneralResultsTab();
        }
    }

    public void removeGeneralResultsTab() {
        if (this.generalResultsTab != null) {
            Component content = ((VerticalLayout)this.generalResultsTab.getComponent()).getComponentAt(0);
            if (content instanceof TabularResultLayout) {
                this.addResultsTab((Component)((TabularResultLayout)content).refreshWithoutSaveButton(), StringUtils.abbreviate((String)((TabularResultLayout)content).getSql(), (int)20), this.generalResultsTab.getIcon(), 0);
            }
            this.resultsTabs.remove(this.generalResultsTab);
            this.generalResultsTab = null;
        }
    }

    public void resetGeneralResultsTab() {
        if (this.generalResultsTab != null) {
            this.replaceGeneralResultsWith((Component)this.emptyResults, null);
            this.generalResultsTab.setCloseable(false);
        }
    }

    public void replaceGeneralResultsWith(Component newComponent, VaadinIcon icon) {
        ((VerticalLayout)this.generalResultsTab.getComponent()).removeAll();
        ((VerticalLayout)this.generalResultsTab.getComponent()).add(new Component[]{newComponent});
        if (icon != null) {
            this.generalResultsTab.setIcon(new Icon(icon));
        }
    }

    @Override
    public void selected() {
        this.unselected();
        this.selectionChangeRegistration = this.sqlArea.addSelectionChangeListener(this.selectionChangeListener);
        this.shortcutRegistrations.add(this.createExecuteSqlShortcutListener());
        this.shortcutRegistrations.add(this.createExecuteSqlScriptShortcutListener());
        this.setButtonsEnabled();
        this.editor.focus();
    }

    @Override
    public void unselected() {
        if (this.selectionChangeRegistration != null) {
            this.selectionChangeRegistration.remove();
        }
        for (ShortcutRegistration registration : this.shortcutRegistrations) {
            registration.remove();
        }
        this.shortcutRegistrations.clear();
    }

    protected void setButtonsEnabled() {
        this.buttonBar.setCommitButtonEnabled(this.commitButtonValue);
        this.buttonBar.setRollbackButtonEnabled(this.rollbackButtonValue);
    }

    protected ShortcutRegistration createExecuteSqlShortcutListener() {
        return Shortcuts.addShortcutListener((Component)this.editor, (Command & Serializable)() -> this.requestExecutionAtCursor(), (Key)Key.ENTER, (KeyModifier[])new KeyModifier[]{KeyModifier.CONTROL}).listenOn(new Component[]{this.editor});
    }

    protected ShortcutRegistration createExecuteSqlScriptShortcutListener() {
        return Shortcuts.addShortcutListener((Component)this.editor, (Command & Serializable)() -> this.requestScriptExecution(), (Key)Key.ENTER, (KeyModifier[])new KeyModifier[]{KeyModifier.CONTROL, KeyModifier.SHIFT}).listenOn(new Component[]{this.editor});
    }

    public void requestExecutionAtCursor() {
        this.requestedExecutionAtCursor = true;
        this.editor.sync();
    }

    public void requestScriptExecution() {
        this.requestedScriptExecution = true;
        this.editor.sync();
    }

    protected void addToSqlHistory(String sqlStatement, Date executeTime, long executeDuration, String userId) {
        sqlStatement = sqlStatement.trim();
        Settings settings = this.settingsProvider.load();
        SqlHistory history = settings.getSqlHistory(sqlStatement);
        if (history == null) {
            history = new SqlHistory();
            history.setSqlStatement(sqlStatement);
            settings.addSqlHistory(history);
        }
        history.setLastExecuteDuration(executeDuration);
        history.setExecuteCount(history.getExecuteCount() + 1L);
        history.setLastExecuteUserId(userId);
        history.setLastExecuteTime(executeTime);
        this.settingsProvider.save(settings);
    }

    public boolean reExecute(String sql) {
        TabSheet.EnhancedTab tab = this.resultsTabs.getSelectedTab();
        int tabPosition = this.resultsTabs.getTabIndex(tab.getComponent());
        if (this.generalResultsTab != null && this.generalResultsTab == tab) {
            return this.execute(false, sql, tabPosition);
        }
        this.resultsTabs.remove(tab.getName());
        return this.execute(false, sql, tabPosition, true);
    }

    public boolean execute(boolean runAsScript) {
        return this.execute(runAsScript, null, this.resultsTabs.getComponentCount());
    }

    public void appendSql(String sql) {
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            this.sqlArea.setValue((String)(StringUtils.isNotBlank((CharSequence)this.sqlArea.getValue()) ? this.sqlArea.getValue() + "\n" : "") + sql);
        }
    }

    public String getSql() {
        return this.sqlArea.getValue();
    }

    protected void executeSql(String sql, boolean writeToQueryWindow) {
        if (writeToQueryWindow) {
            this.appendSql(sql);
        }
        this.execute(false, sql, this.resultsTabs.getComponentCount());
    }

    protected boolean execute(boolean runAsScript, String sqlText, int tabPosition) {
        return this.execute(runAsScript, sqlText, tabPosition, false);
    }

    protected boolean execute(boolean runAsScript, String sqlText, final int tabPosition, final boolean forceNewTab) {
        boolean scheduled = false;
        if (this.runnersInProgress == null) {
            this.runnersInProgress = new HashSet<SqlRunner>();
        }
        if (sqlText == null) {
            sqlText = !runAsScript ? this.selectSqlToRun() : this.sqlArea.getValue();
            String string = sqlText = sqlText != null ? sqlText.trim() : null;
        }
        if (StringUtils.isNotBlank((CharSequence)sqlText)) {
            TabSheet.EnhancedTab executingTab;
            HorizontalLayout executingLayout = new HorizontalLayout();
            executingLayout.setMargin(true);
            executingLayout.setSizeFull();
            Label label = new Label("Executing:\n\n" + StringUtils.abbreviate((String)sqlText, (int)250));
            label.setEnabled(false);
            executingLayout.add(new Component[]{label});
            executingLayout.setVerticalComponentAlignment(FlexComponent.Alignment.START, new Component[]{label});
            final String sql = sqlText;
            if (!forceNewTab && this.generalResultsTab != null) {
                this.replaceGeneralResultsWith((Component)executingLayout, VaadinIcon.SPINNER);
                executingTab = null;
            } else {
                executingTab = this.resultsTabs.add((Component)executingLayout, StringUtils.abbreviate((String)sql, (int)20), new Icon(VaadinIcon.SPINNER), tabPosition);
            }
            if (executingTab != null) {
                executingTab.setCloseable(true);
                this.resultsTabs.setSelectedTab((Component)executingTab);
            }
            final SqlRunner runner = new SqlRunner(sql, runAsScript, this.user, this.db, this.settingsProvider.get(), this, this.generalResultsTab != null);
            this.runnersInProgress.add(runner);
            runner.setConnection(this.connection);
            runner.setListener(new SqlRunner.ISqlRunnerListener(){
                private static final long serialVersionUID = 1L;

                @Override
                public void writeSql(String sql2) {
                    QueryPanel.this.appendSql(sql2);
                }

                @Override
                public void reExecute(String sql2) {
                    QueryPanel.this.reExecute(sql2);
                }

                @Override
                public void finished(VaadinIcon icon, List<Component> results, long executionTimeInMs, boolean transactionStarted, boolean transactionEnded) {
                    UI ui = QueryPanel.this.getUI().orElse(null);
                    if (ui != null) {
                        ui.access((Command & Serializable)() -> {
                            try {
                                if (transactionEnded) {
                                    QueryPanel.this.transactionEnded();
                                } else if (transactionStarted) {
                                    QueryPanel.this.rollbackButtonValue = true;
                                    QueryPanel.this.commitButtonValue = true;
                                    QueryPanel.this.setButtonsEnabled();
                                    QueryPanel.this.sqlArea.setClassName("transaction-in-progress");
                                    QueryPanel.this.connection = runner.getConnection();
                                }
                                QueryPanel.this.addToSqlHistory(StringUtils.abbreviate((String)sql, (int)8192), runner.getStartTime(), executionTimeInMs, QueryPanel.this.user);
                                for (Object resultComponent : results) {
                                    ((HasSize)resultComponent).setSizeFull();
                                    if (forceNewTab || QueryPanel.this.generalResultsTab == null || results.size() > 1) {
                                        if (resultComponent instanceof TabularResultLayout) {
                                            resultComponent = ((TabularResultLayout)((Object)((Object)resultComponent))).refreshWithoutSaveButton();
                                        }
                                        QueryPanel.this.addResultsTab((Component)resultComponent, StringUtils.abbreviate((String)sql, (int)20), new Icon(icon), tabPosition);
                                    } else {
                                        QueryPanel.this.replaceGeneralResultsWith((Component)resultComponent, icon);
                                        QueryPanel.this.resultsTabs.setSelectedTab(QueryPanel.this.generalResultsTab.getComponent());
                                    }
                                    String statusVal = QueryPanel.this.canceled ? "Sql canceled after " + executionTimeInMs + " ms for " + QueryPanel.this.db.getName() + ".  Finished at " + SimpleDateFormat.getTimeInstance().format(new Date()) : "Sql executed in " + executionTimeInMs + " ms for " + QueryPanel.this.db.getName() + ".  Finished at " + SimpleDateFormat.getTimeInstance().format(new Date());
                                    QueryPanel.this.status.setText(statusVal);
                                    QueryPanel.this.resultStatuses.put((Component)resultComponent, statusVal);
                                    QueryPanel.this.canceled = false;
                                }
                            }
                            finally {
                                QueryPanel.this.setButtonsEnabled();
                                if (executingTab != null) {
                                    QueryPanel.this.resultsTabs.remove(executingTab);
                                } else if (results.size() > 1) {
                                    QueryPanel.this.resetGeneralResultsTab();
                                }
                                QueryPanel.this.runnersInProgress.remove(runner);
                                runner.setListener(null);
                            }
                        });
                    }
                }
            });
            Button cancel = new Button("Cancel");
            cancel.addClickListener((ComponentEventListener & Serializable)event -> {
                log.info("Canceling sql: " + sql);
                String labelText = label.getText();
                if (labelText != null) {
                    label.setText("Canceling" + labelText.substring(9));
                } else {
                    label.setText("Canceling:\n\n" + StringUtils.abbreviate((String)sql, (int)250));
                }
                executingLayout.remove(new Component[]{cancel});
                this.canceled = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        runner.cancel();
                    }
                }).start();
            });
            executingLayout.add(new Component[]{cancel});
            scheduled = true;
            runner.start();
        }
        this.setButtonsEnabled();
        return scheduled;
    }

    public void addResultsTab(Component resultComponent, String title, Icon icon) {
        this.addResultsTab(resultComponent, title, icon, this.resultsTabs.getComponentCount());
    }

    public void addResultsTab(Component resultComponent, String title, Icon icon, int position) {
        TabSheet.EnhancedTab tab = this.resultsTabs.add(resultComponent, title, icon, position);
        this.resultsTabs.setCloseable(true);
        this.resultsTabs.setSelectedTab(title);
        if (this.errorTab != null) {
            this.resultsTabs.remove(this.errorTab);
            this.errorTab = null;
        }
        if (this.maxNumberOfResultTabs > 0 && this.resultsTabs.getTabCount() > this.maxNumberOfResultTabs) {
            this.resultsTabs.remove(this.resultsTabs.getTab(this.resultsTabs.getTabCount() - 1));
        }
        if (icon.equals(new Icon(VaadinIcon.STOP))) {
            this.errorTab = tab;
        }
    }

    public void commit() {
        try {
            SqlRunner.commit(this.connection);
        }
        catch (Exception ex) {
            Notification.show((String)ex.getMessage());
        }
        finally {
            this.commitButtonValue = false;
            this.rollbackButtonValue = false;
            this.setButtonsEnabled();
            this.connection = null;
        }
    }

    public void transactionEnded() {
        this.commitButtonValue = false;
        this.rollbackButtonValue = false;
        this.setButtonsEnabled();
        this.connection = null;
    }

    public void rollback() {
        try {
            SqlRunner.rollback(this.connection);
        }
        catch (Exception ex) {
            Notification.show((String)ex.getMessage());
        }
        finally {
            this.commitButtonValue = false;
            this.rollbackButtonValue = false;
            this.setButtonsEnabled();
            this.connection = null;
        }
    }

    protected String selectSqlToRun() {
        boolean selected;
        String delimiter = this.settingsProvider.get().getProperties().get("sql.explorer.delimiter");
        String sql = this.sqlArea.getValue();
        String selectedText = this.sqlArea.getSelection().getSelectedText();
        boolean bl = selected = selectedText != null && !selectedText.trim().isEmpty();
        if (selected) {
            sql = this.sqlArea.getSelection().getSelectedText();
        } else {
            StringBuilder sqlBuffer = new StringBuilder();
            String[] lines = sql.split("\n");
            int cursorPosition = this.sqlArea.getCursorPosition().getRow();
            boolean pastCursor = false;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i == cursorPosition) {
                    pastCursor = true;
                }
                if (!pastCursor) {
                    if (line.trim().endsWith(delimiter) || line.trim().equals("")) {
                        sqlBuffer.setLength(0);
                        continue;
                    }
                    sqlBuffer.append(line).append("\n");
                    continue;
                }
                if (line.trim().endsWith(delimiter)) {
                    sqlBuffer.append(line);
                    break;
                }
                if (line.trim().equals("")) break;
                sqlBuffer.append(line).append("\n");
            }
            sql = sqlBuffer.toString();
        }
        sql = sql.trim();
        if (sql.endsWith(delimiter)) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    public void setAutoCompleteEnabled(boolean enabled) {
        if (this.suggester == null) {
            this.suggester = new SqlSuggester(this.db, this.editor);
        }
        this.suggester.setEnabled(enabled);
    }

    static class DummyChangeListener
    implements ComponentEventListener<AceSelectionChanged>,
    Serializable {
        private static final long serialVersionUID = 1L;

        DummyChangeListener() {
        }

        public void onComponentEvent(AceSelectionChanged event) {
        }
    }
}

