/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.io.Serializable;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.sqlexplorer.DbExportDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.DbFillDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.DbImportDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.IButtonBar;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.IDbMenuItem;
import org.jumpmind.vaadin.ui.sqlexplorer.ISettingsProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.QueryPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlHistoryDialog;

public class DefaultButtonBar
implements IButtonBar,
Serializable {
    private static final long serialVersionUID = 1L;
    MenuItem executeAtCursorButton;
    MenuItem executeScriptButton;
    MenuItem commitButton;
    MenuItem rollbackButton;
    MenuItem databaseExplorerButton;
    MenuItem historyButton;
    MenuItem settingsButton;
    MenuItem importButton;
    MenuItem exportButton;
    MenuItem fillButton;
    IDbMenuItem[] additionalMenuItems;
    QueryPanel queryPanel;
    ISettingsProvider settingsProvider;
    IDb db;

    protected void init(IDb db, ISettingsProvider settingsProvider, QueryPanel queryPanel, IDbMenuItem ... additionalMenuItems) {
        this.db = db;
        this.settingsProvider = settingsProvider;
        this.queryPanel = queryPanel;
        this.additionalMenuItems = additionalMenuItems;
    }

    @Override
    public void setCommitButtonEnabled(boolean enabled) {
        this.commitButton.setEnabled(enabled);
    }

    @Override
    public void setExecuteAtCursorButtonEnabled(boolean enabled) {
        this.executeAtCursorButton.setEnabled(enabled);
    }

    @Override
    public void setExecuteScriptButtonEnabled(boolean enabled) {
        this.executeScriptButton.setEnabled(enabled);
    }

    @Override
    public void setRollbackButtonEnabled(boolean enabled) {
        this.rollbackButton.setEnabled(enabled);
    }

    protected void populate(MenuBar menuBar) {
        this.executeAtCursorButton = menuBar.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.PLAY), (ComponentEventListener & Serializable)event -> this.queryPanel.requestExecutionAtCursor());
        this.executeAtCursorButton.getElement().setAttribute("title", "Run sql under cursor (CTRL+ENTER)");
        this.executeScriptButton = menuBar.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.FORWARD), (ComponentEventListener & Serializable)event -> this.queryPanel.requestScriptExecution());
        this.executeScriptButton.getElement().setAttribute("title", "Run as script");
        this.commitButton = menuBar.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.ARROW_CIRCLE_RIGHT_O), (ComponentEventListener & Serializable)event -> this.queryPanel.commit());
        this.commitButton.getElement().getClassList().add((Object)"green");
        this.commitButton.getElement().setAttribute("title", "Commit");
        this.commitButton.setEnabled(false);
        this.rollbackButton = menuBar.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.ARROW_CIRCLE_LEFT_O), (ComponentEventListener & Serializable)event -> this.queryPanel.rollback());
        this.rollbackButton.getElement().getClassList().add((Object)"red");
        this.rollbackButton.getElement().setAttribute("title", "Rollback");
        this.rollbackButton.setEnabled(false);
        this.historyButton = menuBar.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.SEARCH), (ComponentEventListener & Serializable)event -> new SqlHistoryDialog(this.settingsProvider, this.queryPanel).showAtSize(0.6));
        this.historyButton.getElement().setAttribute("title", "Sql History");
        this.historyButton.setEnabled(true);
        MenuItem optionsButton = menuBar.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.TASKS));
        optionsButton.getElement().setAttribute("title", "Options");
        SubMenu optionsSubMenu = (SubMenu)optionsButton.getSubMenu();
        HorizontalLayout importLayout = new HorizontalLayout();
        Icon importIcon = new Icon(VaadinIcon.DOWNLOAD);
        importIcon.setSize("16px");
        importLayout.add(new Component[]{importIcon, new Span("DB Import")});
        importLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{importIcon});
        this.importButton = optionsSubMenu.addItem((Component)importLayout, (ComponentEventListener & Serializable)event -> new DbImportDialog(this.db.getPlatform()).showAtSize(0.6));
        this.importButton.setEnabled(this.settingsProvider.get().isAllowImport());
        HorizontalLayout exportLayout = new HorizontalLayout();
        Icon exportIcon = new Icon(VaadinIcon.UPLOAD);
        exportIcon.setSize("16px");
        exportLayout.add(new Component[]{exportIcon, new Span("DB Export")});
        exportLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{exportIcon});
        this.exportButton = optionsSubMenu.addItem((Component)exportLayout, (ComponentEventListener & Serializable)event -> {
            String excludeTablesRegex = this.settingsProvider.get().getProperties().get("sql.explorer.exclude.tables.regex");
            new DbExportDialog(this.db.getPlatform(), this.queryPanel, excludeTablesRegex).showAtSize(0.6);
        });
        this.exportButton.setEnabled(this.settingsProvider.get().isAllowExport());
        HorizontalLayout fillLayout = new HorizontalLayout();
        Icon fillIcon = new Icon(VaadinIcon.FILL);
        fillIcon.setSize("16px");
        fillLayout.add(new Component[]{fillIcon, new Span("DB Fill")});
        fillLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{fillIcon});
        this.fillButton = optionsSubMenu.addItem((Component)fillLayout, (ComponentEventListener & Serializable)event -> {
            String excludeTablesRegex = this.settingsProvider.get().getProperties().get("sql.explorer.exclude.tables.regex");
            new DbFillDialog(this.db.getPlatform(), this.queryPanel, excludeTablesRegex).showAtSize(0.6);
        });
        this.fillButton.setEnabled(this.settingsProvider.get().isAllowFill());
        for (IDbMenuItem item : this.additionalMenuItems) {
            HorizontalLayout layout = new HorizontalLayout();
            Icon icon = item.getIcon();
            icon.setSize("16px");
            layout.add(new Component[]{icon, new Span(item.getCaption())});
            layout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{icon});
            MenuItem button = optionsSubMenu.addItem((Component)layout, item.getListener());
            if (item.getListener() != null) continue;
            button.setEnabled(false);
        }
    }
}

