/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.vaadin.ui.sqlexplorer.DbTree;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;

public class DbTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String description;
    protected String type;
    protected VaadinIcon icon;
    protected TypedProperties properties = new TypedProperties();
    protected DbTreeNode parent;
    protected List<DbTreeNode> children = new ArrayList<DbTreeNode>();
    protected DbTree dbTree;

    public DbTreeNode(DbTree dbTree, String name, String type, VaadinIcon icon, DbTreeNode parent) {
        this.name = name;
        this.type = type;
        this.parent = parent;
        this.icon = icon;
        this.dbTree = dbTree;
    }

    public DbTreeNode(DbTree dbTree, String type, DbTreeNode parent) {
        this.name = "<empty>";
        this.type = type;
        this.parent = parent;
        this.dbTree = dbTree;
    }

    public DbTreeNode() {
    }

    public void setParent(DbTreeNode parent) {
        this.parent = parent;
    }

    public DbTreeNode getParent() {
        return this.parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public List<DbTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<DbTreeNode> children) {
        this.children = children;
    }

    public DbTreeNode find(DbTreeNode node) {
        if (this.equals(node)) {
            return this;
        }
        if (this.children != null && this.children.size() > 0) {
            for (DbTreeNode child : this.children) {
                if (!child.equals(node)) continue;
                return child;
            }
            for (DbTreeNode child : this.children) {
                DbTreeNode target = child.find(node);
                if (target == null) continue;
                return target;
            }
        }
        return null;
    }

    protected Table getTableFor() {
        IDb db = this.dbTree.getDbForNode(this);
        IDatabasePlatform platform = db.getPlatform();
        TypedProperties nodeProperties = this.getProperties();
        return platform.getTableFromCache(nodeProperties.get("catalogName"), nodeProperties.get("schemaName"), this.name, false);
    }

    public boolean delete(DbTreeNode node) {
        if (this.children != null && this.children.size() > 0) {
            Iterator<DbTreeNode> it = this.children.iterator();
            while (it.hasNext()) {
                DbTreeNode child = it.next();
                if (!child.equals(node)) continue;
                it.remove();
                return true;
            }
            for (DbTreeNode child : this.children) {
                if (!child.delete(node)) continue;
                return true;
            }
        }
        return false;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setIcon(VaadinIcon icon) {
        this.icon = icon;
    }

    public VaadinIcon getIcon() {
        return this.icon;
    }

    public List<String> findTreeNodeNamesOfType(String type) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.getType().equals(type)) {
            names.add(this.getName());
        }
        this.findTreeNodeNamesOfType(type, this.getChildren(), names);
        return names;
    }

    public void findTreeNodeNamesOfType(String type, List<DbTreeNode> treeNodes, List<String> names) {
        for (DbTreeNode treeNode : treeNodes) {
            if (treeNode.getType().equals(type)) {
                names.add(treeNode.getName());
            }
            this.findTreeNodeNamesOfType(type, treeNode.getChildren(), names);
        }
    }

    public void setProperties(TypedProperties properties) {
        this.properties = properties;
    }

    public TypedProperties getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbTreeNode other = (DbTreeNode)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

