/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.server.streams.FileFactory;
import com.vaadin.flow.server.streams.FileUploadCallback;
import com.vaadin.flow.server.streams.UploadHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.io.data.DbImport;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbImportDialog
extends ResizableDialog {
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Set<Table> selectedTablesSet;
    private Table selectedTable;
    private Scroller importLayout;
    private ComboBox<DbImportFormat> formatSelect;
    private Checkbox force;
    private Checkbox ignoreConflicts;
    private Checkbox ignoreMissingTables;
    private Checkbox replace;
    private Checkbox convertUniIndexes;
    private ComboBox<String> schemaSelect;
    private ComboBox<String> catalogSelect;
    private ComboBox<String> listOfTablesSelect;
    private TextField commitField;
    private Checkbox alter;
    private Checkbox alterCase;
    private Button cancelButton;
    private DbImport dbImport;
    private Upload upload;
    private DbImport.Format format;
    private IDatabasePlatform databasePlatform;

    public DbImportDialog(IDatabasePlatform databasePlatform) {
        this(databasePlatform, new HashSet<Table>(0));
    }

    public DbImportDialog(IDatabasePlatform databasePlatform, Set<Table> selectedTableSet) {
        super("Database Import");
        this.selectedTablesSet = selectedTableSet;
        this.databasePlatform = databasePlatform;
        this.setCloseOnOutsideClick(false);
        this.createImportLayout();
    }

    protected void createImportLayout() {
        VerticalLayout importContent = new VerticalLayout();
        importContent.setSizeFull();
        importContent.setMargin(false);
        importContent.setSpacing(false);
        importContent.add(new Component[]{new NativeLabel("Please select from the following options")});
        FormLayout formLayout = new FormLayout();
        formLayout.setSizeFull();
        importContent.addAndExpand(new Component[]{formLayout});
        this.formatSelect = new ComboBox("Format");
        this.formatSelect.setItems((ComboBox.ItemFilter & Serializable)(format, filter) -> !CommonUiUtils.isFilteredOut(Objects.toString(format, null), filter), (Object[])DbImportFormat.values());
        this.formatSelect.setValue((Object)DbImportFormat.SQL);
        this.formatSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            DbImportFormat format = (DbImportFormat)((Object)((Object)((Object)this.formatSelect.getValue())));
            switch (format) {
                case XML: {
                    this.listOfTablesSelect.setEnabled(false);
                    this.alter.setEnabled(true);
                    this.alterCase.setEnabled(true);
                    this.ignoreConflicts.setEnabled(false);
                    this.ignoreMissingTables.setEnabled(false);
                    this.replace.setEnabled(false);
                    break;
                }
                case SQL: 
                case SYM_XML: 
                case CSV: 
                case CSV_DQUOTE: {
                    this.listOfTablesSelect.setEnabled(true);
                    this.alter.setEnabled(false);
                    this.alterCase.setEnabled(false);
                    this.ignoreConflicts.setEnabled(true);
                    this.ignoreMissingTables.setEnabled(true);
                    this.replace.setEnabled(true);
                }
            }
        });
        formLayout.add(new Component[]{this.formatSelect});
        this.catalogSelect = new ComboBox("Catalog");
        this.catalogSelect.setItems((ComboBox.ItemFilter & Serializable)(catalog, filter) -> !CommonUiUtils.isFilteredOut(catalog, filter), this.getCatalogs());
        this.catalogSelect.setValue((Object)this.databasePlatform.getDefaultCatalog());
        formLayout.add(new Component[]{this.catalogSelect});
        this.schemaSelect = new ComboBox("Schema");
        this.schemaSelect.setItems((ComboBox.ItemFilter & Serializable)(schema, filter) -> !CommonUiUtils.isFilteredOut(schema, filter), this.getSchemas());
        if (this.selectedTablesSet.size() > 0) {
            this.schemaSelect.setValue((Object)this.selectedTablesSet.iterator().next().getSchema());
        } else {
            this.schemaSelect.setValue((Object)this.databasePlatform.getDefaultSchema());
        }
        this.schemaSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.populateListOfTablesSelect());
        formLayout.add(new Component[]{this.schemaSelect});
        this.listOfTablesSelect = new ComboBox("Tables");
        this.populateListOfTablesSelect();
        this.listOfTablesSelect.setEnabled(false);
        if (!this.selectedTablesSet.isEmpty()) {
            if (this.selectedTablesSet.size() == 1) {
                this.selectedTable = this.selectedTablesSet.iterator().next();
                this.listOfTablesSelect.setValue((Object)this.selectedTable.getName());
                this.selectedTablesSet.clear();
            } else {
                ArrayList<Table> list = new ArrayList<Table>(this.selectedTablesSet);
                this.listOfTablesSelect.setValue((Object)((Table)list.get(0)).getName());
                this.selectedTable = (Table)list.get(0);
                this.selectedTablesSet.clear();
            }
        }
        formLayout.add(new Component[]{this.listOfTablesSelect});
        this.commitField = new TextField("Rows to Commit");
        this.commitField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.commitField.setValue((String)event.getValue()));
        this.commitField.setValueChangeMode(ValueChangeMode.LAZY);
        this.commitField.setValueChangeTimeout(200);
        this.commitField.setValue("10000");
        formLayout.add(new Component[]{this.commitField});
        this.force = new Checkbox("Ignore any errors and continue");
        formLayout.add(new Component[]{this.force});
        this.ignoreConflicts = new Checkbox("Skip rows with conflicts");
        formLayout.add(new Component[]{this.ignoreConflicts});
        this.ignoreMissingTables = new Checkbox("Skip rows with missing tables");
        formLayout.add(new Component[]{this.ignoreMissingTables});
        this.replace = new Checkbox("Replace rows with conflicts");
        formLayout.add(new Component[]{this.replace});
        this.convertUniIndexes = new Checkbox("Convert unique indexes to non-unique when one of the columns is defined as not required");
        this.convertUniIndexes.setValue((Object)true);
        formLayout.add(new Component[]{this.convertUniIndexes});
        this.alter = new Checkbox("Alter existing tables, if needed");
        this.alter.setEnabled(false);
        this.alter.setValue((Object)true);
        formLayout.add(new Component[]{this.alter});
        this.alterCase = new Checkbox("Match default case of database");
        this.alterCase.setEnabled(false);
        this.alterCase.setValue((Object)true);
        formLayout.add(new Component[]{this.alterCase});
        this.upload = new Upload((UploadHandler)UploadHandler.toFile((FileUploadCallback & Serializable)(metadata, file) -> {
            this.createDbImport();
            try {
                this.doDbImport(file);
                this.close();
                Notification successNotification = new Notification("Successful Import", 10000);
                successNotification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                successNotification.open();
            }
            catch (Exception e) {
                this.log.warn(e.getMessage(), (Throwable)e);
                Notification errorNotification = new Notification(e.getMessage(), 10000);
                errorNotification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
                errorNotification.open();
            }
            finally {
                file.delete();
            }
        }, (FileFactory & Serializable)metadata -> File.createTempFile("dbimport", ((DbImportFormat)((Object)((Object)((Object)this.formatSelect.getValue())))).toString())));
        this.upload.setMaxFiles(100);
        this.upload.setDropAllowed(false);
        Button uploadButton = new Button("Import");
        uploadButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.upload.setUploadButton((Component)uploadButton);
        formLayout.add(new Component[]{this.upload});
        this.importLayout = new Scroller((Component)importContent);
        this.importLayout.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
        this.importLayout.setSizeFull();
        this.cancelButton = new Button("Cancel", (ComponentEventListener & Serializable)event -> this.close());
        this.add((Component)this.importLayout, 1);
        this.buildButtonFooter(new Component[]{this.cancelButton, this.upload});
    }

    protected void doDbImport(File file) throws FileNotFoundException {
        if (this.format.toString().equals("CSV") || this.format.toString().equals("CSV_DQUOTE")) {
            this.dbImport.importTables((InputStream)new BufferedInputStream(new FileInputStream(file)), ((String)this.listOfTablesSelect.getValue()).toString());
        } else {
            this.dbImport.importTables((InputStream)new BufferedInputStream(new FileInputStream(file)));
        }
    }

    protected void createDbImport() {
        this.dbImport = new DbImport(this.databasePlatform);
        this.format = DbImport.Format.valueOf((String)((DbImportFormat)((Object)this.formatSelect.getValue())).toString());
        this.dbImport.setFormat(this.format);
        this.dbImport.setCatalog((String)this.catalogSelect.getValue());
        this.dbImport.setSchema((String)this.schemaSelect.getValue());
        this.dbImport.setCommitRate(Long.parseLong(this.commitField.getValue()));
        this.dbImport.setForceImport(((Boolean)this.force.getValue()).booleanValue());
        this.dbImport.setIgnoreCollisions(((Boolean)this.ignoreConflicts.getValue()).booleanValue());
        this.dbImport.setIgnoreMissingTables(((Boolean)this.ignoreMissingTables.getValue()).booleanValue());
        this.dbImport.setAlterTables(((Boolean)this.alter.getValue()).booleanValue());
        this.dbImport.setAlterCaseToMatchDatabaseDefaultCase(((Boolean)this.alterCase.getValue()).booleanValue());
        this.dbImport.setCreateIndexConvertUniqueToNonuniqueWhenColumnsNotRequired(((Boolean)this.convertUniIndexes.getValue()).booleanValue());
    }

    protected boolean importButtonEnable() {
        if (this.formatSelect.getValue() != null && !this.commitField.getValue().equals("")) {
            if (((DbImportFormat)((Object)this.formatSelect.getValue())).toString().equals("CSV") || ((DbImportFormat)((Object)this.formatSelect.getValue())).toString().equals("CSV_DQUOTE")) {
                if (this.listOfTablesSelect.getValue() != null) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected void populateListOfTablesSelect() {
        this.listOfTablesSelect.clear();
        this.listOfTablesSelect.setItems((ComboBox.ItemFilter & Serializable)(table, filter) -> !CommonUiUtils.isFilteredOut(table, filter), this.getTables());
    }

    public String getSelectedSchema() {
        String schemaName = (String)this.schemaSelect.getValue();
        if (schemaName != null && schemaName.equals(this.databasePlatform.getDefaultSchema())) {
            schemaName = null;
        }
        return StringUtils.isBlank((CharSequence)schemaName) ? null : schemaName;
    }

    public String getSelectedCatalog() {
        String catalogName = (String)this.catalogSelect.getValue();
        if (catalogName != null && catalogName.equals(this.databasePlatform.getDefaultCatalog())) {
            catalogName = null;
        }
        return StringUtils.isBlank((CharSequence)catalogName) ? null : catalogName;
    }

    public List<String> getSchemas() {
        return this.databasePlatform.getDdlReader().getSchemaNames(null);
    }

    public List<String> getCatalogs() {
        return this.databasePlatform.getDdlReader().getCatalogNames();
    }

    public List<String> getTables() {
        return this.databasePlatform.getDdlReader().getTableNames((String)this.catalogSelect.getValue(), (String)this.schemaSelect.getValue(), new String[]{"TABLE"});
    }

    static enum DbImportFormat {
        SQL,
        XML,
        CSV,
        SYM_XML,
        CSV_DQUOTE;

    }
}

