/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.io.data.DbExport;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.QueryPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.TableSelectionLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbExportDialog
extends ResizableDialog {
    private static final String EXPORT_TO_THE_SQL_EDITOR = "Export to the SQL Editor";
    private static final String EXPORT_AS_A_FILE = "Export as a File";
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ComboBox<DbExportFormat> formatSelect;
    private ComboBox<DbExport.Compatible> compatibilitySelect;
    private Checkbox data;
    private Checkbox createInfo;
    private Checkbox foreignKeys;
    private Checkbox indices;
    private Checkbox quotedIdentifiers;
    private Checkbox dropTables;
    private TextArea whereClauseField;
    private Button previousButton;
    private Button cancelButton;
    public Button nextButton;
    private ShortcutRegistration nextShortcutRegistration;
    private Button exportFileButton;
    private ShortcutRegistration exportFileShortcutRegistration;
    private Button exportEditorButton;
    private ShortcutRegistration exportEditorShortcutRegistration;
    private Button doneButton;
    private ShortcutRegistration doneShortcutRegistration;
    private TableSelectionLayout tableSelectionLayout;
    private Scroller optionLayout;
    private Anchor fileDownloader;
    private DbExport dbExport;
    private RadioButtonGroup<String> exportFormatOptionGroup;
    private QueryPanel queryPanel;
    private IDatabasePlatform databasePlatform;

    public DbExportDialog(IDatabasePlatform databasePlatform, QueryPanel queryPanel, String excludeTablesRegex) {
        this(databasePlatform, new HashSet<Table>(), queryPanel, excludeTablesRegex);
    }

    public DbExportDialog(IDatabasePlatform databasePlatform, Set<Table> selectedTableSet, QueryPanel queryPanel, String excludeTablesRegex) {
        super("Database Export");
        this.databasePlatform = databasePlatform;
        this.queryPanel = queryPanel;
        this.setWidth("700px");
        this.setCloseOnOutsideClick(false);
        this.tableSelectionLayout = new TableSelectionLayout(databasePlatform, selectedTableSet, excludeTablesRegex){
            private static final long serialVersionUID = 1L;

            @Override
            protected void selectionChanged() {
                DbExportDialog.this.nextButton.setEnabled(DbExportDialog.this.tableSelectionLayout.getSelectedTables().size() > 0);
            }
        };
        this.tableSelectionLayout.setHeight("318px");
        this.createOptionLayout();
        this.add((Component)this.tableSelectionLayout, 1);
        this.addButtons();
        this.nextShortcutRegistration = this.nextButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
    }

    protected void addButtons() {
        this.nextButton = CommonUiUtils.createPrimaryButton("Next");
        this.nextButton.setEnabled(this.tableSelectionLayout.getSelectedTables().size() > 0);
        this.nextButton.addClickListener((ComponentEventListener & Serializable)event -> this.next());
        this.cancelButton = new Button("Cancel", (ComponentEventListener & Serializable)event -> this.close());
        this.previousButton = new Button("Previous", (ComponentEventListener & Serializable)event -> this.previous());
        this.previousButton.setVisible(false);
        this.exportEditorButton = CommonUiUtils.createPrimaryButton("Export", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            this.exportToEditor();
            this.close();
        });
        this.exportEditorButton.setVisible(false);
        this.doneButton = new Button("Close", (ComponentEventListener & Serializable)event -> this.close());
        this.doneButton.setVisible(false);
        this.exportFileButton = CommonUiUtils.createPrimaryButton("Export", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            if (this.exportFileShortcutRegistration != null) {
                this.exportFileShortcutRegistration.remove();
                this.exportFileShortcutRegistration = null;
            }
            if (this.doneShortcutRegistration == null) {
                this.doneShortcutRegistration = this.doneButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
            }
        });
        this.buildFileDownloader();
        this.fileDownloader.setVisible(false);
        this.buildButtonFooter((Component[])new Button[0], new Component[]{this.cancelButton, this.previousButton, this.nextButton, this.fileDownloader, this.exportEditorButton, this.doneButton});
    }

    protected void createOptionLayout() {
        VerticalLayout optionContent = new VerticalLayout();
        optionContent.setMargin(false);
        optionContent.setSpacing(true);
        optionContent.setSizeFull();
        optionContent.add(new Component[]{new Span("Please choose from the following options")});
        FormLayout formLayout = new FormLayout();
        formLayout.setSizeFull();
        optionContent.addAndExpand(new Component[]{formLayout});
        this.formatSelect = new ComboBox("Format");
        this.formatSelect.setItems((ComboBox.ItemFilter & Serializable)(format, filter) -> !CommonUiUtils.isFilteredOut(Objects.toString(format, null), filter), Arrays.asList(DbExportFormat.values()));
        this.formatSelect.setValue((Object)DbExportFormat.SQL);
        this.formatSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            switch ((DbExportFormat)((Object)((Object)((Object)this.formatSelect.getValue())))) {
                case SQL: {
                    this.compatibilitySelect.setEnabled(true);
                    this.setDefaultCompatibility();
                    this.data.setEnabled(true);
                    this.foreignKeys.setEnabled(true);
                    this.indices.setEnabled(true);
                    this.quotedIdentifiers.setEnabled(true);
                    break;
                }
                case XML: {
                    this.compatibilitySelect.setEnabled(false);
                    this.compatibilitySelect.setValue(null);
                    this.data.setEnabled(true);
                    this.foreignKeys.setEnabled(true);
                    this.indices.setEnabled(true);
                    this.quotedIdentifiers.setEnabled(true);
                    break;
                }
                case CSV: 
                case CSV_DQUOTE: 
                case SYM_XML: {
                    this.compatibilitySelect.setEnabled(false);
                    this.compatibilitySelect.setValue(null);
                    this.data.setEnabled(false);
                    this.foreignKeys.setEnabled(false);
                    this.indices.setEnabled(false);
                    this.quotedIdentifiers.setEnabled(false);
                }
            }
            this.buildFileDownloader();
        });
        this.formatSelect.setValue((Object)DbExportFormat.SQL);
        formLayout.add(new Component[]{this.formatSelect});
        List<DbExport.Compatible> compatibilityList = Arrays.asList(DbExport.Compatible.values());
        compatibilityList.sort((c0, c1) -> c0.name().compareTo(c1.name()));
        this.compatibilitySelect = new ComboBox("Compatibility");
        this.compatibilitySelect.setItems((ComboBox.ItemFilter & Serializable)(compatibile, filter) -> !CommonUiUtils.isFilteredOut(Objects.toString(compatibile, null), filter), compatibilityList);
        this.setDefaultCompatibility();
        formLayout.add(new Component[]{this.compatibilitySelect});
        this.createInfo = new Checkbox("Create Tables");
        formLayout.add(new Component[]{this.createInfo});
        this.dropTables = new Checkbox("Drop Tables");
        formLayout.add(new Component[]{this.dropTables});
        this.data = new Checkbox("Insert Data");
        this.data.setValue((Object)true);
        formLayout.add(new Component[]{this.data});
        this.foreignKeys = new Checkbox("Create Foreign Keys");
        formLayout.add(new Component[]{this.foreignKeys});
        this.indices = new Checkbox("Create Indices");
        formLayout.add(new Component[]{this.indices});
        this.quotedIdentifiers = new Checkbox("Qualify with Quoted Identifiers");
        formLayout.add(new Component[]{this.quotedIdentifiers});
        this.whereClauseField = new TextArea("Where Clause");
        this.whereClauseField.setWidthFull();
        formLayout.add(new Component[]{this.whereClauseField});
        this.exportFormatOptionGroup = new RadioButtonGroup();
        this.exportFormatOptionGroup.setLabel("Export Format");
        ArrayList<String> formatList = new ArrayList<String>();
        formatList.add(EXPORT_AS_A_FILE);
        if (this.queryPanel != null) {
            formatList.add(EXPORT_TO_THE_SQL_EDITOR);
        }
        this.exportFormatOptionGroup.setItems(formatList);
        this.exportFormatOptionGroup.setValue((Object)EXPORT_AS_A_FILE);
        this.exportFormatOptionGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.setExportButtonsEnabled());
        formLayout.add(new Component[]{this.exportFormatOptionGroup});
        this.optionLayout = new Scroller((Component)optionContent);
        this.optionLayout.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
        this.optionLayout.setSizeFull();
    }

    protected void setDefaultCompatibility() {
        try {
            this.compatibilitySelect.setValue((Object)DbExport.Compatible.valueOf((String)this.databasePlatform.getName().toUpperCase()));
        }
        catch (Exception ex) {
            this.compatibilitySelect.setValue((Object)DbExport.Compatible.ORACLE);
        }
    }

    protected void setExportButtonsEnabled() {
        if (((String)this.exportFormatOptionGroup.getValue()).equals(EXPORT_AS_A_FILE)) {
            this.exportEditorButton.setVisible(false);
            this.fileDownloader.setVisible(true);
            if (this.exportEditorShortcutRegistration != null) {
                this.exportEditorShortcutRegistration.remove();
                this.exportEditorShortcutRegistration = null;
            }
            if (this.exportFileShortcutRegistration == null) {
                this.exportFileShortcutRegistration = Shortcuts.addShortcutListener((Component)this.exportFileButton, (Command & Serializable)() -> {
                    UI.getCurrent().getPage().executeJs("$0.click();", new Serializable[]{this.fileDownloader.getElement()});
                    if (this.exportFileShortcutRegistration != null) {
                        this.exportFileShortcutRegistration.remove();
                        this.exportFileShortcutRegistration = null;
                    }
                    if (this.doneShortcutRegistration == null) {
                        this.doneShortcutRegistration = this.doneButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
                    }
                }, (Key)Key.ENTER, (KeyModifier[])new KeyModifier[0]);
            }
        } else {
            this.fileDownloader.setVisible(false);
            this.exportEditorButton.setVisible(true);
            if (this.exportFileShortcutRegistration != null) {
                this.exportFileShortcutRegistration.remove();
                this.exportFileShortcutRegistration = null;
            }
            if (this.exportEditorShortcutRegistration == null) {
                this.exportEditorShortcutRegistration = this.exportEditorButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
            }
        }
        this.doneButton.setVisible(true);
        this.cancelButton.setVisible(false);
    }

    protected void previous() {
        this.innerContent.remove(new Component[]{this.optionLayout});
        this.innerContent.addComponentAtIndex(0, (Component)this.tableSelectionLayout);
        this.innerContent.expand(new Component[]{this.tableSelectionLayout});
        this.previousButton.setVisible(false);
        this.exportEditorButton.setVisible(false);
        if (this.exportEditorShortcutRegistration != null) {
            this.exportEditorShortcutRegistration.remove();
            this.exportEditorShortcutRegistration = null;
        }
        this.fileDownloader.setVisible(false);
        if (this.exportFileShortcutRegistration != null) {
            this.exportFileShortcutRegistration.remove();
            this.exportFileShortcutRegistration = null;
        }
        this.doneButton.setVisible(false);
        if (this.doneShortcutRegistration != null) {
            this.doneShortcutRegistration.remove();
            this.doneShortcutRegistration = null;
        }
        this.nextButton.setVisible(true);
        this.nextShortcutRegistration = this.nextButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        this.cancelButton.setVisible(true);
    }

    protected void next() {
        this.innerContent.remove(new Component[]{this.tableSelectionLayout});
        this.innerContent.addComponentAtIndex(0, (Component)this.optionLayout);
        this.innerContent.expand(new Component[]{this.optionLayout});
        this.nextButton.setVisible(false);
        if (this.nextShortcutRegistration != null) {
            this.nextShortcutRegistration.remove();
            this.nextShortcutRegistration = null;
        }
        this.previousButton.setVisible(true);
        this.setExportButtonsEnabled();
    }

    protected void createDbExport() {
        this.dbExport = new DbExport(this.databasePlatform);
        if (this.tableSelectionLayout.schemaSelect.getValue() != null) {
            this.dbExport.setSchema(((String)this.tableSelectionLayout.schemaSelect.getValue()).toString());
        }
        if (this.tableSelectionLayout.catalogSelect.getValue() != null) {
            this.dbExport.setCatalog(((String)this.tableSelectionLayout.catalogSelect.getValue()).toString());
        }
        this.dbExport.setNoCreateInfo((Boolean)this.createInfo.getValue() == false);
        this.dbExport.setNoData((Boolean)this.data.getValue() == false);
        this.dbExport.setNoForeignKeys((Boolean)this.foreignKeys.getValue() == false);
        this.dbExport.setNoIndices((Boolean)this.indices.getValue() == false);
        this.dbExport.setAddDropTable(((Boolean)this.dropTables.getValue()).booleanValue());
        DbExport.Format format = DbExport.Format.valueOf((String)((DbExportFormat)((Object)this.formatSelect.getValue())).toString());
        this.dbExport.setFormat(format);
        if (this.compatibilitySelect.getValue() != null) {
            DbExport.Compatible compatible = (DbExport.Compatible)this.compatibilitySelect.getValue();
            this.dbExport.setCompatible(compatible);
        }
        this.dbExport.setUseQuotedIdentifiers(((Boolean)this.quotedIdentifiers.getValue()).booleanValue());
        this.dbExport.setWhereClause(this.whereClauseField.getValue());
    }

    protected void exportToEditor() {
        List<String> list = this.tableSelectionLayout.getSelectedTables();
        String[] array = new String[list.size()];
        list.toArray(array);
        this.createDbExport();
        try {
            String script = this.dbExport.exportTables(array);
            this.queryPanel.appendSql(script);
        }
        catch (IOException e) {
            String msg = "Failed to export to the sql editor";
            this.log.error(msg, (Throwable)e);
            CommonUiUtils.notifyError(msg, opened -> this.enableEscapeShortcut(opened == false));
        }
    }

    protected void buildFileDownloader() {
        if (this.fileDownloader != null) {
            this.fileDownloader.remove(new Component[0]);
        }
        this.fileDownloader = new Anchor(this.createDownloadHandler(), null);
        this.fileDownloader.getElement().setAttribute("download", true);
        this.fileDownloader.add(new Component[]{this.exportFileButton});
        this.fileDownloader.setVisible(((String)this.exportFormatOptionGroup.getValue()).equals(EXPORT_AS_A_FILE));
        this.buildButtonFooter((Component[])new Button[0], new Component[]{this.cancelButton, this.previousButton, this.nextButton, this.fileDownloader, this.exportEditorButton, this.doneButton});
    }

    private DownloadHandler createDownloadHandler() {
        String format = ((DbExportFormat)((Object)this.formatSelect.getValue())).toString();
        if (format.equals("CSV_DQUOTE")) {
            format = "CSV";
        }
        String datetime = new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
        String fileName = String.format("table-export-%s." + format.toLowerCase(), datetime);
        return DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)event -> {
            List<String> list = this.tableSelectionLayout.getSelectedTables();
            String[] array = new String[list.size()];
            list.toArray(array);
            this.createDbExport();
            try {
                byte[] script = this.dbExport.exportTables(array).getBytes();
                return new DownloadResponse((InputStream)new ByteArrayInputStream(script), fileName, null, (long)script.length);
            }
            catch (IOException e) {
                String msg = "Failed to export to a file";
                this.log.error(msg, (Throwable)e);
                event.getUI().access((Command & Serializable)() -> CommonUiUtils.notifyError(msg, opened -> this.enableEscapeShortcut(opened == false)));
                return DownloadResponse.error((HttpStatusCode)HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        });
    }

    static enum DbExportFormat {
        SQL,
        XML,
        CSV,
        SYM_XML,
        CSV_DQUOTE;

    }
}

