/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.grid.Grid;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaDataGridCreator {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    JdbcSqlTemplate sqlTemplate;
    Table table;
    String folder;
    Settings settings;
    protected final String[] TABLE_NAME_METADATA_COLUMNS = new String[]{"TABLE_NAME", "TABLE_CATALOG", "TABLE_SCHEMA", "PKTABLE_NAME", "PKTABLE_CATALOG", "PKTABLE_SCHEMA", "TABLE_CAT", "TABLE_SCHEM"};

    public AbstractMetaDataGridCreator(JdbcSqlTemplate sqlTemplate, Table table, Settings settings) {
        this.sqlTemplate = sqlTemplate;
        this.table = table;
        this.settings = settings;
    }

    public Grid<List<Object>> create(final ColumnVisibilityToggler columnVisibilityToggler) {
        return (Grid)this.sqlTemplate.execute((IConnectionCallback)new IConnectionCallback<Grid<List<Object>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Grid<List<Object>> execute(Connection con) throws SQLException {
                Grid<List<Object>> grid;
                TypedProperties properties = AbstractMetaDataGridCreator.this.settings.getProperties();
                ResultSet rs = null;
                Grid<List<Object>> g = null;
                try {
                    DatabaseMetaData metadata = con.getMetaData();
                    rs = AbstractMetaDataGridCreator.this.getMetaDataResultSet(metadata);
                    g = CommonUiUtils.putResultsInGrid(columnVisibilityToggler, rs, Integer.MAX_VALUE, properties.is("sql.explorer.show.row.numbers"), AbstractMetaDataGridCreator.this.getColumnsToExclude());
                    g.setSizeFull();
                    grid = g;
                }
                catch (Exception ex) {
                    Grid grid2;
                    try {
                        AbstractMetaDataGridCreator.this.log.info("Failed to retrieve meta data.  It might be that this driver doesn't support it.  Turn on debug logging to see the resulting stacktrace");
                        AbstractMetaDataGridCreator.this.log.debug("", (Throwable)ex);
                        grid2 = new Grid();
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(rs);
                        throw throwable;
                    }
                    JdbcSqlTemplate.close((ResultSet)rs);
                    return grid2;
                }
                JdbcSqlTemplate.close((ResultSet)rs);
                return grid;
            }
        });
    }

    protected String[] getColumnsToExclude() {
        return new String[0];
    }

    protected abstract ResultSet getMetaDataResultSet(DatabaseMetaData var1) throws SQLException;
}

