/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.component.tabs.TabsVariant;
import java.io.Serializable;
import org.jumpmind.vaadin.ui.common.IUiPanel;
import org.jumpmind.vaadin.ui.common.TabSheet;

public class TabbedApplicationPanel
extends TabSheet {
    private static final long serialVersionUID = 1L;
    protected TabSheet.EnhancedTab mainTab;

    public TabbedApplicationPanel() {
        this.setSizeFull();
        this.addThemeVariants(TabsVariant.LUMO_SMALL);
        this.addSelectedTabChangeListener((ComponentEventListener<Tabs.SelectedChangeEvent>)(ComponentEventListener & Serializable)event -> {
            Component selected;
            if (this.tabs.getSelectedTab() != null && (selected = ((TabSheet.EnhancedTab)this.tabs.getSelectedTab()).getComponent()) instanceof IUiPanel) {
                ((IUiPanel)selected).selected();
            }
        });
    }

    public void setMainTab(String caption, Icon icon, Component component) {
        if (component instanceof HasSize) {
            ((HasSize)component).setSizeFull();
        }
        this.mainTab = this.add(component, caption, icon, 0);
    }

    public void addCloseableTab(String caption, Icon icon, Component component, boolean setSizeFull) {
        TabSheet.EnhancedTab tab = this.getTab(caption);
        if (tab != null) {
            this.tabs.setSelectedTab((Tab)tab);
            return;
        }
        if (setSizeFull && component instanceof HasSize) {
            ((HasSize)component).setSizeFull();
        }
        tab = this.add(component, caption, icon, this.mainTab == null ? 0 : 1);
        tab.setCloseable(true);
        this.tabs.setSelectedTab((Tab)tab);
    }

    public void addCloseableTab(String caption, Icon icon, Component component) {
        this.addCloseableTab(caption, icon, component, true);
    }

    @Override
    public void remove(TabSheet.EnhancedTab tab) {
        Component component = tab.getComponent();
        if (!(component instanceof IUiPanel) || ((IUiPanel)component).closing()) {
            int tabCount = this.tabList.size();
            if (tab.isSelected() && tabCount > 1) {
                int index = this.tabList.indexOf((Object)tab);
                if (index < tabCount - 1) {
                    this.tabs.setSelectedIndex(index + 1);
                } else {
                    this.tabs.setSelectedIndex(index - 1);
                }
            }
            this.tabs.remove(new Tab[]{tab});
            this.tabList.remove((Object)tab);
            if (tabCount <= 1) {
                this.content.removeAll();
            }
        }
    }
}

