/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.component.tabs.TabsVariant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class TabSheet
extends Div {
    private static final long serialVersionUID = 1L;
    protected VerticalLayout layout = new VerticalLayout();
    protected Tabs tabs;
    protected List<EnhancedTab> tabList;
    protected Div content;
    protected boolean closeable = false;

    public TabSheet() {
        this.layout.setSizeFull();
        this.layout.setSpacing(false);
        this.layout.getThemeList().remove((Object)"padding");
        this.tabs = new Tabs();
        this.tabs.setWidthFull();
        this.tabList = new ArrayList<EnhancedTab>();
        this.content = new Div();
        this.content.setSizeFull();
        this.tabs.addSelectedChangeListener((ComponentEventListener & Serializable)event -> {
            if (event.getSelectedTab() != null) {
                this.content.getChildren().forEach(element -> element.setVisible(false));
                Component component = ((EnhancedTab)event.getSelectedTab()).getComponent();
                if (component != null) {
                    List l = this.content.getChildren().filter(e -> e.equals(component)).collect(Collectors.toList());
                    if (l != null && l.size() > 0) {
                        ((Component)l.get(0)).setVisible(true);
                    } else {
                        component.setVisible(true);
                        this.content.add(new Component[]{component});
                    }
                }
            }
        });
        this.layout.add(new Component[]{this.tabs, this.content});
        this.add(new Component[]{this.layout});
    }

    public EnhancedTab add(Component component, String name) {
        EnhancedTab newTab = new EnhancedTab(name, component);
        this.tabs.add(new Tab[]{newTab});
        this.tabList.add(newTab);
        return newTab;
    }

    public EnhancedTab add(Component component, String name, Icon icon) {
        EnhancedTab newTab = new EnhancedTab(name, icon, component);
        this.tabs.add(new Tab[]{newTab});
        this.tabList.add(newTab);
        return newTab;
    }

    public EnhancedTab add(Component component, String name, int index) {
        EnhancedTab newTab = new EnhancedTab(name, component);
        this.add(newTab, index);
        return newTab;
    }

    public EnhancedTab add(Component component, String name, Icon icon, int index) {
        EnhancedTab newTab = new EnhancedTab(name, icon, component);
        this.add(newTab, index);
        return newTab;
    }

    private void add(EnhancedTab tab, int index) {
        ArrayList<EnhancedTab> oldList = new ArrayList<EnhancedTab>(this.tabList);
        this.tabList.clear();
        this.tabs.removeAll();
        Iterator tabIterator = oldList.iterator();
        for (int i = 0; i <= index || tabIterator.hasNext(); ++i) {
            if (i == index || !tabIterator.hasNext()) {
                this.tabs.add(new Tab[]{tab});
                this.tabList.add(tab);
                if (tabIterator.hasNext()) continue;
                break;
            }
            EnhancedTab nextTab = (EnhancedTab)((Object)tabIterator.next());
            this.tabs.add(new Tab[]{nextTab});
            this.tabList.add(nextTab);
        }
    }

    public void remove(String name) {
        EnhancedTab tab = this.getTab(name);
        if (tab != null) {
            this.remove(tab);
        }
    }

    public void remove(EnhancedTab tab) {
        int tabCount = this.tabList.size();
        if (tab.isSelected() && tabCount > 1) {
            int index = this.tabList.indexOf((Object)tab);
            if (index < tabCount - 1) {
                this.tabs.setSelectedIndex(index + 1);
            } else {
                this.tabs.setSelectedIndex(index - 1);
            }
        }
        this.tabs.remove(new Tab[]{tab});
        this.tabList.remove((Object)tab);
        if (tabCount <= 1) {
            this.content.removeAll();
        }
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        for (EnhancedTab tab : this.tabList) {
            tab.setCloseable(closeable);
        }
    }

    public void addThemeVariants(TabsVariant ... variants) {
        this.tabs.addThemeVariants((ThemeVariant[])variants);
    }

    public void addSelectedTabChangeListener(ComponentEventListener<Tabs.SelectedChangeEvent> listener) {
        this.tabs.addSelectedChangeListener(listener);
    }

    public EnhancedTab getSelectedTab() {
        return (EnhancedTab)this.tabs.getSelectedTab();
    }

    public EnhancedTab getTab(Component component) {
        if (component != null) {
            for (EnhancedTab tab : this.tabList) {
                if (!component.equals(tab.getComponent())) continue;
                return tab;
            }
        }
        return null;
    }

    public EnhancedTab getTab(String name) {
        for (EnhancedTab tab : this.tabList) {
            if (!tab.getName().equals(name)) continue;
            return tab;
        }
        return null;
    }

    public EnhancedTab getTab(int index) {
        return this.tabList.get(index);
    }

    public int getTabIndex(Component component) {
        if (component != null) {
            for (int i = 0; i < this.tabList.size(); ++i) {
                if (!component.equals(this.tabList.get(i).getComponent())) continue;
                return i;
            }
        }
        return -1;
    }

    public int getTabCount() {
        return this.tabList.size();
    }

    public void setSelectedTab(String name) {
        EnhancedTab tab = this.getTab(name);
        if (tab != null) {
            this.tabs.setSelectedTab((Tab)tab);
        }
    }

    public void setSelectedTab(int index) {
        EnhancedTab tab = this.getTab(index);
        if (tab != null) {
            this.tabs.setSelectedTab((Tab)tab);
        }
    }

    public void setSelectedTab(Component component) {
        EnhancedTab tab = this.getTab(component);
        if (tab != null) {
            this.tabs.setSelectedTab((Tab)tab);
        }
    }

    public Iterator<Component> iterator() {
        return this.tabList.stream().map(EnhancedTab::getComponent).iterator();
    }

    public void setAutoselect(boolean autoselect) {
        this.tabs.setAutoselect(autoselect);
    }

    public class EnhancedTab
    extends Tab {
        private static final long serialVersionUID = 1L;
        private String name;
        private Icon icon;
        private Component component;
        private Icon closeIcon;

        public EnhancedTab(String name, Component component) {
            this(name, null, component);
        }

        public EnhancedTab(String name, Icon icon, Component component) {
            this.name = name;
            this.icon = icon;
            this.component = component;
            HorizontalLayout tabHeader = new HorizontalLayout();
            if (icon != null) {
                icon.setSize("16px");
                tabHeader.add(new Component[]{icon});
                tabHeader.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{icon});
            }
            Span nameSpan = new Span(name);
            tabHeader.add(new Component[]{nameSpan});
            tabHeader.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{nameSpan});
            this.closeIcon = new Icon(VaadinIcon.CLOSE);
            this.closeIcon.setSize("16px");
            this.closeIcon.addClickListener((ComponentEventListener & Serializable)event -> TabSheet.this.remove(this));
            this.closeIcon.setVisible(TabSheet.this.closeable);
            tabHeader.add(new Component[]{this.closeIcon});
            tabHeader.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.closeIcon});
            this.add(new Component[]{tabHeader});
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component component) {
            this.component = component;
        }

        public void setCloseable(boolean closeable) {
            this.closeIcon.setVisible(closeable);
        }
    }
}

