/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.FileFactory;
import com.vaadin.flow.server.streams.FileUploadCallback;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import com.vaadin.flow.server.streams.InputStreamDownloadHandler;
import com.vaadin.flow.server.streams.UploadHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.vaadin.ui.common.NotifyDialog;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyTextAreaDialog
extends ResizableDialog {
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    VerticalLayout wrapper;
    protected List<Component> leftComponentList;
    protected TextArea textField;
    protected Select<String> displayBox;
    protected Button downloadButton;
    protected Table table;
    protected Column column;
    protected Object[] primaryKeys;
    protected IDatabasePlatform platform;

    public ReadOnlyTextAreaDialog(String title, String value, boolean isEncodedInHex) {
        this(title, value, isEncodedInHex, null);
    }

    public ReadOnlyTextAreaDialog(String title, String value, boolean isEncodedInHex, Consumer<Boolean> shortcutToggler) {
        this(title, value, null, null, null, isEncodedInHex, false, shortcutToggler);
    }

    public ReadOnlyTextAreaDialog(String title, String value, Table table, Object[] primaryKeys, IDatabasePlatform platform, boolean isEncodedInHex, boolean isLob, Consumer<Boolean> shortcutToggler) {
        super(title);
        this.table = table;
        this.primaryKeys = primaryKeys;
        this.platform = platform;
        Column column = this.column = table == null ? null : table.getColumnWithName(title);
        if (shortcutToggler != null) {
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> shortcutToggler.accept(event.isOpened()));
        }
        this.wrapper = new VerticalLayout();
        this.wrapper.setMargin(false);
        this.wrapper.setHeight("100px");
        this.wrapper.setWidthFull();
        this.textField = new TextArea();
        this.textField.setSizeFull();
        this.wrapper.add(new Component[]{this.textField});
        this.add((Component)this.wrapper, 1);
        this.leftComponentList = new ArrayList<Component>();
        if (value != null && isEncodedInHex) {
            this.displayBox = new Select();
            this.displayBox.setItems((Object[])new String[]{"Hex", "Text", "Decimal"});
            this.displayBox.setLabel("Display As");
            this.displayBox.setEmptySelectionAllowed(false);
            this.displayBox.setValue((Object)"Hex");
            this.displayBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateTextField((String)this.displayBox.getValue(), value));
            this.leftComponentList.add((Component)this.displayBox);
        }
        if (table != null && isLob) {
            this.buildUploadButton(title, value);
            this.buildDownloadButton(title);
        }
        Button closeButton = this.buildCloseButton();
        if (!this.leftComponentList.isEmpty()) {
            this.buildButtonFooter(this.leftComponentList, new Component[]{closeButton});
        } else {
            this.buildButtonFooter(new Component[]{closeButton});
        }
        this.textField.setValue(value);
        this.textField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.displayBox != null) {
                this.updateTextField((String)this.displayBox.getValue(), value);
            } else {
                this.textField.setValue(value);
            }
        });
    }

    @Override
    public void show() {
        super.show();
        this.selectAll();
    }

    private void buildUploadButton(String title, String value) {
        Button uploadButton = new Button("Upload");
        Button viewTextButton = new Button("View Text");
        Upload upload = new Upload((UploadHandler)UploadHandler.toFile((FileUploadCallback & Serializable)(metadata, file) -> {
            this.log.info("File received successfully. Updating database");
            String sql = this.buildLobUpdate(this.table.getPrimaryKeyColumns());
            Connection con = null;
            Statement ps = null;
            try {
                long startTime = System.nanoTime();
                con = ((DataSource)this.platform.getDataSource()).getConnection();
                con.setAutoCommit(false);
                ps = con.prepareStatement(sql);
                FileInputStream stream = new FileInputStream(file);
                ps.setBinaryStream(1, stream, (int)file.length());
                for (int i = 0; i < this.primaryKeys.length; ++i) {
                    ps.setObject(i + 2, this.primaryKeys[i], this.table.getPrimaryKeyColumns()[i].getMappedTypeCode());
                }
                ps.executeUpdate();
                con.commit();
                long executionTime = System.nanoTime() - startTime;
                this.log.info("Upload succeeded in " + executionTime + " ms");
                this.close();
            }
            catch (SQLException e1) {
                NotifyDialog.show("Upload Error", "<b>The file could not be uploaded.</b><br>Cause: the sql update statement failed.<br><br>To view the <b>Stack Trace</b>, click <b>\"Details\"</b>.", e1, NotificationVariant.LUMO_ERROR);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
                FileUtils.deleteQuietly((File)file);
                this.log.info("Deleted uploaded file");
            }
        }, (FileFactory & Serializable)metadata -> new File(System.getProperty("java.io.tmpdir"), metadata.fileName())));
        upload.setMaxFiles(100);
        upload.setDropLabel((Component)new Span("Upload new " + this.table.getColumnWithName(title).getMappedType()));
        uploadButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.wrapper.replace((Component)this.textField, (Component)upload);
            this.wrapper.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{upload});
            this.getFooter().removeAll();
            if (!this.leftComponentList.isEmpty()) {
                this.buildButtonFooter(this.leftComponentList, new Component[]{viewTextButton, this.buildCloseButton()});
            } else {
                this.buildButtonFooter(new Component[]{viewTextButton, this.buildCloseButton()});
            }
        });
        viewTextButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.wrapper.replace((Component)upload, (Component)this.textField);
            this.wrapper.setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.textField});
            this.getFooter().removeAll();
            if (!this.leftComponentList.isEmpty()) {
                this.buildButtonFooter(this.leftComponentList, new Component[]{uploadButton, this.buildCloseButton()});
            } else {
                this.buildButtonFooter(new Component[]{uploadButton, this.buildCloseButton()});
            }
        });
        if (value != null) {
            this.getFooter().removeAll();
            if (!this.leftComponentList.isEmpty()) {
                this.buildButtonFooter(this.leftComponentList, new Component[]{uploadButton, this.buildCloseButton()});
            } else {
                this.buildButtonFooter(new Component[]{uploadButton, this.buildCloseButton()});
            }
        } else {
            this.wrapper.replace((Component)this.textField, (Component)upload);
            this.wrapper.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{upload});
        }
    }

    private void buildDownloadButton(String title) {
        this.downloadButton = new Button("Download");
        byte[] lobData = this.getLobData(title);
        if (lobData != null) {
            InputStreamDownloadHandler downloadHandler = DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)event -> new DownloadResponse((InputStream)new ByteArrayInputStream(lobData), title, null, (long)lobData.length));
            Anchor fileDownloader = new Anchor((DownloadHandler)downloadHandler, null);
            fileDownloader.add(new Component[]{this.downloadButton});
            long fileSize = lobData.length;
            String sizeText = fileSize + " Bytes";
            if (fileSize / 1024L > 0L) {
                sizeText = Math.round((double)fileSize / 1024.0) + " kB";
                fileSize /= 1024L;
            }
            if (fileSize / 1024L > 0L) {
                sizeText = Math.round((double)fileSize / 1024.0) + " MB";
                fileSize /= 1024L;
            }
            if (fileSize / 1024L > 0L) {
                sizeText = Math.round((double)fileSize / 1024.0) + " GB";
            }
            Span sizeSpan = new Span(sizeText);
            this.getFooter().removeAll();
            if (!this.leftComponentList.isEmpty()) {
                this.buildButtonFooter(this.leftComponentList, new Component[]{fileDownloader, sizeSpan, this.buildCloseButton()});
            } else {
                this.buildButtonFooter(new Component[]{fileDownloader, sizeSpan, this.buildCloseButton()});
            }
        }
    }

    protected byte[] getLobData(String title) {
        String results;
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        String sql = this.buildLobSelect(this.table.getPrimaryKeyColumns());
        Object array = this.platform.isBlob(this.column) ? sqlTemplate.queryForBlob(sql, this.column.getJdbcTypeCode(), this.column.getJdbcTypeName(), this.primaryKeys) : (Object)((results = sqlTemplate.queryForClob(sql, this.column.getJdbcTypeCode(), this.column.getJdbcTypeName(), this.primaryKeys)) != null ? results.getBytes() : null);
        return array;
    }

    protected String buildLobSelect(Column[] pkColumns) {
        StringBuilder sql = new StringBuilder("select ");
        DatabaseInfo dbInfo = this.platform.getDatabaseInfo();
        String quote = this.platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? dbInfo.getDelimiterToken() : "";
        sql.append(quote);
        sql.append(this.column.getName());
        sql.append(quote);
        sql.append(" from ");
        sql.append(this.table.getQualifiedTableName(quote, dbInfo.getCatalogSeparator(), dbInfo.getSchemaSeparator()));
        sql.append(" where ");
        for (Column col : pkColumns) {
            sql.append(quote);
            sql.append(col.getName());
            sql.append(quote);
            sql.append("=? and ");
        }
        sql.delete(sql.length() - 5, sql.length());
        return sql.toString();
    }

    protected String buildLobUpdate(Column[] pkColumns) {
        StringBuilder sql = new StringBuilder("update ");
        DatabaseInfo dbInfo = this.platform.getDatabaseInfo();
        String quote = this.platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? dbInfo.getDelimiterToken() : "";
        sql.append(this.table.getQualifiedTableName(quote, dbInfo.getCatalogSeparator(), dbInfo.getSchemaSeparator()));
        sql.append(" set ");
        sql.append(quote);
        sql.append(this.column.getName());
        sql.append(quote);
        sql.append("=? where ");
        for (Column col : pkColumns) {
            sql.append(quote);
            sql.append(col.getName());
            sql.append(quote);
            sql.append("=? and ");
        }
        sql.delete(sql.length() - 5, sql.length());
        return sql.toString();
    }

    public void selectAll() {
        this.textField.focus();
        this.textField.getElement().executeJs("this.inputElement.select()", new Serializable[0]);
    }

    protected void updateTextField(String display, String value) {
        if (display.equals("Hex")) {
            this.textField.setValue(value);
        } else if (display.equals("Text")) {
            try {
                byte[] bytes = Hex.decodeHex((char[])value.toCharArray());
                this.textField.setValue(new String(bytes));
            }
            catch (Exception e) {
                this.log.warn("Failed to decode hex string for display", (Throwable)e);
            }
        } else if (display.equals("Decimal")) {
            try {
                byte[] bytes = Hex.decodeHex((char[])value.toCharArray());
                Object newValue = "";
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                while (buffer.hasRemaining()) {
                    if (!((String)newValue).equals("")) {
                        newValue = (String)newValue + " ";
                    }
                    newValue = (String)newValue + (buffer.get() & 0xFF);
                }
                this.textField.setValue((String)newValue);
            }
            catch (Exception e) {
                this.log.warn("Failed to decode hex string for display", (Throwable)e);
            }
        }
    }

    public static void show(String title, String value, boolean isEncodedInHex) {
        ReadOnlyTextAreaDialog.show(title, value, isEncodedInHex, null);
    }

    public static void show(String title, String value, boolean isEncodedInHex, Consumer<Boolean> shortcutToggler) {
        ReadOnlyTextAreaDialog dialog = new ReadOnlyTextAreaDialog(title, value, isEncodedInHex, shortcutToggler);
        dialog.showAtSize(0.4);
    }

    public static void show(String title, String value, Table table, Object[] primaryKeys, IDatabasePlatform platform, boolean isEncodedInHex, boolean isLob) {
        ReadOnlyTextAreaDialog dialog = new ReadOnlyTextAreaDialog(title, value, table, primaryKeys, platform, isEncodedInHex, isLob, null);
        dialog.showAtSize(0.45);
    }
}

