/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class PromptDialog
extends Dialog {
    private static final long serialVersionUID = 1L;

    public PromptDialog(String caption, String text, IPromptListener iPromptListener) {
        this(caption, text, null, iPromptListener);
    }

    public PromptDialog(String caption, String text, String defaultValue, IPromptListener promptListener) {
        this.setModal(true);
        this.setResizable(false);
        this.setSizeUndefined();
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        if (caption != null) {
            this.setHeaderTitle(caption);
        }
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(true);
        layout.setMargin(true);
        this.add(new Component[]{layout});
        if (StringUtils.isNotBlank((CharSequence)text)) {
            layout.add(new Component[]{new Span(text)});
        }
        TextField field = new TextField();
        field.setWidthFull();
        field.setValue(defaultValue);
        if (defaultValue != null) {
            UI.getCurrent().getPage().executeJs("$0.select();", new Serializable[]{field.getElement()});
            field.focus();
        }
        layout.add(new Component[]{field});
        Button cancelButton = new Button("Cancel");
        cancelButton.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.close());
        Button okButton = new Button("Ok");
        okButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        okButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        okButton.addClickListener((ComponentEventListener & Serializable)event -> {
            if (promptListener.onOk(field.getValue())) {
                this.close();
            }
        });
        this.getFooter().add(new Component[]{cancelButton, okButton});
        field.focus();
    }

    public static void prompt(String caption, String message, IPromptListener listener) {
        PromptDialog prompt = new PromptDialog(caption, message, listener);
        prompt.open();
    }

    public static interface IPromptListener
    extends Serializable {
        public boolean onOk(String var1);
    }
}

