/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;

public class Label
extends Span {
    private static final long serialVersionUID = 1L;
    private Html html;
    private Component icon;

    public Label() {
        this.getElement().getStyle().set("display", "flex");
    }

    public Label(String text) {
        this.html = new Html("<div style='width: 100%'>" + text + "</div>");
        this.getElement().getStyle().set("display", "flex");
        this.add(new Component[]{this.html});
    }

    public Label(VaadinIcon icon, String text) {
        this(new Icon(icon), text);
    }

    public Label(String text, VaadinIcon icon) {
        this(text, new Icon(icon));
    }

    public Label(Icon icon, String text) {
        this(text);
        this.setLeftIcon((Component)icon);
    }

    public Label(String text, Icon icon) {
        this(text);
        this.setRightIcon((Component)icon);
    }

    public Label(Component component) {
        this.setText(component.getElement().getOuterHTML());
        this.getElement().getStyle().set("display", "flex");
    }

    public String getText() {
        return this.getElement().getProperty("innerHTML");
    }

    public void setText(String text) {
        if (this.html != null) {
            this.remove(new Component[]{this.html});
        }
        this.html = new Html("<div style='width: 100%'>" + text + "</div>");
        this.add(new Component[]{this.html});
    }

    public void setRightIcon(VaadinIcon icon) {
        this.setRightIcon((Component)new Icon(icon));
    }

    public void setLeftIcon(VaadinIcon icon) {
        this.setLeftIcon((Component)new Icon(icon));
    }

    public void setLeftIcon(Component icon) {
        if (this.icon != null) {
            this.remove(new Component[]{this.icon});
        }
        icon.getElement().getStyle().set("align-self", "flex-start");
        icon.getElement().getStyle().set("min-width", "24px");
        icon.getElement().getStyle().set("margin-right", "5px");
        this.icon = icon;
        this.addComponentAsFirst(icon);
    }

    public void setRightIcon(Component icon) {
        if (this.icon != null) {
            this.remove(new Component[]{this.icon});
        }
        icon.getElement().getStyle().set("align-self", "flex-end");
        icon.getElement().getStyle().set("min-width", "24px");
        icon.getElement().getStyle().set("margin-left", "5px");
        this.icon = icon;
        this.add(new Component[]{icon});
    }
}

