/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;

public class CustomSplitLayout
extends SplitLayout {
    private static final long serialVersionUID = 1L;
    private static final String PRIMARY_OFFSET_HEIGHT = "element._primaryChild.offsetHeight";
    private static final String SECONDARY_OFFSET_HEIGHT = "element._secondaryChild.offsetHeight";
    private static final String PRIMARY_OFFSET_WIDTH = "element._primaryChild.offsetWidth";
    private static final String SECONDARY_OFFSET_WIDTH = "element._secondaryChild.offsetWidth";
    private String PRIMARY_SIZE = "element._primaryChild.offsetWidth";
    private String SECONDARY_SIZE = "element._secondaryChild.offsetWidth";
    private double splitterPosition;
    private double primarySizePixel;
    private double secondarySizePixel;

    public CustomSplitLayout() {
        this.init();
    }

    public CustomSplitLayout(Component primaryComponent, Component secondaryComponent) {
        super(primaryComponent, secondaryComponent);
        this.init();
    }

    private void init() {
        this.getElement().addEventListener("splitter-dragend", (DomEventListener & Serializable)e -> {
            this.primarySizePixel = e.getEventData().getNumber(this.PRIMARY_SIZE);
            this.secondarySizePixel = e.getEventData().getNumber(this.SECONDARY_SIZE);
            double totalSize = this.primarySizePixel + this.secondarySizePixel;
            this.splitterPosition = Math.round(this.primarySizePixel / totalSize * 100.0);
        }).addEventData(PRIMARY_OFFSET_WIDTH).addEventData(PRIMARY_OFFSET_HEIGHT).addEventData(SECONDARY_OFFSET_WIDTH).addEventData(SECONDARY_OFFSET_HEIGHT);
    }

    public void setOrientation(SplitLayout.Orientation orientation) {
        super.setOrientation(orientation);
        if (orientation == SplitLayout.Orientation.HORIZONTAL) {
            this.PRIMARY_SIZE = PRIMARY_OFFSET_WIDTH;
            this.SECONDARY_SIZE = SECONDARY_OFFSET_WIDTH;
        } else {
            this.PRIMARY_SIZE = PRIMARY_OFFSET_HEIGHT;
            this.SECONDARY_SIZE = SECONDARY_OFFSET_HEIGHT;
        }
    }

    public Double getSplitterPosition() {
        return this.splitterPosition;
    }

    public void setSplitterPosition(double position) {
        super.setSplitterPosition(position);
        this.splitterPosition = position;
    }

    public double getPrimarySizePixel() {
        return this.primarySizePixel;
    }

    public double getSecondarySizePixel() {
        return this.secondarySizePixel;
    }
}

