/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.jumpmind.vaadin.ui.common.IDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvExport<T> {
    protected IDataProvider<T> gridData = null;
    protected String fileName;
    protected String title;
    protected StringBuilder cellData;
    protected final String csvMimeContentType = "text/csv";
    final Logger log = LoggerFactory.getLogger(this.getClass());

    public CsvExport(IDataProvider<T> gridData) {
        this(gridData, null, null);
    }

    public CsvExport(IDataProvider<T> gridData, String fileName) {
        this(gridData, fileName, null);
    }

    public CsvExport(IDataProvider<T> gridData, String fileName, String title) {
        this.gridData = gridData;
        this.init(fileName, title);
    }

    public void init(String fileName, String title) {
        this.fileName = fileName == null || fileName.isEmpty() || !fileName.endsWith(".csv") ? "GridExport.csv" : fileName;
        this.title = title == null || title.isEmpty() ? "" : title;
        this.cellData = new StringBuilder();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DownloadHandler getDownloadHandler() {
        this.convertToCsv();
        return DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)event -> {
            byte[] data = this.cellData.toString().getBytes();
            return new DownloadResponse((InputStream)new ByteArrayInputStream(data), this.fileName, null, (long)data.length);
        });
    }

    public void convertToCsv() {
        this.addTitle();
        this.addHeaders();
        for (T rowItem : this.gridData.getRowItems()) {
            Iterator<?> columnIterator = this.gridData.getColumns().iterator();
            while (columnIterator.hasNext()) {
                Object col = columnIterator.next();
                Object obj = this.gridData.getCellValue(rowItem, col);
                Object value = "";
                if (obj != null) {
                    value = "\"" + obj.toString().replace("\"", "\"\"") + "\"";
                }
                if (columnIterator.hasNext()) {
                    this.cellData.append((String)value + ",");
                    continue;
                }
                this.cellData.append((String)value + "\n");
            }
        }
    }

    public void addTitle() {
        if (this.title != null && !this.title.equals("")) {
            this.cellData.append(this.title + ",\n");
        }
    }

    public void addHeaders() {
        Iterator<?> iterator = this.gridData.getColumns().iterator();
        while (iterator.hasNext()) {
            Object col = iterator.next();
            String value = this.gridData.getKeyValue(col);
            if (iterator.hasNext()) {
                this.cellData.append(value + ",");
                continue;
            }
            this.cellData.append(value + "\n");
        }
    }
}

