/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ColumnVisibilityToggler
extends Button {
    private VerticalLayout checkboxLayout;
    private Map<Grid.Column<?>, Checkbox> columnMap;
    private static final long serialVersionUID = 1L;

    public ColumnVisibilityToggler() {
        ContextMenu menu = new ContextMenu((Component)this);
        this.columnMap = new HashMap();
        menu.setOpenOnClick(true);
        menu.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
            if (event.isOpened()) {
                for (Grid.Column<?> column : this.columnMap.keySet()) {
                    this.columnMap.get(column).setValue((Object)column.isVisible());
                }
            }
        });
        this.checkboxLayout = new VerticalLayout();
        this.checkboxLayout.setPadding(false);
        this.checkboxLayout.setSpacing(false);
        this.checkboxLayout.getStyle().set("margin", "0").set("padding-bottom", "2px");
        menu.addComponent(new Component[]{this.checkboxLayout});
        this.setIcon((Component)new Icon(VaadinIcon.COG));
        this.getElement().setAttribute("title", "Hide/show columns");
    }

    public Grid.Column<?> addColumn(Grid.Column<?> column, String header) {
        if (!this.columnMap.containsKey(column)) {
            Checkbox checkbox = new Checkbox(header);
            checkbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> column.setVisible(((Boolean)event.getValue()).booleanValue()));
            this.columnMap.put(column, checkbox);
            this.rebuildMenuItems();
        }
        return column;
    }

    public void removeColumn(Grid.Column<?> column) {
        this.columnMap.remove(column);
        this.rebuildMenuItems();
    }

    public boolean isEmpty() {
        return this.columnMap.isEmpty();
    }

    private void rebuildMenuItems() {
        this.checkboxLayout.removeAll();
        List checkboxes = this.columnMap.values().stream().collect(Collectors.toList());
        checkboxes.sort((box0, box1) -> box0.getLabel().compareTo(box1.getLabel()));
        for (Checkbox checkbox : checkboxes) {
            this.checkboxLayout.add(new Component[]{checkbox});
        }
    }
}

