/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CollectionUtils {
    public static <T> Map<String, T> toMap(String[] keyNames, T[] values) {
        if (values != null && keyNames != null && values.length >= keyNames.length) {
            HashMap<String, T> map = new HashMap<String, T>(keyNames.length);
            for (int i = 0; i < keyNames.length; ++i) {
                map.put(keyNames[i], values[i]);
            }
            return map;
        }
        return new HashMap(0);
    }

    public static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        for (Object key : properties.keySet()) {
            map.put((String)key, (String)properties.get(key));
        }
        return map;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return CollectionUtils.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static <T> T[] add(T[] one, T[] two) {
        int size = one.length + two.length;
        T[] copy = CollectionUtils.copyOf(one, size);
        for (int i = one.length; i < size; ++i) {
            copy[i] = two[i - one.length];
        }
        return copy;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return CollectionUtils.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static String toCommaSeparatedValues(Collection<?> list) {
        StringBuilder csv = new StringBuilder();
        if (list != null) {
            Object[] array = list.toArray(new Object[list.size()]);
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    csv.append(",");
                }
                if (array[i] == null) continue;
                csv.append(array[i]);
            }
        }
        return csv.toString();
    }
}

