/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.TypedProperties;

public abstract class AbstractVersion {
    public static final int MAJOR_INDEX = 0;
    public static final int MINOR_INDEX = 1;
    public static final int PATCH_INDEX = 2;
    private String version = null;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private long buildTime = -1L;
    private String buildYear;

    protected abstract String getArtifactName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Attributes findManifestAttributes() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                InputStream is = resources.nextElement().openStream();
                try {
                    Manifest manifest = new Manifest(is);
                    Attributes attributes = manifest.getMainAttributes();
                    if (!this.getArtifactName().equals(attributes.getValue("Project-Artifact"))) continue;
                    Attributes attributes2 = attributes;
                    return attributes2;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String version() {
        if (this.version == null) {
            Attributes attributes = this.findManifestAttributes();
            if (attributes != null) {
                this.version = attributes.getValue("Build-Version");
            } else {
                for (String fileName : new String[]{"../symmetric-assemble/gradle.properties", "../../symmetric-ds/symmetric-assemble/gradle.properties"}) {
                    File gradleProperties = new File(fileName);
                    if (!gradleProperties.exists()) continue;
                    TypedProperties props = new TypedProperties(gradleProperties);
                    this.version = props.get("version");
                    break;
                }
                if (this.version == null) {
                    this.version = "development";
                }
            }
            int[] versionParts = this.parseVersion(this.version);
            this.majorVersion = versionParts[0];
            this.minorVersion = versionParts[1];
            this.patchVersion = versionParts[2];
        }
        return this.version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public long getBuildTime() {
        if (this.buildTime == -1L) {
            Attributes attributes = this.findManifestAttributes();
            try {
                this.buildTime = Long.parseLong(attributes.getValue("Build-Time").split("-")[0]);
            }
            catch (Exception e) {
                this.buildTime = 0L;
            }
        }
        return this.buildTime;
    }

    public String getBuildYear() {
        if (this.buildYear == null) {
            Attributes attributes = this.findManifestAttributes();
            try {
                this.buildYear = attributes.getValue("Build-Time").substring(0, 4);
            }
            catch (Exception e) {
                this.buildYear = "";
            }
        }
        return this.buildYear;
    }

    public String versionWithUnderscores() {
        return this.version().replace("[\\.\\-]", "_");
    }

    public int[] parseVersion(String version) {
        version = version.replaceAll("[^0-9\\.]", "");
        int[] versions = new int[3];
        if (!StringUtils.isEmpty((CharSequence)version)) {
            String[] splitVersion = version.split("\\.");
            if (splitVersion.length >= 3) {
                versions[2] = this.parseVersionComponent(splitVersion[2]);
            }
            if (splitVersion.length >= 2) {
                versions[1] = this.parseVersionComponent(splitVersion[1]);
            }
            if (splitVersion.length >= 1) {
                versions[0] = this.parseVersionComponent(splitVersion[0]);
            }
        }
        return versions;
    }

    private int parseVersionComponent(String versionComponent) {
        int version = 0;
        try {
            version = Integer.parseInt(versionComponent);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    protected boolean isOlderMajorVersion(String version) {
        return this.isOlderMajorVersion(this.parseVersion(version));
    }

    protected boolean isOlderMajorVersion(int[] versions) {
        int[] softwareVersion = this.parseVersion(this.version());
        return versions[0] < softwareVersion[0];
    }

    public boolean isOlderVersion(String version) {
        return this.isOlderThanVersion(version, this.version());
    }

    public boolean isOlderThanVersion(String checkVersion, String targetVersion) {
        if (this.noVersion(targetVersion)) {
            return true;
        }
        if (this.noVersion(checkVersion)) {
            return false;
        }
        int[] checkVersions = this.parseVersion(checkVersion);
        int[] targetVersions = this.parseVersion(targetVersion);
        return this.isOlderThanVersion(checkVersions, targetVersions);
    }

    public boolean isOlderThanVersion(int[] checkVersion, int[] targetVersion) {
        if (checkVersion == null || targetVersion == null) {
            return false;
        }
        if (checkVersion[0] < targetVersion[0]) {
            return true;
        }
        if (checkVersion[0] == targetVersion[0] && checkVersion[1] < targetVersion[1]) {
            return true;
        }
        return checkVersion[0] == targetVersion[0] && checkVersion[1] == targetVersion[1] && checkVersion[2] < targetVersion[2];
    }

    protected boolean noVersion(String targetVersion) {
        return StringUtils.isBlank((CharSequence)targetVersion) || "development".equals(targetVersion) || targetVersion.contains("SNAPSHOT");
    }

    public boolean isDevelopment(String version) {
        return version == null || version.equals("development") || version.contains("SNAPSHOT");
    }

    public boolean isOlderMinorVersion(String oldVersion) {
        return this.isOlderMinorVersion(this.version, this.version());
    }

    public boolean isOlderMinorVersion(String checkVersion, String targetVersion) {
        if (this.noVersion(targetVersion) || this.noVersion(checkVersion)) {
            return false;
        }
        int[] checkVersions = this.parseVersion(checkVersion);
        int[] targetVersions = this.parseVersion(targetVersion);
        return this.isOlderMinorVersion(checkVersions, targetVersions);
    }

    public boolean isOlderMinorVersion(int[] checkVersion, int[] targetVersion) {
        if (checkVersion[0] < targetVersion[0]) {
            return true;
        }
        return checkVersion[0] == targetVersion[0] && checkVersion[1] < targetVersion[1];
    }
}

