/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.wrapper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jumpmind.symmetric.wrapper.WrapperException;
import org.jumpmind.symmetric.wrapper.WrapperService;

public class Wrapper {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Wrapper.printUsage();
            System.exit(1);
        }
        String appDir = null;
        String configFile = null;
        String jarFile = Wrapper.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        if (args.length == 2) {
            configFile = args[1];
            appDir = Wrapper.getParentDir(configFile);
        } else if (args.length == 3) {
            configFile = args[1];
            appDir = args[2];
        } else {
            appDir = Wrapper.getParentDir(jarFile);
            configFile = Wrapper.findConfigFile(appDir + File.separator + "conf");
        }
        WrapperService service = WrapperService.getInstance();
        try {
            service.loadConfig(appDir, configFile, jarFile);
        }
        catch (FileNotFoundException e) {
            System.out.println("Missing config file " + configFile);
            System.out.println(e.getMessage());
            System.exit(3);
        }
        catch (IOException e) {
            System.out.println("Cannot read config file " + configFile);
            System.out.println(e.getMessage());
            System.exit(4);
        }
        try {
            if (args[0].equalsIgnoreCase("start")) {
                service.start();
            } else if (args[0].equalsIgnoreCase("exec")) {
                service.execJava(false);
            } else if (args[0].equalsIgnoreCase("init")) {
                service.init();
            } else if (args[0].equalsIgnoreCase("stop")) {
                service.stop();
            } else if (args[0].equalsIgnoreCase("restart")) {
                service.restart();
            } else if (args[0].equalsIgnoreCase("install")) {
                service.install();
            } else if (args[0].equalsIgnoreCase("uninstall")) {
                service.uninstall();
            } else if (args[0].equalsIgnoreCase("status")) {
                service.status();
            } else if (args[0].equalsIgnoreCase("console")) {
                service.console();
            } else {
                System.out.println("ERROR: Invalid argument");
                Wrapper.printUsage();
                System.exit(2);
            }
        }
        catch (WrapperException e) {
            System.out.println("Error " + e.getErrorCode() + ": " + e.getMessage());
            if (e.getCause() != null) {
                System.out.println("Exception " + e.getCause().getClass().getSimpleName() + ": " + e.getCause().getMessage());
            }
            if (e.getNativeErrorCode() > 0) {
                System.out.println("Native error " + e.getErrorCode());
            }
            System.exit(e.getErrorCode());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }

    protected static String getParentDir(String filepath) {
        int index = filepath.lastIndexOf(File.separator);
        if (index == -1) {
            return "..";
        }
        return filepath.substring(0, index + 1) + "..";
    }

    protected static String findConfigFile(String dirpath) {
        String[] files;
        File dir = new File(dirpath);
        if (dir.exists() && dir.isDirectory() && (files = dir.list()) != null) {
            for (String name : files) {
                if (!name.endsWith("_service.conf")) continue;
                return dirpath + File.separator + name;
            }
        }
        return dirpath + File.separator + "wrapper_service.conf";
    }

    protected static void printUsage() {
        System.out.println("Usage: <start|stop|restart|install|uninstall|status|console>");
        System.out.println("   start      - Start service");
        System.out.println("   stop       - Stop service");
        System.out.println("   restart    - Restart service");
        System.out.println("   install    - Install service");
        System.out.println("   uninstall  - Uninstall service");
        System.out.println("   status     - Status of service");
        System.out.println("   console    - Run from console");
    }
}

