/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web.compression;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.jumpmind.symmetric.web.compression.CompressionResponseStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(CompressionServletResponseWrapper.class);
    int compressionLevel = -1;
    int compressionStrategy = 0;
    protected HttpServletResponse origResponse = null;
    protected static final String info = "CompressionServletResponseWrapper";
    protected ServletOutputStream stream = null;
    protected PrintWriter writer = null;
    protected String contentType = null;

    public CompressionServletResponseWrapper(HttpServletResponse response, int compressionLevel, int compressionStrategy) {
        super(response);
        this.compressionLevel = compressionLevel;
        this.compressionStrategy = compressionStrategy;
        this.origResponse = response;
        log.debug("CompressionServletResponseWrapper constructor gets called");
    }

    public void setContentType(String contentType) {
        log.debug("setContentType to {}", (Object)contentType);
        this.contentType = contentType;
        this.origResponse.setContentType(contentType);
    }

    public ServletOutputStream createOutputStream() throws IOException {
        log.debug("createOutputStream gets called");
        CompressionResponseStream stream = new CompressionResponseStream(this.origResponse, this.compressionLevel, this.compressionStrategy);
        return stream;
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        log.debug("flush buffer @ CompressionServletResponseWrapper");
        ((CompressionResponseStream)this.stream).flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        log.debug("stream is set to {} in getOutputStream", (Object)this.stream);
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        log.debug("stream is set to {} in getWriter", (Object)this.stream);
        String charEnc = this.origResponse.getCharacterEncoding();
        log.debug("character encoding is {}", (Object)charEnc);
        this.writer = charEnc != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, charEnc)) : new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    public void setContentLength(int length) {
    }
}

