/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.ClientSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.web.AckUriHandler;
import org.jumpmind.symmetric.web.AuthenticationInterceptor;
import org.jumpmind.symmetric.web.BandwidthSamplerUriHandler;
import org.jumpmind.symmetric.web.ConfigurationUriHandler;
import org.jumpmind.symmetric.web.CopyNodeUriHandler;
import org.jumpmind.symmetric.web.FileSyncPullUriHandler;
import org.jumpmind.symmetric.web.FileSyncPushUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.IServerSymmetricEngineLifecycle;
import org.jumpmind.symmetric.web.IUriHandler;
import org.jumpmind.symmetric.web.InfoUriHandler;
import org.jumpmind.symmetric.web.NodeConcurrencyInterceptor;
import org.jumpmind.symmetric.web.PingUriHandler;
import org.jumpmind.symmetric.web.PullUriHandler;
import org.jumpmind.symmetric.web.PushStatusUriHandler;
import org.jumpmind.symmetric.web.PushUriHandler;
import org.jumpmind.symmetric.web.RegistrationUriHandler;
import org.jumpmind.symmetric.web.SnapshotUriHandler;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ServerSymmetricEngine
extends ClientSymmetricEngine {
    private static final Logger log = LoggerFactory.getLogger(ServerSymmetricEngine.class);
    protected List<IUriHandler> uriHandlers;
    protected SymmetricEngineHolder engineHolder;
    protected Map<String, Integer> errorCountByNode = new HashMap<String, Integer>();

    public ServerSymmetricEngine(File propertiesFile) {
        super(propertiesFile);
    }

    public ServerSymmetricEngine(File propertiesFile, ApplicationContext springContext) {
        super(propertiesFile, springContext);
    }

    public ServerSymmetricEngine(File propertiesFile, ApplicationContext springContext, SymmetricEngineHolder engineHolder) {
        super(propertiesFile, springContext);
        this.engineHolder = engineHolder;
    }

    public ServerSymmetricEngine(DataSource dataSource, ApplicationContext springContext, Properties properties, boolean registerEngine, SymmetricEngineHolder engineHolder) {
        super(dataSource, springContext, properties, registerEngine);
        this.engineHolder = engineHolder;
    }

    public SymmetricEngineHolder getEngineHolder() {
        return this.engineHolder;
    }

    protected SecurityServiceFactory.SecurityServiceType getSecurityServiceType() {
        return SecurityServiceFactory.SecurityServiceType.SERVER;
    }

    protected void init() {
        super.init();
        boolean useSessionAuth = this.parameterService.is("http.use.session.auth");
        int sessionExpireSeconds = this.parameterService.getInt("http.session.expire.seconds");
        int maxSessions = this.parameterService.getInt("http.session.max.count", 1000);
        AuthenticationInterceptor authInterceptor = new AuthenticationInterceptor(this.nodeService, this.securityService, useSessionAuth, sessionExpireSeconds, maxSessions);
        NodeConcurrencyInterceptor concurrencyInterceptor = new NodeConcurrencyInterceptor(this.concurrentConnectionManager, this.configurationService, this.nodeService, this.statisticManager);
        IInterceptor[] customInterceptors = this.buildCustomInterceptors();
        this.uriHandlers = new ArrayList<IUriHandler>();
        this.uriHandlers.add(new AckUriHandler((IParameterService)this.parameterService, this.acknowledgeService, this.add(customInterceptors, authInterceptor, concurrencyInterceptor)));
        this.uriHandlers.add(new PingUriHandler((IParameterService)this.parameterService, customInterceptors));
        this.uriHandlers.add(new InfoUriHandler((IParameterService)this.parameterService, this.nodeService, this.configurationService, this.clusterService, customInterceptors));
        this.uriHandlers.add(new BandwidthSamplerUriHandler((IParameterService)this.parameterService, this.add(customInterceptors, authInterceptor, concurrencyInterceptor)));
        this.uriHandlers.add(new PullUriHandler((IParameterService)this.parameterService, this.nodeService, this.configurationService, this.dataExtractorService, this.registrationService, this.statisticManager, this.outgoingBatchService, this.add(customInterceptors, authInterceptor, concurrencyInterceptor)));
        this.uriHandlers.add(new PushUriHandler((IParameterService)this.parameterService, this.dataLoaderService, this.statisticManager, this.nodeService, this.add(customInterceptors, authInterceptor, concurrencyInterceptor)));
        this.uriHandlers.add(new PushStatusUriHandler((IParameterService)this.parameterService, this.nodeCommunicationService, this.add(customInterceptors, authInterceptor, concurrencyInterceptor)));
        this.uriHandlers.add(new RegistrationUriHandler((IParameterService)this.parameterService, this.registrationService, this.add(customInterceptors, concurrencyInterceptor)));
        this.uriHandlers.add(new ConfigurationUriHandler((IParameterService)this.parameterService, this.dataExtractorService, this.add(customInterceptors, authInterceptor, concurrencyInterceptor)));
        this.uriHandlers.add(new FileSyncPullUriHandler((ISymmetricEngine)this, this.add(customInterceptors, authInterceptor, concurrencyInterceptor)));
        this.uriHandlers.add(new FileSyncPushUriHandler((ISymmetricEngine)this, this.add(customInterceptors, authInterceptor, concurrencyInterceptor)));
        this.uriHandlers.add(new CopyNodeUriHandler((ISymmetricEngine)this, this.add(customInterceptors, authInterceptor)));
        this.uriHandlers.add(new SnapshotUriHandler((ISymmetricEngine)this, customInterceptors));
        for (IServerSymmetricEngineLifecycle ext : this.extensionService.getExtensionPointList(IServerSymmetricEngineLifecycle.class)) {
            ext.initServer(this, this.uriHandlers, customInterceptors, authInterceptor, concurrencyInterceptor);
        }
    }

    protected IInterceptor[] buildCustomInterceptors() {
        String customInterceptorProperty = this.parameterService.getString("server.engine.uri.interceptors");
        ArrayList<IInterceptor> customInterceptors = new ArrayList<IInterceptor>();
        if (!StringUtils.isEmpty((CharSequence)customInterceptorProperty)) {
            String[] classNames;
            for (String className : classNames = customInterceptorProperty.split(";")) {
                className = className.trim();
                try {
                    Class clazz = ClassUtils.getClass((String)className);
                    IInterceptor interceptor = null;
                    for (Constructor<?> c : clazz.getConstructors()) {
                        if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isAssignableFrom(ISymmetricEngine.class)) continue;
                        interceptor = (IInterceptor)c.newInstance(new Object[]{this});
                    }
                    if (interceptor == null) {
                        interceptor = (IInterceptor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    customInterceptors.add(interceptor);
                }
                catch (Exception ex) {
                    log.error("Failed to load custom interceptor class '" + className + "'", (Throwable)ex);
                }
            }
        }
        return customInterceptors.toArray(new IInterceptor[customInterceptors.size()]);
    }

    public IInterceptor[] add(IInterceptor[] array, IInterceptor ... elements) {
        IInterceptor[] newArray = new IInterceptor[array.length + elements.length];
        int index = 0;
        for (IInterceptor interceptor : elements) {
            newArray[index++] = interceptor;
        }
        for (IInterceptor interceptor : array) {
            newArray[index++] = interceptor;
        }
        return newArray;
    }

    public synchronized int getErrorCountFor(String nodeId) {
        Integer errorCount = this.errorCountByNode.get(nodeId);
        if (errorCount == null) {
            errorCount = 1;
        }
        return errorCount;
    }

    public synchronized void incrementErrorCountForNode(String nodeId) {
        Integer errorCount = this.errorCountByNode.get(nodeId);
        if (errorCount == null) {
            errorCount = 1;
        }
        this.errorCountByNode.put(nodeId, errorCount + 1);
    }

    public synchronized void resetErrorCountForNode(String nodeId) {
        this.errorCountByNode.put(nodeId, 0);
    }

    public List<IUriHandler> getUriHandlers() {
        return this.uriHandlers;
    }
}

