/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class HttpMethodFilter
implements Filter {
    private Set<String> allowedMethods = new HashSet<String>();
    private Set<String> disallowedMethods = new HashSet<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        String allowMethodsConfig = filterConfig.getInitParameter("server.allow.http.methods");
        this.loadMethods(allowMethodsConfig, this.allowedMethods);
        String disallowMethodsConfig = filterConfig.getInitParameter("server.disallow.http.methods");
        this.loadMethods(disallowMethodsConfig, this.disallowedMethods);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod().toUpperCase();
        if (this.disallowedMethods.contains(method)) {
            this.forbid(method, request, response);
        } else if (!this.allowedMethods.isEmpty() && !this.allowedMethods.contains(method)) {
            this.forbid(method, request, response);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    protected void forbid(String method, ServletRequest request, ServletResponse response) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.sendError(659, "Method " + method + " is not allowed.");
    }

    protected void loadMethods(String configuredValue, Set<String> methods) {
        if (!StringUtils.isEmpty((CharSequence)configuredValue)) {
            String[] methodsSplit;
            for (String method : methodsSplit = configuredValue.split(",")) {
                if (StringUtils.isEmpty((CharSequence)method)) continue;
                methods.add(method.toUpperCase());
            }
        }
    }

    public void destroy() {
    }
}

