/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.integrate.IPublisher;
import org.jumpmind.symmetric.integrate.IPublisherFilter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterFilterAdapter;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractTextPublisherDataLoaderFilter
extends DatabaseWriterFilterAdapter
implements IPublisherFilter,
INodeGroupExtensionPoint,
BeanNameAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String MSG_CACHE = "msg_CACHE" + this.hashCode();
    protected IPublisher publisher;
    private boolean loadDataInTargetDatabase = true;
    protected String tableName;
    private String[] nodeGroupIdsToApplyTo;
    private int messagesSinceLastLogOutput = 0;
    private long minTimeInMsBetweenLogOutput = 30000L;
    private long lastTimeInMsOutputLogged = System.currentTimeMillis();
    private String beanName;

    protected abstract String addTextHeader(DataContext var1);

    protected abstract String addTextElement(DataContext var1, Table var2, CsvData var3);

    protected abstract String addTextFooter(DataContext var1);

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean beforeWrite(DataContext context, Table table, CsvData data) {
        String msg;
        DataEventType eventType;
        if (this.tableName != null && this.tableName.equals(table.getName()) && (eventType = data.getDataEventType()).isDml() && (msg = this.addTextElement(context, table, data)) != null) {
            this.getFromCache(context).append(msg);
        }
        return this.loadDataInTargetDatabase;
    }

    protected StringBuilder getFromCache(DataContext context) {
        StringBuilder msgCache = (StringBuilder)context.get(this.MSG_CACHE);
        if (msgCache == null) {
            msgCache = new StringBuilder(this.addTextHeader(context));
            context.put(this.MSG_CACHE, (Object)msgCache);
        }
        return msgCache;
    }

    protected boolean doesTextExistToPublish(DataContext context) {
        StringBuilder msgCache = (StringBuilder)context.get(this.MSG_CACHE);
        return msgCache != null && msgCache.length() > 0;
    }

    private void finalizeAndPublish(DataContext context) {
        StringBuilder msg = this.getFromCache(context);
        if (msg.length() > 0) {
            msg.append(this.addTextFooter(context));
            this.log.debug("Publishing text message {}", (Object)msg);
            context.remove(this.MSG_CACHE);
            this.publisher.publish((Context)context, msg.toString());
        }
    }

    public void batchComplete(DataContext context) {
        if (this.doesTextExistToPublish(context)) {
            this.finalizeAndPublish(context);
            this.logCount();
        }
    }

    protected void logCount() {
        ++this.messagesSinceLastLogOutput;
        long timeInMsSinceLastLogOutput = System.currentTimeMillis() - this.lastTimeInMsOutputLogged;
        if (timeInMsSinceLastLogOutput > this.minTimeInMsBetweenLogOutput) {
            this.log.info("{} published {} messages in the last {} ms.", new Object[]{this.beanName, this.messagesSinceLastLogOutput, timeInMsSinceLastLogOutput});
            this.lastTimeInMsOutputLogged = System.currentTimeMillis();
            this.messagesSinceLastLogOutput = 0;
        }
    }

    public void setLoadDataInTargetDatabase(boolean loadDataInTargetDatabase) {
        this.loadDataInTargetDatabase = loadDataInTargetDatabase;
    }

    @Override
    public void setPublisher(IPublisher publisher) {
        this.publisher = publisher;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdToApplyTo(String nodeGroupdId) {
        this.nodeGroupIdsToApplyTo = new String[]{nodeGroupdId};
    }

    public void setMessagesSinceLastLogOutput(int messagesSinceLastLogOutput) {
        this.messagesSinceLastLogOutput = messagesSinceLastLogOutput;
    }

    public void setMinTimeInMsBetweenLogOutput(long timeInMsBetweenLogOutput) {
        this.minTimeInMsBetweenLogOutput = timeInMsBetweenLogOutput;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

