/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.servlet.jakarta;

import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.util.Preconditions;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Map;

public class JakartaSamlHttpRequest
implements HttpRequest {
    private final HttpServletRequest delegate;

    private JakartaSamlHttpRequest(HttpServletRequest delegate) {
        this.delegate = (HttpServletRequest)Preconditions.checkNotNull((Object)delegate, (String)"Servlet request cannot be null.");
    }

    public int getServerPort() {
        return this.delegate.getServerPort();
    }

    public String getScheme() {
        return this.delegate.getScheme();
    }

    public String getServerName() {
        return this.delegate.getServerName();
    }

    public String getRequestURL() {
        return this.delegate.getRequestURL().toString();
    }

    public String getRequestURI() {
        return this.delegate.getRequestURI();
    }

    public String getQueryString() {
        return this.delegate.getQueryString();
    }

    public Map<String, String[]> getParameterMap() {
        return this.delegate.getParameterMap();
    }

    public void invalidateSession() {
        HttpSession session = this.delegate.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public static HttpRequest makeHttpRequest(HttpServletRequest delegate) {
        return new JakartaSamlHttpRequest(delegate);
    }
}

