/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.TreeMap;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.service.impl.ExtensionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class ClientExtensionService
extends ExtensionService {
    private static final Logger log = LoggerFactory.getLogger(ClientExtensionService.class);
    protected ApplicationContext springContext;

    public ClientExtensionService(ISymmetricEngine engine, ApplicationContext springContext) {
        super(engine);
        this.springContext = springContext;
    }

    public synchronized void refresh() {
        super.refresh();
        if (this.springContext != null) {
            TreeMap extensionPointMap = new TreeMap();
            extensionPointMap.putAll(this.springContext.getBeansOfType(IExtensionPoint.class));
            BeanFactory factory = this.springContext.getParentBeanFactory();
            if (factory instanceof ListableBeanFactory) {
                ListableBeanFactory beanFactory = (ListableBeanFactory)factory;
                extensionPointMap.putAll(beanFactory.getBeansOfType(IExtensionPoint.class));
            }
            log.info("Found {} extension points from spring that will be registered", (Object)extensionPointMap.size());
            for (String name : extensionPointMap.keySet()) {
                this.registerExtension(name, (IExtensionPoint)extensionPointMap.get(name), true);
            }
        }
    }

    public void setSpringContext(ApplicationContext springContext) {
        this.springContext = springContext;
    }
}

