/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class StageManagementJob
extends AbstractJob {
    public StageManagementJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Stage Management", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().schedule("900000").description("Purges the staging area");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        IStagingManager stagingManager = this.engine.getStagingManager();
        if (stagingManager != null) {
            long processed = stagingManager.clean(this.engine.getParameterService().getLong("stream.to.file.ttl.ms"));
            this.setProcessedCount(processed);
        }
    }
}

