/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class InitialLoadExtractorJob
extends AbstractJob {
    public InitialLoadExtractorJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Initial Load Extract", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().description("Extract data for initial loads").schedule("10000");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        if (this.engine.getParameterService().is("initial.load.use.extract.job.enabled")) {
            if (this.engine.getParameterService().is("file.sync.enable")) {
                this.engine.getFileSyncExtractorService().queueWork(force);
            }
            this.engine.getDataExtractorService().queueWork(force);
        }
    }
}

