/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class FileSyncTrackerJob
extends AbstractJob {
    public FileSyncTrackerJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("File Sync Tracker", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        boolean fileSyncEnabeld = this.engine.getParameterService().is("file.sync.enable");
        return new JobDefaults().schedule("0 0/5 * * * *").enabled(fileSyncEnabeld).description("Check for changes in sync'd files");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        if (this.engine != null) {
            this.engine.getFileSyncService().trackChanges(force);
        }
    }
}

