/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class FileSyncPushJob
extends AbstractJob {
    public FileSyncPushJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("File Sync Push", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        boolean fileSyncEnabeld = this.engine.getParameterService().is("file.sync.enable");
        return new JobDefaults().schedule("60000").enabled(fileSyncEnabeld).description("Push files to other nodes");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        this.engine.getFileSyncService().pushFilesToNodes(force);
    }
}

