/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.jumpmind.db.model.Column;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseDatabaseWriter
extends AbstractDatabaseWriter {
    private static final Logger log = LoggerFactory.getLogger(HbaseDatabaseWriter.class);
    private Configuration config;
    private Connection connection;
    private Table table;
    private String hbaseSiteXmlPath;

    public HbaseDatabaseWriter(String hbaseSiteXmlPath) {
        this.hbaseSiteXmlPath = hbaseSiteXmlPath;
    }

    protected void setup() {
        try {
            if (this.config == null) {
                this.config = HBaseConfiguration.create();
                this.config.addResource(new Path(this.hbaseSiteXmlPath));
            }
            if (this.connection == null) {
                log.debug("Establishing connection to HBase");
                this.connection = ConnectionFactory.createConnection((Configuration)this.config);
            }
            if (this.table == null) {
                log.debug("Connected to HBase, now looking up table " + this.targetTable.getName());
                this.table = this.connection.getTable(TableName.valueOf((String)this.targetTable.getName()));
            }
        }
        catch (IOException e) {
            log.error("Unable to connect to HBase ", (Throwable)e);
        }
    }

    protected AbstractDatabaseWriter.LoadStatus put(CsvData data) {
        try {
            this.setup();
            Put put = new Put(data.getPkData(this.targetTable)[0].getBytes(Charset.defaultCharset()));
            String[] values = data.getParsedData("rowData");
            Column[] columns = this.sourceTable.getColumns();
            ArrayList<Put> putList = new ArrayList<Put>();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].getName().contains(":")) continue;
                log.debug("Preparing put statement into Hbase.");
                String[] split = columns[i].getName().split(":");
                byte[] columnFamily = split[0].getBytes(Charset.defaultCharset());
                byte[] columnName = split[1].getBytes(Charset.defaultCharset());
                byte[] value = StringUtils.isEmpty((CharSequence)values[i]) ? new byte[]{} : values[i].getBytes(Charset.defaultCharset());
                put.addColumn(columnFamily, columnName, value);
                putList.add(put);
            }
            log.debug("Put list for HBase complete with a size of " + putList.size());
            this.table.put(putList);
            log.debug("Put rows into HBase now closing connection");
            this.table.close();
        }
        catch (IOException e) {
            log.error("Unable to load data into HBase ", (Throwable)e);
            throw new RuntimeException(e);
        }
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected AbstractDatabaseWriter.LoadStatus insert(CsvData data) {
        return this.put(data);
    }

    protected AbstractDatabaseWriter.LoadStatus delete(CsvData data, boolean useConflictDetection) {
        this.setup();
        String[] pkData = data.getParsedData("pkData");
        if (pkData != null && pkData.length == 1) {
            Delete delete = new Delete(pkData[0].getBytes(Charset.defaultCharset()));
            try {
                this.table.delete(delete);
            }
            catch (IOException e) {
                log.error("Unable to delete data for table " + this.targetTable.getName() + ", for primary key " + pkData[0]);
                throw new RuntimeException(e);
            }
        }
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected AbstractDatabaseWriter.LoadStatus update(CsvData data, boolean applyChangesOnly, boolean useConflictDetection) {
        return this.put(data);
    }

    protected boolean create(CsvData data) {
        return false;
    }

    protected boolean sql(CsvData data) {
        return false;
    }

    protected void logFailureDetails(Throwable e, CsvData data, boolean logLastDmlDetails) {
    }

    protected void logFailureDetails(Throwable e, CsvData data, boolean logLastDmlDetails, Object[] values) {
    }
}

