/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.TableNotFoundException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DynamicDefaultDatabaseWriter;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBulkDatabaseWriter
extends DynamicDefaultDatabaseWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractBulkDatabaseWriter.class);

    public AbstractBulkDatabaseWriter(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String tablePrefix) {
        super(symmetricPlatform, targetPlatform, tablePrefix);
    }

    public AbstractBulkDatabaseWriter(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String tablePrefix, DatabaseWriterSettings settings) {
        super(symmetricPlatform, targetPlatform, tablePrefix, settings);
    }

    public void start(Batch batch) {
        super.start(batch);
        batch.setBulkLoaderFlag(true);
        if (this.isFallBackToDefault()) {
            batch.setBulkLoaderFlag(false);
            this.getTransaction().setInBatchMode(false);
            this.getTransaction().clearBatch();
            log.debug("Writing batch " + batch.getBatchId() + " on channel " + batch.getChannelId() + " to node " + batch.getTargetNodeId() + " using DEFAULT loader");
        } else {
            log.debug("Writing batch " + batch.getBatchId() + " on channel " + batch.getChannelId() + " to node " + batch.getTargetNodeId() + " using BULK loader");
        }
    }

    public final void write(CsvData data) {
        if (data.requiresTable() && data.getDataEventType() != DataEventType.SQL) {
            if (this.sourceTable == null) {
                throw new SqlException("The target table was not specified");
            }
            if (this.targetTable == null) {
                String qualifiedName = this.sourceTable.getFullyQualifiedTableName();
                if (this.writerSettings.isIgnoreMissingTables() || this.batch.getBatchId() == -9999L) {
                    if (this.missingTables.add(qualifiedName)) {
                        log.info("Did not find the {} table in the target database", (Object)qualifiedName);
                    }
                } else {
                    ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
                    ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
                    throw new TableNotFoundException(String.format("Could not find the target table '%s'", qualifiedName));
                }
            }
        }
        if (this.isFallBackToDefault()) {
            this.writeDefault(data);
        } else {
            this.context.put("bulkWriterToUse", (Object)"bulk");
            this.bulkWrite(data);
        }
    }

    public void end(Batch batch, boolean inError) {
        super.end(batch, inError);
        if (!inError) {
            this.context.put("bulkWriterToUse", null);
        }
    }

    public boolean isFallBackToDefault() {
        return this.context.get("bulkWriterToUse") != null && this.context.get("bulkWriterToUse").equals("default");
    }

    protected final void writeDefault(CsvData data) {
        super.write(data);
    }

    protected abstract void bulkWrite(CsvData var1);
}

