/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.postgresql;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.postgresql.PostgreSqlSymmetricDialect;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.FormatUtils;

public class PostgreSqlTriggerTemplate
extends AbstractTriggerTemplate {
    protected String sqlBatchDelimiter;
    protected String infinityDateExpression;
    protected String createTriggerCommandBeginning = "create trigger ";
    protected String sharedTruncateEventFunctionName;
    protected String currentTimestampAndZoneExpression = "CURRENT_TIMESTAMP";
    protected String invokerSecurityClause = " ";

    public PostgreSqlTriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        IParameterService parameterService = symmetricDialect.getParameterService();
        PostgreSqlSymmetricDialect pgDialect = (PostgreSqlSymmetricDialect)this.symmetricDialect;
        this.createTriggerCommandBeginning = this.getCreateTriggerCommandBeginning(pgDialect);
        this.currentTimestampAndZoneExpression = this.getCurrentTimestampAndZoneExpression(pgDialect);
        this.invokerSecurityClause = this.getSecurityClause(pgDialect);
        this.sqlBatchDelimiter = parameterService.getString("trigger.capture.ddl.delimiter", "$");
        this.infinityDateExpression = parameterService.is("postgres.convert.infinity.date.to.null", true) ? "''" : "cast($(tableAlias).\"$(columnName)\" as varchar)";
        this.geometryColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(cast(ST_AsEWKT($(tableAlias).\"$(columnName)\") as varchar),$$\\$$,$$\\\\$$),'\"',$$\\\"$$) || '\"' end";
        this.geographyColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(cast(ST_AsEWKT($(tableAlias).\"$(columnName)\") as varchar),$$\\$$,$$\\\\$$),'\"',$$\\\"$$) || '\"' end";
        this.emptyColumnTemplate = "''";
        this.stringColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(cast($(tableAlias).\"$(columnName)\" as varchar),$$\\$$,$$\\\\$$),'\"',$$\\\"$$) || '\"' end";
        this.xmlColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(cast($(tableAlias).\"$(columnName)\" as varchar),$$\\$$,$$\\\\$$),'\"',$$\\\"$$) || '\"' end";
        this.arrayColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(cast($(tableAlias).\"$(columnName)\" as varchar),$$\\$$,$$\\\\$$),'\"',$$\\\"$$) || '\"' end";
        this.numberColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || cast(cast($(tableAlias).\"$(columnName)\" as numeric) as varchar) || '\"' end";
        this.dateColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when isfinite($(tableAlias).\"$(columnName)\") then '\"' || to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS') || '\"' else " + this.infinityDateExpression + " end";
        this.datetimeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when isfinite($(tableAlias).\"$(columnName)\") then '\"' || to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS.US') || '\"' else " + this.infinityDateExpression + " end";
        this.timeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || to_char($(tableAlias).\"$(columnName)\", 'HH24:MI:SS.US') || '\"' end";
        this.dateTimeWithTimeZoneColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when isfinite($(tableAlias).\"$(columnName)\") then                                                      case                                                                                                                when extract(timezone_hour from $(tableAlias).\"$(columnName)\") <= 0 and                                                extract(timezone_minute from $(tableAlias).\"$(columnName)\") <= 0 then                                           '\"' || to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS.US ')||'-'||                                lpad(cast(abs(round(extract(timezone_hour from $(tableAlias).\"$(columnName)\"))) as varchar),2,'0')||':'||                lpad(cast(abs(round(extract(timezone_minute from $(tableAlias).\"$(columnName)\"))) as varchar), 2, '0') || '\"'         when extract(timezone_hour from $(tableAlias).\"$(columnName)\") = 0 and                                                extract(timezone_minute from $(tableAlias).\"$(columnName)\") >= 0 then                                           '\"' || to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS.US ')||'+'||                                lpad(cast(round(extract(timezone_hour from $(tableAlias).\"$(columnName)\")) as varchar),2,'0')||':'||                lpad(cast(round(extract(timezone_minute from $(tableAlias).\"$(columnName)\")) as varchar), 2, '0') || '\"'         else                                                                                                                  '\"' || to_char($(tableAlias).\"$(columnName)\", 'YYYY-MM-DD HH24:MI:SS.US ')||'+'||                                lpad(cast(round(extract(timezone_hour from $(tableAlias).\"$(columnName)\")) as varchar),2,'0')||':'||                     lpad(cast(round(extract(timezone_minute from $(tableAlias).\"$(columnName)\")) as varchar), 2, '0') || '\"'              end                                                                                                              else " + this.infinityDateExpression + " end                                                                                                                 ";
        this.clobColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(cast($(tableAlias).\"$(columnName)\" as varchar),$$\\$$,$$\\\\$$),'\"',$$\\\"$$) || '\"' end";
        this.blobColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || pg_catalog.encode($(tableAlias).\"$(columnName)\", 'base64') || '\"' end";
        this.wrappedBlobColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || $(defaultSchema)$(prefixName)_largeobject($(tableAlias).\"$(columnName)\") || '\"' end";
        this.booleanColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when $(tableAlias).\"$(columnName)\" then '\"1\"' else '\"0\"' end";
        this.triggerConcatCharacter = "||";
        this.newTriggerValue = "new";
        this.oldTriggerValue = "old";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.sharedTruncateEventFunctionName = "f" + this.symmetricDialect.getTablePrefix() + "_on_truncate_table_configured_for_replication";
        this.otherColumnTemplate = this.stringColumnTemplate;
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put(this.sharedTruncateEventFunctionName, "CREATE OR REPLACE FUNCTION $(defaultSchema)" + this.sharedTruncateEventFunctionName + "() RETURNS TRIGGER AS $$ \nDECLARE \n    eventDdl VARCHAR(3000); \n    argumentNo int:=0; \n    triggersDisabled int:=0; \n    tableSchema varchar(255); \n    tableName varchar(255); \n    channelId varchar(128); \n    triggerId varchar(128); \n    histId int:=0; \nBEGIN  \n    tableSchema := TG_TABLE_SCHEMA; \n    tableName := TG_TABLE_NAME;  \n    if (tableSchema IS NOT NULL and LENGTH(tableSchema)>0) then \n        eventDdl := 'TRUNCATE TABLE ' || tableSchema || '.'|| tableName; \n    else \n        eventDdl := 'TRUNCATE TABLE ' || tableName; \n    end if; \n    if(TG_NARGS > 1) THEN \n        for argumentNo in 1..TG_NARGS-1 LOOP  \n            eventDdl := eventDdl || ' ' ||  TG_ARGV[argumentNo ]; \n            argumentNo := argumentNo+1; \n        END LOOP; \n    end if; \n    if (tableName like '%.%') then \n           tableSchema := split_part(tableName, '.', 1); \n           tableName := split_part(tableName, '.', 2); \n    end if; \n    tableSchema := trim(both '\\\"' from tableSchema); \n    tableName := trim(both '\\\"' from tableName); \n    if( $(replicationEnabledCondition) ) then \n      select tr.trigger_id, tr.channel_id, max(th.trigger_hist_id) \n      into triggerId, channelId, histId \n      from $(defaultSchema)$(prefixName)_trigger tr  \n      join $(defaultSchema)$(prefixName)_trigger_hist th \n        on th.trigger_id = tr.trigger_id and th.inactive_time is null \n      where tr.source_schema_name = lower(tableSchema) and tr.source_table_name = lower(tableName) \n      group by tr.trigger_id, tr.channel_id \n      limit 1; \n      if (channelId is null) then  \n        RAISE EXCEPTION 'Unable to capture truncate event for table, because SymmetricDS configuration is incomplete (channel is NULL)! Schema=%, Table=%, Command=%', tableSchema, tableName, eventDdl \n            USING MESSAGE = 'Run SyncTriggers job in SymmetricDS (Disabling this trigger will cause data to be out-of-sync!)'; \n        RETURN NEW;  \n      end if; \n      INSERT INTO $(defaultSchema)$(prefixName)_data(table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, transaction_id, create_time) \n      VALUES (tableName, 'S', histId, \n         '\"delimiter " + this.sqlBatchDelimiter + ";' || chr(13) || chr(10) || replace(replace(eventDdl,'\\','\\\\'),'\"','\\\"') || chr(13) || chr(10) || '\",ddl',\n         channelId, 'source',\n         TO_CHAR(CURRENT_TIMESTAMP, 'truncate-YYYY-MM-DD')||'T'||TO_CHAR(CURRENT_TIMESTAMP, 'HH24:MI:MSOF'), " + this.currentTimestampAndZoneExpression + "); \n      RAISE NOTICE 'Captured truncate event for table; Schema=%, Table=%, Channel=%, Command=%', tableSchema, tableName, channelId, eventDdl;\n    else \n      RAISE NOTICE 'Skipped truncate event for table, because replication is disabled; Schema=%, Table=%, Command=%', tableSchema, tableName, eventDdl;\n    end if; \n    RETURN NEW;  \nEND $$ LANGUAGE plpgsql" + this.invokerSecurityClause + ";");
        this.sqlTemplates.put("post" + this.sharedTruncateEventFunctionName + "Template", this.createTriggerCommandBeginning + "$(triggerName) after truncate on $(sourceTableName) for each STATEMENT execute function $(defaultSchema)$(sharedFunctionName)(); ");
        this.sqlTemplates.put("insertTriggerTemplate", "create or replace function $(schemaName)f$(triggerName)() returns trigger as $function$                                                                                                                \n                                begin                                                                                                                                                                  \n                                  $(custom_before_insert_text) \n                                  if $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                    insert into $(defaultSchema)$(prefixName)_data                                                                                                                     \n                                    (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                        \n                                    values(                                                                                                                                                            \n                                      '$(targetTableName)',                                                                                                                                            \n                                      'I',                                                                                                                                                             \n                                      $(triggerHistoryId),                                                                                                                                             \n                                      $(columns),                                                                                                                                                      \n                                      $(channelExpression),                                                                                                                                                \n                                      $(txIdExpression),                                                                                                                                               \n                                      $(defaultSchema)$(prefixName)_node_disabled(),                                                                                                                   \n                                      $(externalSelect),                                                                                                                                               \n                                      " + this.currentTimestampAndZoneExpression + "                                                                                                                \n                                    );                                                                                                                                                                 \n                                  end if;                                                                                                                                                              \n                                  $(custom_on_insert_text)                                                                                                                                             \n                                  return null;                                                                                                                                                         \n                                end;                                                                                                                                                                   \n                                $function$ language plpgsql" + this.invokerSecurityClause + ";");
        this.sqlTemplates.put("insertReloadTriggerTemplate", "create or replace function $(schemaName)f$(triggerName)() returns trigger as $function$                                                                                                                \n                                begin                                                                                                                                                                  \n                                  $(custom_before_insert_text) \n                                  if $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                    insert into $(defaultSchema)$(prefixName)_data                                                                                                                     \n                                    (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                        \n                                    values(                                                                                                                                                            \n                                      '$(targetTableName)',                                                                                                                                            \n                                      'R',                                                                                                                                                             \n                                      $(triggerHistoryId),                                                                                                                                             \n                                      $(newKeys),                                                                                                                                                      \n                                      $(channelExpression),                                                                                                                                                \n                                      $(txIdExpression),                                                                                                                                               \n                                      $(defaultSchema)$(prefixName)_node_disabled(),                                                                                                                   \n                                      $(externalSelect),                                                                                                                                               \n                                      " + this.currentTimestampAndZoneExpression + "                                                                                                                \n                                    );                                                                                                                                                                 \n                                  end if;                                                                                                                                                              \n                                  $(custom_on_insert_text)                                                                                                                                             \n                                  return null;                                                                                                                                                         \n                                end;                                                                                                                                                                   \n                                $function$ language plpgsql" + this.invokerSecurityClause + ";");
        this.sqlTemplates.put("insertPostTriggerTemplate", this.createTriggerCommandBeginning + "$(triggerName) after insert on $(schemaName)$(tableName)                                                                                                                                \n                                for each row execute procedure $(schemaName)f$(triggerName)();                                                                                                         ");
        this.sqlTemplates.put("updateTriggerTemplate", "create or replace function $(schemaName)f$(triggerName)() returns trigger as $function$                                                                                                                \n                                declare var_row_data text; \n                                declare var_old_data text; \n                                begin\n                                  $(custom_before_update_text) \n                                  if $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                    var_row_data := $(columns); \n                                    var_old_data := $(oldColumns); \n                                    if $(dataHasChangedCondition) then \n                                    insert into $(defaultSchema)$(prefixName)_data                                                                                                                     \n                                    (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                     \n                                    values(                                                                                                                                                            \n                                      '$(targetTableName)',                                                                                                                                            \n                                      'U',                                                                                                                                                             \n                                      $(triggerHistoryId),                                                                                                                                             \n                                      $(oldKeys),                                                                                                                                                      \n                                      var_row_data,                                                                                                                                                      \n                                      var_old_data,                                                                                                                                                   \n                                      $(channelExpression),                                                                                                                                                \n                                      $(txIdExpression),                                                                                                                                               \n                                      $(defaultSchema)$(prefixName)_node_disabled(),                                                                                                                   \n                                      $(externalSelect),                                                                                                                                               \n                                      " + this.currentTimestampAndZoneExpression + "                                                                                                                \n                                    );                                                                                                                                                                 \n                                  end if;                                                                                                                                                              \n                                  end if;                                                                                                                                                              \n                                  $(custom_on_update_text)                                                                                                                                             \n                                  return null;                                                                                                                                                         \n                                end;                                                                                                                                                                   \n                                $function$ language plpgsql" + this.invokerSecurityClause + ";");
        this.sqlTemplates.put("updateReloadTriggerTemplate", "create or replace function $(schemaName)f$(triggerName)() returns trigger as $function$                                                                                                                \n                                declare var_row_data text; \n                                declare var_old_data text; \n                                begin\n                                  $(custom_before_update_text) \n                                  if $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                    var_row_data := $(columns); \n                                    var_old_data := $(oldColumns); \n                                    if $(dataHasChangedCondition) then \n                                    insert into $(defaultSchema)$(prefixName)_data                                                                                                                     \n                                    (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)                     \n                                    values(                                                                                                                                                            \n                                      '$(targetTableName)',                                                                                                                                            \n                                      'R',                                                                                                                                                             \n                                      $(triggerHistoryId),                                                                                                                                             \n                                      $(oldKeys),                                                                                                                                                      \n                                      $(channelExpression),                                                                                                                                                \n                                      $(txIdExpression),                                                                                                                                               \n                                      $(defaultSchema)$(prefixName)_node_disabled(),                                                                                                                   \n                                      $(externalSelect),                                                                                                                                               \n                                      " + this.currentTimestampAndZoneExpression + "                                                                                                                \n                                    );                                                                                                                                                                 \n                                  end if;                                                                                                                                                              \n                                  end if;                                                                                                                                                              \n                                  $(custom_on_update_text)                                                                                                                                             \n                                  return null;                                                                                                                                                         \n                                end;                                                                                                                                                                   \n                                $function$ language plpgsql" + this.invokerSecurityClause + ";");
        this.sqlTemplates.put("updatePostTriggerTemplate", this.createTriggerCommandBeginning + "$(triggerName) after update on $(schemaName)$(tableName)                                                                                                                                \n                                for each row execute procedure $(schemaName)f$(triggerName)();                                                                                                         ");
        this.sqlTemplates.put("deleteTriggerTemplate", "create or replace function $(schemaName)f$(triggerName)() returns trigger as $function$                                                                                                                \n                                begin                                                                                                                                                                  \n                                  $(custom_before_delete_text) \n                                  if $(syncOnDeleteCondition) and $(syncOnIncomingBatchCondition) then                                                                                                 \n                                    insert into $(defaultSchema)$(prefixName)_data                                                                                                                     \n                                    (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                               \n                                    values(                                                                                                                                                            \n                                      '$(targetTableName)',                                                                                                                                            \n                                      'D',                                                                                                                                                             \n                                      $(triggerHistoryId),                                                                                                                                             \n                                      $(oldKeys),                                                                                                                                                      \n                                      $(oldColumns),                                                                                                                                                   \n                                      $(channelExpression),                                                                                                                                                \n                                      $(txIdExpression),                                                                                                                                               \n                                      $(defaultSchema)$(prefixName)_node_disabled(),                                                                                                                   \n                                      $(externalSelect),                                                                                                                                               \n                                      " + this.currentTimestampAndZoneExpression + "                                                                                                                \n                                    );                                                                                                                                                                 \n                                  end if;                                                                                                                                                              \n                                  $(custom_on_delete_text)                                                                                                                                             \n                                  return null;                                                                                                                                                         \n                                end;                                                                                                                                                                   \n                                $function$ language plpgsql" + this.invokerSecurityClause + ";");
        this.sqlTemplates.put("deletePostTriggerTemplate", this.createTriggerCommandBeginning + "$(triggerName) after delete on $(schemaName)$(tableName)                                                                                                                                \n                                for each row execute procedure $(schemaName)f$(triggerName)();                                                                                                         ");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(columns) from $(schemaName)$(tableName) t where $(whereClause)                                                                                                                                ");
        this.sqlTemplates.put("filteredDdlTriggerTemplate", "create or replace function f$(triggerName)() returns event_trigger as\n$function$\ndeclare cmd record;\ndeclare tableName varchar(255);\ndeclare histId integer;\ndeclare channelId varchar(128);\ndeclare rowData text;\nbegin\nrowData = current_query();\nfor cmd in select * from pg_event_trigger_ddl_commands() loop\n    if (upper(cmd.object_identity) not like upper('$(prefixName)%') and upper(cmd.object_identity) not like upper('%.$(prefixName)%') and    upper(cmd.object_identity) not like upper('f$(prefixName)%') and upper(cmd.object_identity) not like upper('%.f$(prefixName)%') and    (upper(rowData) not like '%CREATE%TABLE%(%' or cmd.command_tag like '%CREATE%TABLE%')) then\n        tableName := '$(prefixName)_node';\n        if (cmd.command_tag like '%TABLE%') then\n            tableName := cmd.object_identity;\n        end if;\n        if (cmd.command_tag like '%TRIGGER%') then\n            select c.relname into tableName from pg_trigger t join pg_class c on t.tgrelid = c.oid            where t.tgname = trim(both '\"' from split_part(cmd.object_identity, '.', 2));\n        end if;\n        if (cmd.command_tag like '%INDEX%') then\n            select ct.relname into tableName from pg_index i join pg_class ci on i.indexrelid = ci.oid join pg_class ct on i.indrelid = ct.oid            where ci.relname = trim(both '\"' from split_part(cmd.object_identity, '.', 2));\n        end if;\n        if (tableName like '%.%') then\n            tableName := split_part(tableName, '.', 2);\n        end if;\n        tableName := trim(both '\"' from tableName);\n        select trigger_hist_id, source_table_name into histId, tableName from $(defaultSchema)$(prefixName)_trigger_hist where upper(source_table_name) = upper(tableName) and inactive_time is null;\n        if (histId is not null) then\n            select channel_id into channelId from $(defaultSchema)$(prefixName)_trigger where upper(source_table_name) = upper(tableName);\n            if (channelId is null) then\n                channelId := 'config';\n            end if;\n            insert into $(defaultSchema)$(prefixName)_data\n            (table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, create_time)\n            values (tableName, '" + DataEventType.SQL.getCode() + "', histId,\n            '\"delimiter " + this.sqlBatchDelimiter + ";' || chr(13) || chr(10) || replace(replace(rowData,'\\','\\\\'),'\"','\\\"') || '\",ddl',\n            channelId, $(defaultSchema)$(prefixName)_node_disabled(), " + this.currentTimestampAndZoneExpression + ");\n        end if;\n    end if;\nend loop;\nend;\n$function$ language plpgsql" + this.invokerSecurityClause + ";create or replace function f$(triggerName)_drop() returns event_trigger as\n$function$\ndeclare cmd record;\ndeclare histId integer;\ndeclare rowData text;\nbegin\nrowData = current_query();\nfor cmd in select * from pg_event_trigger_dropped_objects() loop\n    if (upper(cmd.object_identity) not like upper('$(prefixName)%') and upper(cmd.object_identity) not like upper('%.$(prefixName)%') and    upper(cmd.object_identity) not like upper('f$(prefixName)%') and upper(cmd.object_identity) not like upper('%.f$(prefixName)%') and cmd.original) then\n        select trigger_hist_id into histId from $(defaultSchema)$(prefixName)_trigger_hist where upper(source_table_name) = upper('$(prefixName)_node') and inactive_time is null;\n        insert into $(defaultSchema)$(prefixName)_data\n        (table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, create_time)\n        values ('$(prefixName)_node', '" + DataEventType.SQL.getCode() + "', histId,\n        '\"delimiter " + this.sqlBatchDelimiter + ";' || chr(13) || chr(10) || replace(replace(rowData,'\\','\\\\'),'\"','\\\"') || '\",ddl',\n        'config', $(defaultSchema)$(prefixName)_node_disabled(), " + this.currentTimestampAndZoneExpression + ");\n    end if;\nend loop;\nend;\n$function$ language plpgsql" + this.invokerSecurityClause + ";");
        this.sqlTemplates.put("allDdlTriggerTemplate", "create or replace function f$(triggerName)() returns event_trigger as\n$function$\ndeclare cmd record;\ndeclare tableName varchar(255);\ndeclare histId integer;\ndeclare channelId varchar(128);\ndeclare rowData text;\nbegin\nrowData = current_query();\nfor cmd in select * from pg_event_trigger_ddl_commands() loop\n    if (upper(cmd.object_identity) not like upper('$(prefixName)%') and upper(cmd.object_identity) not like upper('%.$(prefixName)%') and    upper(cmd.object_identity) not like upper('f$(prefixName)%') and upper(cmd.object_identity) not like upper('%.f$(prefixName)%') and    (upper(rowData) not like '%CREATE%TABLE%(%' or cmd.command_tag like '%CREATE%TABLE%')) then\n        if (cmd.command_tag like '%TABLE%') then\n            tableName := cmd.object_identity;\n        end if;\n        if (cmd.command_tag like '%TRIGGER%') then\n            select c.relname into tableName from pg_trigger t join pg_class c on t.tgrelid = c.oid            where t.tgname = trim(both '\"' from split_part(cmd.object_identity, '.', 2));\n        end if;\n        if (cmd.command_tag like '%INDEX%') then\n            select ct.relname into tableName from pg_index i join pg_class ci on i.indexrelid = ci.oid join pg_class ct on i.indrelid = ct.oid            where ci.relname = trim(both '\"' from split_part(cmd.object_identity, '.', 2));\n        end if;\n        if (tableName is not null) then\n            if (tableName like '%.%') then\n                tableName := split_part(tableName, '.', 2);\n            end if;\n            tableName := trim(both '\"' from tableName);\n            select trigger_hist_id, source_table_name into histId, tableName from $(defaultSchema)$(prefixName)_trigger_hist where upper(source_table_name) = upper(tableName) and inactive_time is null;\n        end if;\n        if (histId is null) then\n            tableName := '$(prefixName)_node';\n            select trigger_hist_id into histId from $(defaultSchema)$(prefixName)_trigger_hist where upper(source_table_name) = upper(tableName) and inactive_time is null;\n        end if;\n        select channel_id into channelId from $(defaultSchema)$(prefixName)_trigger where upper(source_table_name) = upper(tableName);\n        if (channelId is null) then\n            channelId := 'config';\n        end if;\n        insert into $(defaultSchema)$(prefixName)_data\n        (table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, create_time)\n        values (tableName, '" + DataEventType.SQL.getCode() + "', histId,\n        '\"delimiter " + this.sqlBatchDelimiter + ";' || chr(13) || chr(10) || replace(replace(rowData,'\\','\\\\'),'\"','\\\"') || '\",ddl',\n        channelId, $(defaultSchema)$(prefixName)_node_disabled(), " + this.currentTimestampAndZoneExpression + ");\n    end if;\nend loop;\nend;\n$function$ language plpgsql" + this.invokerSecurityClause + ";create or replace function f$(triggerName)_drop() returns event_trigger as\n$function$\ndeclare cmd record;\ndeclare histId integer;\ndeclare rowData text;\nbegin\nrowData = current_query();\nfor cmd in select * from pg_event_trigger_dropped_objects() loop\n    if (upper(cmd.object_identity) not like upper('$(prefixName)%') and upper(cmd.object_identity) not like upper('%.$(prefixName)%') and    upper(cmd.object_identity) not like upper('f$(prefixName)%') and upper(cmd.object_identity) not like upper('%.f$(prefixName)%') and cmd.original) then\n        select trigger_hist_id into histId from $(defaultSchema)$(prefixName)_trigger_hist where upper(source_table_name) = upper('$(prefixName)_node') and inactive_time is null;\n        insert into $(defaultSchema)$(prefixName)_data\n        (table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, create_time)\n        values ('$(prefixName)_node', '" + DataEventType.SQL.getCode() + "', histId,\n        '\"delimiter " + this.sqlBatchDelimiter + ";' || chr(13) || chr(10) || replace(replace(rowData,'\\','\\\\'),'\"','\\\"') || '\",ddl',\n        'config', $(defaultSchema)$(prefixName)_node_disabled(), " + this.currentTimestampAndZoneExpression + ");\n    end if;\nend loop;\nend;\n$function$ language plpgsql" + this.invokerSecurityClause + ";");
        this.sqlTemplates.put("postDdlTriggerTemplate", "create event trigger $(triggerName) on ddl_command_end execute procedure f$(triggerName)();create event trigger $(triggerName)_drop on sql_drop execute procedure f$(triggerName)_drop();");
    }

    protected boolean requiresWrappedBlobTemplateForBlobType() {
        return true;
    }

    protected final String getCurrentTimestampAndZoneExpression(PostgreSqlSymmetricDialect pgDialect) {
        String timezone = pgDialect.getParameterService().getString("data.create_time.timezone");
        if (StringUtils.isEmpty((CharSequence)timezone)) {
            return "CURRENT_TIMESTAMP";
        }
        return String.format("CURRENT_TIMESTAMP AT TIME ZONE '%s'", timezone);
    }

    protected final String getCreateTriggerCommandBeginning(PostgreSqlSymmetricDialect pgDialect) {
        if (pgDialect.supportsReplaceTriggers() && pgDialect.getParameterService().is("trigger.allow.create.or.replace", true)) {
            return "create or replace trigger ";
        }
        return "create trigger ";
    }

    protected final String getSecurityClause(PostgreSqlSymmetricDialect pgDialect) {
        if (pgDialect.getParameterService().is("postgres.security.definer", false)) {
            return " security definer";
        }
        return "";
    }

    public String createDdlTrigger(String tablePrefix, String defaultCatalog, String defaultSchema, String triggerName) {
        String ddl = this.createSharedTruncateCaptureFunction(tablePrefix, defaultCatalog, defaultSchema);
        if (ddl == null) {
            ddl = "";
        }
        return ddl + super.createDdlTrigger(tablePrefix, defaultCatalog, defaultSchema, triggerName);
    }

    public String createPostTriggerDDL(DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, String defaultCatalog, String defaultSchema) {
        boolean includeTruncateTrigger;
        String ddl = "";
        String tableSchema = originalTable.getSchema();
        boolean internalTable = originalTable.getName().startsWith(tablePrefix) && StringUtils.isBlank((CharSequence)defaultSchema) == StringUtils.isBlank((CharSequence)tableSchema) && defaultSchema.contentEquals(tableSchema);
        PostgreSqlSymmetricDialect pgDialect = (PostgreSqlSymmetricDialect)this.symmetricDialect;
        boolean bl = includeTruncateTrigger = pgDialect.supportsReplaceTriggers() && pgDialect.getParameterService().is("postgres.trigger.capture.truncate.event") && (!trigger.isSyncOnDelete() && dml == DataEventType.INSERT || trigger.isSyncOnDelete() && dml == DataEventType.DELETE);
        if (includeTruncateTrigger && !internalTable && (ddl = this.createPostTriggerDDLForTruncate(trigger, history, channel, tablePrefix, originalTable, defaultCatalog, defaultSchema)) == null) {
            ddl = "";
        }
        return ddl + super.createPostTriggerDDL(dml, trigger, history, channel, tablePrefix, originalTable, defaultCatalog, defaultSchema);
    }

    public String createPostTriggerDDLForTruncate(Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, String defaultCatalog, String defaultSchema) {
        String ddl = "";
        String truncateTriggerName = this.generateTruncateTriggerName(trigger, history);
        if (truncateTriggerName == null || truncateTriggerName.length() < 1) {
            return ddl;
        }
        String truncateTriggerTemplate = "post" + this.sharedTruncateEventFunctionName + "Template";
        ddl = (String)this.sqlTemplates.get(truncateTriggerTemplate);
        if (StringUtils.isBlank((CharSequence)ddl)) {
            this.log.warn("Missing definition of a trigger statement {} for truncate events.", (Object)truncateTriggerTemplate);
            return "";
        }
        ddl = FormatUtils.replace((String)"triggerName", (String)truncateTriggerName, (String)ddl);
        ddl = FormatUtils.replace((String)"sourceTableName", (String)originalTable.getFullyQualifiedTableName(), (String)ddl);
        ddl = FormatUtils.replace((String)"sharedFunctionName", (String)this.sharedTruncateEventFunctionName, (String)ddl);
        ddl = this.replaceTemplateVariables(DataEventType.DELETE, trigger, history, channel, tablePrefix, originalTable, originalTable, defaultCatalog, defaultSchema, ddl);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Injected trigger for truncate events on table={}, DDL={}", (Object)originalTable.getName(), (Object)ddl);
        } else {
            this.log.info("Injected trigger for truncate events on table={}.", (Object)originalTable.getName());
        }
        return ddl;
    }

    protected String generateTruncateTriggerName(Trigger trigger, TriggerHistory history) {
        String truncateTriggerName = null;
        if (trigger.isSyncOnInsert() && !StringUtils.isBlank((CharSequence)(truncateTriggerName = history.getNameForInsertTrigger()))) {
            truncateTriggerName = truncateTriggerName.replace("_ON_I_FOR_", "_ON_T_FOR_");
        }
        if (StringUtils.isBlank(truncateTriggerName) && trigger.isSyncOnUpdate() && !StringUtils.isBlank((CharSequence)(truncateTriggerName = history.getNameForUpdateTrigger()))) {
            truncateTriggerName = truncateTriggerName.replace("_ON_U_FOR_", "_ON_T_FOR_");
        }
        if (StringUtils.isBlank((CharSequence)truncateTriggerName) && trigger.isSyncOnDelete() && !StringUtils.isBlank((CharSequence)(truncateTriggerName = history.getNameForDeleteTrigger()))) {
            truncateTriggerName = truncateTriggerName.replace("_ON_D_FOR_", "_ON_T_FOR_");
        }
        return truncateTriggerName;
    }

    public String createSharedTruncateCaptureFunction(String tablePrefix, String defaultCatalog, String defaultSchema) {
        PostgreSqlSymmetricDialect pgDialect = (PostgreSqlSymmetricDialect)this.symmetricDialect;
        if (!pgDialect.getParameterService().is("postgres.trigger.capture.truncate.event") && pgDialect.supportsReplaceTriggers()) {
            return "";
        }
        if (pgDialect.isFunctionInstalled(this.sharedTruncateEventFunctionName)) {
            this.log.debug("Detected shared function {} for capturing table truncate events. Name={}", (Object)this.sharedTruncateEventFunctionName);
            return "";
        }
        String ddl = (String)this.sqlTemplates.get(this.sharedTruncateEventFunctionName);
        if (StringUtils.isBlank((CharSequence)ddl)) {
            this.log.warn("Missing definition of the shared function {} for capturing table truncate events.", (Object)this.sharedTruncateEventFunctionName);
            return "";
        }
        ddl = FormatUtils.replace((String)"prefixName", (String)tablePrefix, (String)ddl);
        ddl = FormatUtils.replace((String)"replicationEnabledCondition", (String)pgDialect.getSyncTriggersExpression(), (String)ddl);
        ddl = this.replaceDefaultSchemaAndCatalog(ddl, defaultCatalog, defaultSchema);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Injected shared function {} for capturing table truncate events. DDL={}", (Object)this.sharedTruncateEventFunctionName, (Object)ddl);
        } else {
            this.log.info("Injected shared function {} for capturing table truncate events.", (Object)this.sharedTruncateEventFunctionName);
        }
        return ddl;
    }

    public String getTruncateSharedFunctionName() {
        return this.sharedTruncateEventFunctionName;
    }

    public String getEntry(String key) {
        return (String)this.sqlTemplates.get(key);
    }
}

