/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.ingres;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.ingres.IngresSqlTriggerTemplate;
import org.jumpmind.symmetric.service.IParameterService;

public class IngresSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String SYNC_TRIGGERS_DISABLED_VARIABLE = "synctriggersdisabled";
    static final String SYNC_NODE_DISABLED_VARIABLE = "sourcenode";

    public IngresSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new IngresSqlTriggerTemplate(this);
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public void cleanDatabase() {
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        this.deleteSyncTriggersDisabled(transaction);
        this.insertSyncTriggersDisabled(transaction);
        this.deleteSyncNodeDisabled(transaction);
        this.insertSyncNodeDisabled(transaction, nodeId);
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        this.deleteSyncTriggersDisabled(transaction);
        this.deleteSyncNodeDisabled(transaction);
    }

    private void deleteSyncTriggersDisabled(ISqlTransaction transaction) {
        this.deleteSymContextRecord(transaction, SYNC_TRIGGERS_DISABLED_VARIABLE);
    }

    private void insertSyncTriggersDisabled(ISqlTransaction transaction) {
        this.insertSymContextRecord(transaction, SYNC_TRIGGERS_DISABLED_VARIABLE, "1");
    }

    private void deleteSyncNodeDisabled(ISqlTransaction transaction) {
        this.deleteSymContextRecord(transaction, SYNC_NODE_DISABLED_VARIABLE);
    }

    private void insertSyncNodeDisabled(ISqlTransaction transaction, String nodeId) {
        this.insertSymContextRecord(transaction, SYNC_NODE_DISABLED_VARIABLE, nodeId);
    }

    private void deleteSymContextRecord(ISqlTransaction transaction, String variableName) {
        transaction.prepareAndExecute("delete from " + this.parameterService.getTablePrefix() + "_context where name = DBMSINFO('session_id') || ':" + variableName + "'", new Object[0]);
    }

    private void insertSymContextRecord(ISqlTransaction transaction, String variableName, String contextValue) {
        transaction.prepareAndExecute("insert into " + this.parameterService.getTablePrefix() + "_context (name, context_value, create_time, last_update_time)  values(DBMSINFO('session_id') || ':" + variableName + "', '" + contextValue + "', current_timestamp, current_timestamp)", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return "((var_sync_triggers_disabled is null) OR (var_sync_triggers_disabled = '0'))";
    }

    public void dropRequiredDatabaseObjects() {
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, String catalogName, String schema, String tableName, String triggerName) {
        return this.platform.getSqlTemplate().queryForInt("select count(*) from iirule where rule_name = ? ", new Object[]{triggerName.toLowerCase()}) > 0;
    }

    public boolean requiresAutoCommitFalseToSetFetchSize() {
        return true;
    }

    public boolean needsToSelectLobData() {
        return true;
    }

    public void truncateTable(String tableName) {
        this.platform.getSqlTemplate().update("modify " + tableName + " to truncated", new Object[0]);
    }

    public boolean isTransactionIdOverrideSupported() {
        return false;
    }
}

