/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.ingres;

import java.util.HashMap;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;

public class IngresSqlTriggerTemplate
extends AbstractTriggerTemplate {
    protected IngresSqlTriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.emptyColumnTemplate = "''";
        this.stringColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(varchar($(tableAlias).\"$(columnName)\",$(columnSize)),'\\','\\\\'),'\"','\\\"') || '\"' end";
        this.numberColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || varchar($(tableAlias).\"$(columnName)\") || '\"' end";
        this.geometryColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || varchar($(tableAlias).\"$(columnName)\") || '\"' end";
        this.geographyColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || varchar($(tableAlias).\"$(columnName)\") || '\"' end";
        this.xmlColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || varchar($(tableAlias).\"$(columnName)\") || '\"' end";
        this.arrayColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || varchar($(tableAlias).\"$(columnName)\") || '\"' end";
        this.booleanColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when $(tableAlias).\"$(columnName)\" is true then '\"1\"' else '\"0\"' end";
        this.dateColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || to_char($(tableAlias).\"$(columnName)\", 'yyyy-mm-dd hh:mi:ss') || '\"' end";
        this.datetimeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || to_char($(tableAlias).\"$(columnName)\", 'yyyy-mm-dd hh:mi:ss.ff') || '\"' end";
        this.timeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || to_char($(tableAlias).\"$(columnName)\") || '\"' end";
        this.dateTimeWithTimeZoneColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || to_char($(tableAlias).\"$(columnName)\", 'hh:mi:ss.ff tzh:tzm') || '\"' end";
        this.clobColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(varchar($(tableAlias).\"$(columnName)\"),'\\','\\\\'),'\"','\\\"') || '\"' end";
        this.blobColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || hex(varbinary($(tableAlias).\"$(columnName)\")) || '\"' end";
        this.triggerConcatCharacter = "||";
        this.newTriggerValue = "new";
        this.oldTriggerValue = "old";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.otherColumnTemplate = this.stringColumnTemplate;
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", "create or replace procedure $(schemaName)f$(triggerName)( IN columns varchar(16000), IN oldcolumns varchar(16000), IN oldkeys varchar(16000), IN newkeys varchar(16000), IN channelid varchar(16000), IN syncOnInsertCondition boolean ) AS \nDECLARE \nvar_transaction_id varchar(255); \nvar_sync_triggers_disabled varchar(255); \nvar_source_node varchar(255); \nBEGIN \nselect DBMSINFO('db_tran_id') into :var_transaction_id; \nselect varchar(context_value) into :var_source_node from $(prefixName)_context where name = DBMSINFO('session_id') || ':sourcenode'; \nselect varchar(context_value) into :var_sync_triggers_disabled from $(prefixName)_context where name = DBMSINFO('session_id') || ':synctriggersdisabled'; \n$(custom_before_insert_text) \nif :syncOnInsertCondition is true and $(syncOnIncomingBatchCondition) THEN \n            insert into $(defaultSchema)$(prefixName)_data \n            (table_name, event_type, trigger_hist_id, row_data, channel_id, \n             transaction_id, source_node_id, external_data, create_time) \n            values( \n             '$(targetTableName)', \n             'I', \n             $(triggerHistoryId), \n             :columns, \n             :channelid, \n             :var_transaction_id, \n             :var_source_node, \n             $(externalSelect), \n             current_timestamp \n             ); \nENDIF; \n$(custom_on_insert_text)END \n");
        this.sqlTemplates.put("insertReloadTriggerTemplate", "create or replace procedure $(schemaName)f$(triggerName)( IN columns varchar(16000), IN oldcolumns varchar(16000), IN oldkeys varchar(16000), IN newkeys varchar(16000), IN channelid varchar(16000), IN syncOnInsertCondition boolean ) AS \nDECLARE \nvar_transaction_id varchar(255); \nvar_sync_triggers_disabled varchar(255); \nvar_source_node varchar(255); \nBEGIN \nselect DBMSINFO('db_tran_id') into :var_transaction_id; \nselect varchar(context_value) into :var_source_node from $(prefixName)_context where name = DBMSINFO('session_id') || ':sourcenode'; \nselect varchar(context_value) into :var_sync_triggers_disabled from $(prefixName)_context where name = DBMSINFO('session_id') || ':synctriggersdisabled'; \n$(custom_before_insert_text) \nif :syncOnInsertCondition is true and $(syncOnIncomingBatchCondition) THEN \n            insert into $(defaultSchema)$(prefixName)_data \n            (table_name, event_type, trigger_hist_id, pk_data, channel_id, \n             transaction_id, source_node_id, external_data, create_time) \n            values( \n             '$(targetTableName)', \n             'R', \n             $(triggerHistoryId), \n             :newkeys, \n             :channelid, \n             :var_transaction_id, \n             :var_source_node, \n             $(externalSelect), \n             current_timestamp \n             ); \nENDIF; \n$(custom_on_insert_text)END \n");
        this.sqlTemplates.put("insertPostTriggerTemplate", "create trigger $(schemaName)$(triggerName) after insert of $(schemaName)$(tableName) for each row \nexecute procedure $(schemaName)f$(triggerName)( \ncolumns = $(columns) , \noldcolumns = NULL, \noldkeys = NULL, \nnewkeys = $(newKeys) , \nchannelid = $(channelExpression), \nsyncOnInsertCondition = case when $(syncOnInsertCondition) then true else false end \n)");
        this.sqlTemplates.put("updateTriggerTemplate", "create or replace procedure $(schemaName)f$(triggerName)( IN columns varchar(16000), IN oldcolumns varchar(16000), IN oldkeys varchar(16000), IN newkeys varchar(16000), IN channelid varchar(16000), IN syncOnUpdateCondition boolean ) AS \nDECLARE \nvar_transaction_id varchar(255); \nvar_sync_triggers_disabled varchar(255); \nvar_source_node varchar(255); \nBEGIN \nselect DBMSINFO('db_tran_id') into :var_transaction_id; \nselect varchar(context_value) into :var_source_node from $(prefixName)_context where name = DBMSINFO('session_id') || ':sourcenode'; \nselect varchar(context_value) into :var_sync_triggers_disabled from $(prefixName)_context where name = DBMSINFO('session_id') || ':synctriggersdisabled'; \n$(custom_before_update_text) \nif :syncOnUpdateCondition is true and $(syncOnIncomingBatchCondition) THEN \n          if $(dataHasChangedCondition) THEN \n            insert into $(defaultSchema)$(prefixName)_data \n            (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, \n             transaction_id, source_node_id, external_data, create_time) \n            values( \n             '$(targetTableName)', \n             'U', \n             $(triggerHistoryId), \n             :oldkeys, \n             :columns, \n             :oldcolumns, \n             :channelid, \n             :var_transaction_id, \n             :var_source_node, \n             $(externalSelect), \n             current_timestamp \n             ); \n           ENDIF; \nENDIF; \n$(custom_on_update_text)END \n");
        this.sqlTemplates.put("updateReloadTriggerTemplate", "create or replace procedure $(schemaName)f$(triggerName)( IN columns varchar(16000), IN oldcolumns varchar(16000), IN oldkeys varchar(16000), IN newkeys varchar(16000), IN channelid varchar(16000), IN syncOnUpdateCondition boolean ) AS \nDECLARE \nvar_transaction_id varchar(255); \nvar_sync_triggers_disabled varchar(255); \nvar_source_node varchar(255); \nBEGIN \nselect DBMSINFO('db_tran_id') into :var_transaction_id; \nselect varchar(context_value) into :var_source_node from $(prefixName)_context where name = DBMSINFO('session_id') || ':sourcenode'; \nselect varchar(context_value) into :var_sync_triggers_disabled from $(prefixName)_context where name = DBMSINFO('session_id') || ':synctriggersdisabled'; \n$(custom_before_update_text) \nif :syncOnUpdateCondition is true and $(syncOnIncomingBatchCondition) THEN \n          if $(dataHasChangedCondition) THEN \n            insert into $(defaultSchema)$(prefixName)_data \n            (table_name, event_type, trigger_hist_id, pk_data, channel_id, \n             transaction_id, source_node_id, external_data, create_time) \n            values( \n             '$(targetTableName)', \n             'R', \n             $(triggerHistoryId), \n             :oldkeys, \n             :channelid, \n             :var_transaction_id, \n             :var_source_node, \n             $(externalSelect), \n             current_timestamp \n             ); \n           ENDIF; \nENDIF; \n$(custom_on_update_text)END \n");
        this.sqlTemplates.put("updatePostTriggerTemplate", "create trigger $(schemaName)$(triggerName) after update of $(schemaName)$(tableName) for each row \nexecute procedure $(schemaName)f$(triggerName)( \ncolumns = $(columns) , \noldcolumns = $(oldColumns), \noldkeys = $(oldKeys), \nnewkeys = $(newKeys), \nchannelid = $(channelExpression), syncOnUpdateCondition = case when $(syncOnUpdateCondition) then true else false end \n)");
        this.sqlTemplates.put("deleteTriggerTemplate", "create or replace procedure $(schemaName)f$(triggerName)( IN columns varchar(16000), IN oldcolumns varchar(16000), IN oldkeys varchar(16000), IN newkeys varchar(16000), IN channelid varchar(16000), IN syncOnDeleteCondition boolean ) AS \nDECLARE \nvar_transaction_id varchar(255); \nvar_sync_triggers_disabled varchar(255); \nvar_source_node varchar(255); \nBEGIN \nselect DBMSINFO('db_tran_id') into :var_transaction_id; \nselect varchar(context_value) into :var_source_node from $(prefixName)_context where name = DBMSINFO('session_id') || ':sourcenode'; \nselect varchar(context_value) into :var_sync_triggers_disabled from $(prefixName)_context where name = DBMSINFO('session_id') || ':synctriggersdisabled'; \n$(custom_before_delete_text) \nif :syncOnDeleteCondition is true and $(syncOnIncomingBatchCondition) THEN \n          if $(dataHasChangedCondition) THEN \n            insert into $(defaultSchema)$(prefixName)_data \n            (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, \n             transaction_id, source_node_id, external_data, create_time) \n            values( \n             '$(targetTableName)', \n             'D', \n             $(triggerHistoryId), \n             :oldkeys, \n             :oldcolumns, \n             :channelid, \n             :var_transaction_id, \n             :var_source_node, \n             $(externalSelect), \n             current_timestamp \n             ); \n           ENDIF; \nENDIF; \n$(custom_on_delete_text)END \n");
        this.sqlTemplates.put("deletePostTriggerTemplate", "create trigger $(schemaName)$(triggerName) after delete of $(schemaName)$(tableName) for each row \nexecute procedure $(schemaName)f$(triggerName)( \ncolumns = NULL , \noldcolumns = $(oldColumns), \noldkeys = $(oldKeys), \nnewkeys = NULL, \nchannelid = $(channelExpression), syncOnDeleteCondition = case when $(syncOnDeleteCondition) then true else false end \n)");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(columns) from $(schemaName)$(tableName) t where $(whereClause)");
    }
}

