/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2TriggerTemplate;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.util.FormatUtils;

public class Db2zOsTriggerTemplate
extends Db2TriggerTemplate {
    public Db2zOsTriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.stringColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null or $(tableAlias).\"$(columnName)\" = '' then $(oracleToClob)'' else '\"' || $(oracleToClob)replace(replace($(tableAlias).\"$(columnName)\",'\\','\\\\'),'\"','\\\"') || '\"' end";
        this.datetimeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || lpad(rtrim(char(year(timestamp_iso($(tableAlias).\"$(columnName)\")))),4,'0') ||'-'||substr(digits(month(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||'-'||substr(digits(day(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||' '||substr(digits(hour(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||':'||substr(digits(minute(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||':'||substr(digits(second(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||'.'||RIGHT(REPEAT('0',6)||rtrim(char(microsecond(timestamp_iso($(tableAlias).\"$(columnName)\")))),6) || '\"' end";
        this.sqlTemplates.put("insertTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER INSERT ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING NEW AS NEW                                                                                                                                                 \n                                FOR EACH ROW MODE DB2SQL $(isAccessControlled)                                                                                                                         \n                                WHEN ($(syncOnInsertCondition) and $(syncOnIncomingBatchCondition))                                                                                                    \n                                BEGIN ATOMIC                                                                                                                                                           \n                                        $(custom_before_insert_text) \n                                        INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                 \n                                            (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                \n                                        VALUES('$(targetTableName)', 'I', $(triggerHistoryId),                                                                                                         \n                                            $(columns),                                                                                                                                                \n                                            $(channelExpression), $(txIdExpression), $(sourceNodeExpression),                                                                                          \n                                            $(externalSelect),                                                                                                                                         \n                                            CURRENT_TIMESTAMP);                                                                                                                                        \n                                    $(custom_on_insert_text)                                                                                                                                           \n                                END                                                                                                                                                                    \n");
        this.sqlTemplates.put("insertReloadTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER INSERT ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING NEW AS NEW                                                                                                                                                 \n                                FOR EACH ROW MODE DB2SQL $(isAccessControlled)                                                                                                                         \n                                WHEN ($(syncOnInsertCondition) and $(syncOnIncomingBatchCondition))                                                                                                    \n                                BEGIN ATOMIC                                                                                                                                                           \n                                        $(custom_before_insert_text) \n                                        INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                 \n                                            (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                \n                                        VALUES('$(targetTableName)', 'R', $(triggerHistoryId),                                                                                                         \n                                            $(newKeys),                                                                                                                                                \n                                            $(channelExpression), $(txIdExpression), $(sourceNodeExpression),                                                                                          \n                                            $(externalSelect),                                                                                                                                         \n                                            CURRENT_TIMESTAMP);                                                                                                                                        \n                                    $(custom_on_insert_text)                                                                                                                                           \n                                END                                                                                                                                                                    \n");
        this.sqlTemplates.put("updateTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER UPDATE ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING OLD AS OLD NEW AS NEW                                                                                                                                      \n                                FOR EACH ROW MODE DB2SQL $(isAccessControlled)                                                                                                                        \n                                WHEN ($(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition))                                                                                                    \n                                BEGIN ATOMIC                                                                                                                                                           \n                                            $(custom_before_update_text) \n                                            INSERT into $(defaultSchema)$(prefixName)_data                                                                                                             \n                                                (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)         \n                                            VALUES('$(targetTableName)', 'U', $(triggerHistoryId),                                                                                                     \n                                                $(oldKeys),                                                                                                                                            \n                                                $(columns),                                                                                                                                            \n                                                $(oldColumns),                                                                                                                                         \n                                                $(channelExpression),                                                                                                                                  \n                                                $(txIdExpression),                                                                                                                                     \n                                                $(sourceNodeExpression),                                                                                                                               \n                                                $(externalSelect),                                                                                                                                     \n                                                CURRENT_TIMESTAMP);                                                                                                                                    \n                                    $(custom_on_update_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("updateReloadTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER UPDATE ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING OLD AS OLD NEW AS NEW                                                                                                                                      \n                                FOR EACH ROW MODE DB2SQL $(isAccessControlled)                                                                                                                        \n                                WHEN ($(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition))                                                                                                    \n                                BEGIN ATOMIC                                                                                                                                                           \n                                            $(custom_before_update_text) \n                                            INSERT into $(defaultSchema)$(prefixName)_data                                                                                                             \n                                                (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)         \n                                            VALUES('$(targetTableName)', 'R', $(triggerHistoryId),                                                                                                     \n                                                $(newKeys),                                                                                                                                            \n                                                $(channelExpression),                                                                                                                                  \n                                                $(txIdExpression),                                                                                                                                     \n                                                $(sourceNodeExpression),                                                                                                                               \n                                                $(externalSelect),                                                                                                                                     \n                                                CURRENT_TIMESTAMP);                                                                                                                                    \n                                    $(custom_on_update_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("deleteTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER DELETE ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING OLD AS OLD                                                                                                                                                 \n                                FOR EACH ROW MODE DB2SQL $(isAccessControlled)                                                                                                                         \n                                WHEN ($(syncOnDeleteCondition) and $(syncOnIncomingBatchCondition))                                                                                                    \n                                BEGIN ATOMIC                                                                                                                                                           \n                                        $(custom_before_delete_text) \n                                        INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                 \n                                            (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                       \n                                        VALUES ('$(targetTableName)', 'D', $(triggerHistoryId),                                                                                                        \n                                            $(oldKeys),                                                                                                                                                \n                                            $(oldColumns),                                                                                                                                             \n                                            $(channelExpression),                                                                                                                                      \n                                            $(txIdExpression),                                                                                                                                         \n                                            $(sourceNodeExpression),                                                                                                                                   \n                                            $(externalSelect),                                                                                                                                         \n                                            CURRENT_TIMESTAMP);                                                                                                                                        \n                                    $(custom_on_delete_text)                                                                                                                                           \n                                END                                                                                                                                                                    \n");
    }

    protected String replaceTemplateVariables(DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, Table table, String defaultCatalog, String defaultSchema, String ddl) {
        ddl = super.replaceTemplateVariables(dml, trigger, history, channel, tablePrefix, originalTable, table, defaultCatalog, defaultSchema, ddl);
        ddl = FormatUtils.replace((String)"isAccessControlled", (String)(table.isAccessControlled() ? " SECURED" : ""), (String)ddl);
        return ddl;
    }
}

