/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2TriggerTemplate;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;

public class Db2As400TriggerTemplate
extends Db2TriggerTemplate {
    public Db2As400TriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.stringColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace($(tableAlias).\"$(columnName)\",'\\','\\\\'),'\"','\\\"') || '\"' end";
        this.datetimeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || rtrim(char(year(timestamp_iso($(tableAlias).\"$(columnName)\"))))||'-'||substr(digits(month(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||'-'||substr(digits(day(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||' '||substr(digits(hour(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||':'||substr(digits(minute(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||':'||substr(digits(second(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||'.'||RIGHT(REPEAT('0',6)||rtrim(char(microsecond(timestamp_iso($(tableAlias).\"$(columnName)\")))),6) || '\"' end";
        String castClobTo = symmetricDialect.getParameterService().getString("as400.cast.clob.to", "DCLOB");
        this.clobColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || replace(replace(cast($(tableAlias).\"$(columnName)\" as " + castClobTo + "),'\\','\\\\'),'\"','\\\"') || '\"' end";
        this.sqlTemplates.put("insertTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                                                             AFTER INSERT ON $(schemaName)$(tableName)                                                                                                                                                              REFERENCING NEW AS NEW                                                                                                                                                                                 FOR EACH ROW MODE DB2SQL                                                                                                                                                                               BEGIN ATOMIC                                                                                                                                                                                               $(custom_before_insert_text) \n                                    IF $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then                                                                                                                                       INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                                                             (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                                                        VALUES('$(targetTableName)', 'I', $(triggerHistoryId),                                                                                                                                                     $(columns),                                                                                                                                                                                            $(channelExpression), $(txIdExpression), $(sourceNodeExpression),                                                                                                                                      $(externalSelect),                                                                                                                                                                                     CURRENT_TIMESTAMP);                                                                                                                                                                            END IF;                                                                                                                                                                                                $(custom_on_insert_text)                                                                                                                                                                           END                                                                                                                                                                    ");
        this.sqlTemplates.put("insertReloadTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                                                             AFTER INSERT ON $(schemaName)$(tableName)                                                                                                                                                              REFERENCING NEW AS NEW                                                                                                                                                                                 FOR EACH ROW MODE DB2SQL                                                                                                                                                                               BEGIN ATOMIC                                                                                                                                                                                               $(custom_before_insert_text) \n                                    IF $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then                                                                                                                                       INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                                                             (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                                                        VALUES('$(targetTableName)', 'R', $(triggerHistoryId),                                                                                                                                                     $(newKeys),                                                                                                                                                                                            $(channelExpression), $(txIdExpression), $(sourceNodeExpression),                                                                                                                                      $(externalSelect),                                                                                                                                                                                     CURRENT_TIMESTAMP);                                                                                                                                                                            END IF;                                                                                                                                                                                                $(custom_on_insert_text)                                                                                                                                                                           END                                                                                                                                                                    ");
        this.sqlTemplates.put("updateTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER UPDATE ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING OLD AS OLD NEW AS NEW                                                                                                                                      \n                                FOR EACH ROW MODE DB2SQL                                                                                                                                               \n                                BEGIN ATOMIC                                                                                                                                                           \n                                    $(custom_before_update_text) \n                                    IF $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then                                                                                             \n                                            INSERT into $(defaultSchema)$(prefixName)_data                                                                                                             \n                                                (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)         \n                                            VALUES('$(targetTableName)', 'U', $(triggerHistoryId),                                                                                                     \n                                                $(oldKeys),                                                                                                                                            \n                                                $(columns),                                                                                                                                          \n                                                $(oldColumns),                                                                                                                                          \n                                                $(channelExpression),                                                                                                                                      \n                                                $(txIdExpression),                                                                                                                                     \n                                                $(sourceNodeExpression),                                                                                                                               \n                                                $(externalSelect),                                                                                                                                     \n                                                CURRENT_TIMESTAMP);                                                                                                                                    \n                                    END IF;                                                                                                                                                            \n                                    $(custom_on_update_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("updateReloadTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER UPDATE ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING OLD AS OLD NEW AS NEW                                                                                                                                      \n                                FOR EACH ROW MODE DB2SQL                                                                                                                                               \n                                BEGIN ATOMIC                                                                                                                                                           \n                                    $(custom_before_update_text) \n                                    IF $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then                                                                                             \n                                            INSERT into $(defaultSchema)$(prefixName)_data                                                                                                             \n                                                (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)         \n                                            VALUES('$(targetTableName)', 'R', $(triggerHistoryId),                                                                                                     \n                                                $(oldKeys),                                                                                                                                            \n                                                $(channelExpression),                                                                                                                                      \n                                                $(txIdExpression),                                                                                                                                     \n                                                $(sourceNodeExpression),                                                                                                                               \n                                                $(externalSelect),                                                                                                                                     \n                                                CURRENT_TIMESTAMP);                                                                                                                                    \n                                    END IF;                                                                                                                                                            \n                                    $(custom_on_update_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("deleteTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                                                             AFTER DELETE ON $(schemaName)$(tableName)                                                                                                                                                              REFERENCING OLD AS OLD                                                                                                                                                                                 FOR EACH ROW MODE DB2SQL                                                                                                                                                                               BEGIN ATOMIC                                                                                                                                                                                               $(custom_before_delete_text) \n                                    IF $(syncOnDeleteCondition) and $(syncOnIncomingBatchCondition) then                                                                                                                                       INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                                                             (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                                               VALUES ('$(targetTableName)', 'D', $(triggerHistoryId),                                                                                                                                                    $(oldKeys),                                                                                                                                                                                            $(oldColumns),                                                                                                                                                                                         $(channelExpression),                                                                                                                                                                                      $(txIdExpression),                                                                                                                                                                                     $(sourceNodeExpression),                                                                                                                                                                               $(externalSelect),                                                                                                                                                                                     CURRENT_TIMESTAMP);                                                                                                                                                                            END IF;                                                                                                                                                                                                $(custom_on_delete_text)                                                                                                                                                                           END                                                                                                                                                                    ");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(columns) from $(schemaName)$(tableName) t where $(whereClause)                                                                                                                                ");
    }

    public boolean useTriggerTemplateForColumnTemplatesDuringInitialLoad() {
        return false;
    }

    protected boolean useTriggerTemplateForColumnTemplatesDuringInitialLoad(Column column) {
        return false;
    }

    public String createInitalLoadSql(Node node, TriggerRouter triggerRouter, Table originalTable, TriggerHistory triggerHistory, Channel channel, String overrideSelectSql) {
        String sql = super.createInitalLoadSql(node, triggerRouter, originalTable, triggerHistory, channel, overrideSelectSql);
        boolean includeRRN = this.symmetricDialect.getParameterService().is("include.rowidentifier.as.column");
        if (includeRRN) {
            sql = sql.replace("\"RRN\"", "RRN(t)");
        }
        return sql;
    }
}

