/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.SqlScript;
import org.jumpmind.exception.IoException;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.KeystoreAliasException;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Message;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.DbExportUtils;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.util.ModuleException;
import org.jumpmind.symmetric.util.ModuleManager;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.JarBuilder;
import org.jumpmind.util.ZipBuilder;

public class SymmetricAdmin
extends AbstractCommandLauncher {
    private static final Log log = LogFactory.getLog(SymmetricAdmin.class);
    private static final String CMD_LIST_ENGINES = "list-engines";
    private static final String CMD_RELOAD_NODE = "reload-node";
    private static final String CMD_RELOAD_TABLE = "reload-table";
    private static final String CMD_EXPORT_BATCH = "export-batch";
    private static final String CMD_IMPORT_BATCH = "import-batch";
    private static final String CMD_RUN_JOB = "run-job";
    private static final String CMD_RUN_PURGE = "run-purge";
    private static final String CMD_ENCRYPT_TEXT = "encrypt-text";
    private static final String CMD_OBFUSCATE_TEXT = "obfuscate-text";
    private static final String CMD_UNOBFUSCATE_TEXT = "unobfuscate-text";
    private static final String CMD_CREATE_WAR = "create-war";
    private static final String CMD_CREATE_SYM_TABLES = "create-sym-tables";
    private static final String CMD_EXPORT_SYM_TABLES = "export-sym-tables";
    private static final String CMD_EXPORT_SYM_OBJECTS = "export-sym-objects";
    private static final String CMD_OPEN_REGISTRATION = "open-registration";
    private static final String CMD_REMOVE_NODE = "remove-node";
    private static final String CMD_SYNC_TRIGGERS = "sync-triggers";
    private static final String CMD_DROP_TRIGGERS = "drop-triggers";
    private static final String CMD_EXPORT_PROPERTIES = "export-properties";
    private static final String CMD_UNINSTALL = "uninstall";
    private static final String CMD_MODULE = "module";
    private static final String CMD_SEND_SQL = "send-sql";
    private static final String CMD_SEND_SCRIPT = "send-script";
    private static final String CMD_SEND_SCHEMA = "send-schema";
    private static final String CMD_BACKUP_FILE_CONFIGURATION = "backup-config";
    private static final String CMD_RESTORE_FILE_CONFIGURATION = "restore-config";
    private static final String CMD_IMPORT_CONFIG = "import-config";
    private static final String CMD_EXPORT_CONFIG = "export-config";
    private static final String CMD_IMPORT_CERT = "import-cert";
    private static final String CMD_TAKE_SNAPSHOT = "take-snapshot";
    private static final String[] NO_ENGINE_REQUIRED = new String[]{"export-properties", "encrypt-text", "obfuscate-text", "unobfuscate-text", "list-engines", "module", "backup-config", "restore-config", "create-war"};
    private static final String OPTION_NODE = "node";
    private static final String OPTION_CATALOG = "catalog";
    private static final String OPTION_SCHEMA = "schema";
    private static final String OPTION_WHERE = "where";
    private static final String OPTION_FORCE = "force";
    private static final String OPTION_OUT = "out";
    private static final String OPTION_SYM = "sym";
    private static final String OPTION_NODE_GROUP = "node-group";
    private static final String OPTION_REVERSE = "reverse";
    private static final String OPTION_IN = "in";
    private static final String OPTION_EXCLUDE_INDICES = "exclude-indices";
    private static final String OPTION_EXCLUDE_FOREIGN_KEYS = "exclude-fk";
    private static final String OPTION_EXCLUDE_DEFAULTS = "exclude-defaults";
    private static final String OPTION_EXCLUDE_LOG4J = "exclude-log4j";
    private static final String OPTION_EXTERNAL_SECURITY = "external-security";
    private static final String OPTION_ALTERS = "alters";
    private static final String OPTION_EXCLUDE_TABLES = "exclude-tables";
    private static final String OPTION_FILE = "file";
    private static final String OPTION_ACCEPT_ALL = "accept-all";
    private static final int WIDTH = 120;
    private static final int PAD = 3;

    public SymmetricAdmin(String app, String argSyntax, String messageKeyPrefix) {
        super(app, argSyntax, messageKeyPrefix);
    }

    public static void main(String[] args) throws Exception {
        new SymmetricAdmin("symadmin", "<subcommand> [options] [args]", "SymAdmin.Option.").execute(args);
    }

    @Override
    protected boolean printHelpIfNoOptionsAreProvided() {
        return true;
    }

    @Override
    protected boolean requiresPropertiesFile(CommandLine line) {
        String[] args = line.getArgs();
        if (args.length >= 1) {
            String cmd = args[0];
            return !ArrayUtils.contains((Object[])NO_ENGINE_REQUIRED, (Object)cmd);
        }
        return true;
    }

    @Override
    protected void printHelp(CommandLine line, Options options) {
        String[] args = line.getArgs();
        if (args.length > 1 && args[0].equals("help")) {
            this.printHelpCommand(line);
        } else {
            System.out.println(this.app + " version " + Version.version());
            System.out.println("Perform administration tasks with SymmetricDS.\n");
            System.out.println("Usage: symadmin <subcommand> --engine [engine.name] [options] [args]");
            System.out.println("       symadmin <subcommand> --properties [properties file] [options] [args]");
            System.out.println("\nType 'symadmin help <subcommand>' for help on a specific subcommand.\n");
            System.out.println("Available subcommands:");
            PrintWriter pw = new PrintWriter(System.out);
            this.printHelpLine(pw, CMD_LIST_ENGINES);
            this.printHelpLine(pw, CMD_OPEN_REGISTRATION);
            this.printHelpLine(pw, CMD_REMOVE_NODE);
            this.printHelpLine(pw, CMD_RELOAD_NODE);
            this.printHelpLine(pw, CMD_RELOAD_TABLE);
            this.printHelpLine(pw, CMD_EXPORT_BATCH);
            this.printHelpLine(pw, CMD_IMPORT_BATCH);
            this.printHelpLine(pw, CMD_RUN_JOB);
            this.printHelpLine(pw, CMD_RUN_PURGE);
            this.printHelpLine(pw, CMD_ENCRYPT_TEXT);
            this.printHelpLine(pw, CMD_OBFUSCATE_TEXT);
            this.printHelpLine(pw, CMD_CREATE_WAR);
            this.printHelpLine(pw, CMD_CREATE_SYM_TABLES);
            this.printHelpLine(pw, CMD_EXPORT_SYM_TABLES);
            this.printHelpLine(pw, CMD_EXPORT_SYM_OBJECTS);
            this.printHelpLine(pw, CMD_SYNC_TRIGGERS);
            this.printHelpLine(pw, CMD_DROP_TRIGGERS);
            this.printHelpLine(pw, CMD_EXPORT_PROPERTIES);
            this.printHelpLine(pw, CMD_SEND_SQL);
            this.printHelpLine(pw, CMD_SEND_SCHEMA);
            this.printHelpLine(pw, CMD_SEND_SCRIPT);
            this.printHelpLine(pw, CMD_BACKUP_FILE_CONFIGURATION);
            this.printHelpLine(pw, CMD_RESTORE_FILE_CONFIGURATION);
            this.printHelpLine(pw, CMD_UNINSTALL);
            this.printHelpLine(pw, CMD_MODULE);
            this.printHelpLine(pw, CMD_IMPORT_CONFIG);
            this.printHelpLine(pw, CMD_EXPORT_CONFIG);
            this.printHelpLine(pw, CMD_IMPORT_CERT);
            this.printHelpLine(pw, CMD_TAKE_SNAPSHOT);
            pw.flush();
        }
    }

    private void printHelpLine(PrintWriter pw, String cmd) {
        String text = StringUtils.rightPad((String)("   " + cmd), (int)23, (String)" ") + Message.get("SymAdmin.Cmd." + cmd);
        new HelpFormatter().printWrapped(pw, 79, 25, text);
    }

    private void printHelpCommand(CommandLine line) {
        String[] args = line.getArgs();
        if (args.length > 1) {
            String cmd = args[1];
            HelpFormatter format = new HelpFormatter();
            PrintWriter writer = new PrintWriter(System.out);
            Options options = new Options();
            if (!Message.containsKey("SymAdmin.Usage." + cmd)) {
                System.err.println("ERROR: no help text for subcommand '" + cmd + "' was found.");
                System.err.println("For a list of subcommands, use " + this.app + " --help\n");
                return;
            }
            format.printWrapped(writer, 120, "Usage: " + this.app + " " + cmd + " " + Message.get("SymAdmin.Usage." + cmd) + "\n");
            format.printWrapped(writer, 120, Message.get("SymAdmin.Help." + cmd));
            if (cmd.equals(CMD_SEND_SQL) || cmd.equals(CMD_SEND_SCHEMA) || cmd.equals(CMD_RELOAD_TABLE) || cmd.equals(CMD_SEND_SCRIPT)) {
                this.addOption(options, "n", OPTION_NODE, true);
                this.addOption(options, "g", OPTION_NODE_GROUP, true);
            }
            if (cmd.equals(CMD_RELOAD_TABLE) || cmd.equals(CMD_SYNC_TRIGGERS) || cmd.equals(CMD_SEND_SQL) || cmd.equals(CMD_SEND_SCHEMA)) {
                this.addOption(options, "c", OPTION_CATALOG, true);
                this.addOption(options, "s", OPTION_SCHEMA, true);
            }
            if (cmd.equals(CMD_RELOAD_TABLE)) {
                this.addOption(options, "w", OPTION_WHERE, true);
            }
            if (cmd.equals(CMD_SYNC_TRIGGERS)) {
                this.addOption(options, "o", OPTION_OUT, true);
                this.addOption(options, "f", OPTION_FORCE, false);
            }
            if (cmd.equals(CMD_DROP_TRIGGERS)) {
                this.addOption(options, null, OPTION_SYM, false);
            }
            if (cmd.equals(CMD_RELOAD_NODE)) {
                this.addOption(options, "r", OPTION_REVERSE, false);
            }
            if (cmd.equals(CMD_REMOVE_NODE)) {
                this.addOption(options, "n", OPTION_NODE, true);
            }
            if (cmd.equals(CMD_BACKUP_FILE_CONFIGURATION)) {
                this.addOption(options, "o", OPTION_OUT, true);
            }
            if (cmd.equals(CMD_RESTORE_FILE_CONFIGURATION)) {
                this.addOption(options, "i", OPTION_IN, true);
            }
            if (cmd.equals(CMD_SEND_SCHEMA)) {
                this.addOption(options, null, OPTION_EXCLUDE_INDICES, false);
                this.addOption(options, null, OPTION_EXCLUDE_FOREIGN_KEYS, false);
                this.addOption(options, null, OPTION_EXCLUDE_DEFAULTS, false);
            }
            if (cmd.equals(CMD_CREATE_WAR)) {
                this.addOption(options, null, OPTION_EXCLUDE_LOG4J, false);
                this.addOption(options, null, OPTION_EXTERNAL_SECURITY, false);
            }
            if (cmd.equals(CMD_EXPORT_SYM_TABLES)) {
                this.addOption(options, null, OPTION_ALTERS, false);
            }
            if (cmd.equals(CMD_EXPORT_SYM_OBJECTS)) {
                this.addOption(options, "x", OPTION_EXCLUDE_TABLES, false);
            }
            if (cmd.equals(CMD_SEND_SQL)) {
                this.addOption(options, "f", OPTION_FILE, true);
            }
            if (cmd.equals(CMD_IMPORT_CERT)) {
                this.addOption(options, null, OPTION_ACCEPT_ALL, false);
            }
            if (options.getOptions().size() > 0) {
                format.printWrapped(writer, 120, "\nOptions:");
                format.printOptions(writer, 120, options, 3, 3);
            }
            if (!ArrayUtils.contains((Object[])NO_ENGINE_REQUIRED, (Object)cmd)) {
                format.printWrapped(writer, 120, "\nEngine options:");
                options = new Options();
                super.buildOptions(options);
                format.printOptions(writer, 120, options, 3, 3);
                format.printWrapped(writer, 120, "\nCrypto options:");
                options = new Options();
                this.buildCryptoOptions(options);
                format.printOptions(writer, 120, options, 3, 3);
            }
            writer.flush();
        }
    }

    @Override
    protected void buildOptions(Options options) {
        super.buildOptions(options);
        this.addOption(options, "n", OPTION_NODE, true);
        this.addOption(options, "g", OPTION_NODE_GROUP, true);
        this.addOption(options, "c", OPTION_CATALOG, true);
        this.addOption(options, "s", OPTION_SCHEMA, true);
        this.addOption(options, "w", OPTION_WHERE, true);
        this.addOption(options, "f", OPTION_FORCE, false);
        this.addOption(options, "o", OPTION_OUT, true);
        this.addOption(options, null, OPTION_SYM, false);
        this.addOption(options, "r", OPTION_REVERSE, false);
        this.addOption(options, "i", OPTION_IN, true);
        this.addOption(options, null, OPTION_EXCLUDE_INDICES, false);
        this.addOption(options, null, OPTION_EXCLUDE_FOREIGN_KEYS, false);
        this.addOption(options, null, OPTION_EXCLUDE_DEFAULTS, false);
        this.addOption(options, null, OPTION_EXCLUDE_LOG4J, false);
        this.addOption(options, null, OPTION_EXTERNAL_SECURITY, false);
        this.addOption(options, null, OPTION_ALTERS, false);
        this.addOption(options, "x", OPTION_EXCLUDE_TABLES, false);
        this.addOption(options, null, OPTION_FILE, true);
        this.addOption(options, null, OPTION_ACCEPT_ALL, false);
        this.buildCryptoOptions(options);
    }

    @Override
    protected boolean executeWithOptions(CommandLine line) throws Exception {
        List args = line.getArgList();
        String cmd = (String)args.remove(0);
        this.configureCrypto(line);
        if (cmd.equals(CMD_EXPORT_PROPERTIES)) {
            this.exportDefaultProperties(line, args);
            return true;
        }
        if (cmd.equals(CMD_LIST_ENGINES)) {
            this.listEngines(line, args);
            return true;
        }
        if (cmd.equals(CMD_CREATE_WAR)) {
            this.generateWar(line, args);
            return true;
        }
        if (cmd.equals(CMD_EXPORT_SYM_TABLES)) {
            this.exportSymTables(line, args);
            return true;
        }
        if (cmd.equals(CMD_EXPORT_SYM_OBJECTS)) {
            this.exportSymObjects(line, args);
            return true;
        }
        if (cmd.equals(CMD_RUN_JOB)) {
            this.runJob(line, args);
            return true;
        }
        if (cmd.equals(CMD_RUN_PURGE)) {
            this.runPurge(line, args);
            return true;
        }
        if (cmd.equals(CMD_OPEN_REGISTRATION)) {
            this.openRegistration(line, args);
            return true;
        }
        if (cmd.equals(CMD_REMOVE_NODE)) {
            this.removeNode(line, args);
            return true;
        }
        if (cmd.equals(CMD_RELOAD_NODE)) {
            this.reloadNode(line, args);
            return true;
        }
        if (cmd.equals(CMD_EXPORT_BATCH)) {
            this.exportBatch(line, args);
            return true;
        }
        if (cmd.equals(CMD_SYNC_TRIGGERS)) {
            this.syncTrigger(line, args);
            return true;
        }
        if (cmd.equals(CMD_DROP_TRIGGERS)) {
            this.dropTrigger(line, args);
            return true;
        }
        if (cmd.equals(CMD_CREATE_SYM_TABLES)) {
            this.createSymTables();
            return true;
        }
        if (cmd.equals(CMD_IMPORT_BATCH)) {
            this.importBatch(line, args);
            return true;
        }
        if (cmd.equals(CMD_ENCRYPT_TEXT)) {
            this.encryptText(line, args);
            return true;
        }
        if (cmd.equals(CMD_OBFUSCATE_TEXT)) {
            this.obfuscateText(line, args);
            return true;
        }
        if (cmd.equals(CMD_UNOBFUSCATE_TEXT)) {
            this.unobfuscateText(line, args);
            return true;
        }
        if (cmd.equals(CMD_SEND_SQL)) {
            this.sendSql(line, args);
            return true;
        }
        if (cmd.equals(CMD_UNINSTALL)) {
            this.uninstall(line, args);
            return true;
        }
        if (cmd.equals(CMD_RELOAD_TABLE)) {
            this.reloadTable(line, args);
            return true;
        }
        if (cmd.equals(CMD_SEND_SCHEMA)) {
            this.sendSchema(line, args);
            return true;
        }
        if (cmd.equals(CMD_SEND_SCRIPT)) {
            this.sendScript(line, args);
            return true;
        }
        if (cmd.equals(CMD_MODULE)) {
            this.module(line, args);
            return true;
        }
        if (cmd.equals(CMD_BACKUP_FILE_CONFIGURATION)) {
            this.backup(line, args);
            return true;
        }
        if (cmd.equals(CMD_RESTORE_FILE_CONFIGURATION)) {
            this.restore(line, args);
            return true;
        }
        if (cmd.equals(CMD_IMPORT_CONFIG)) {
            this.importConfig(line, args);
            return true;
        }
        if (cmd.equals(CMD_EXPORT_CONFIG)) {
            this.exportConfig(line, args);
            return true;
        }
        if (cmd.equals(CMD_IMPORT_CERT)) {
            this.importCert(line, args);
            return true;
        }
        if (cmd.equals(CMD_TAKE_SNAPSHOT)) {
            this.takeSnapshot(line, args);
            return true;
        }
        throw new ParseException("ERROR: no subcommand '" + cmd + "' was found.");
    }

    private String popArg(List<String> args, String argName) {
        if (args.size() == 0) {
            System.out.println("ERROR: Expected argument for: " + argName);
            System.exit(1);
        }
        return args.remove(0);
    }

    @Override
    protected String scrubCommandLine(String[] cmdArgs) {
        boolean scrubNextArg = false;
        for (int i = 0; i < cmdArgs.length; ++i) {
            String arg = cmdArgs[i];
            if (scrubNextArg) {
                cmdArgs[i] = "***";
                scrubNextArg = false;
                continue;
            }
            if (arg == null || !arg.equals(CMD_ENCRYPT_TEXT) && !arg.equals(CMD_OBFUSCATE_TEXT) && !arg.equals(CMD_UNOBFUSCATE_TEXT)) continue;
            scrubNextArg = true;
        }
        return super.scrubCommandLine(cmdArgs);
    }

    private void importConfig(CommandLine line, List<String> args) {
        String fileName = this.popArg(args, "file name");
        boolean isCsv = fileName.toLowerCase().endsWith(".csv");
        boolean isSql = fileName.toLowerCase().endsWith(".sql");
        if (!isCsv && !isSql) {
            System.err.println("ERROR: Expected a .csv or .sql file.");
            System.exit(1);
        }
        try {
            File configFile = new File(fileName);
            if (isCsv) {
                String content = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset());
                if (!SymmetricUtils.importContainsCurrentGroup((ISymmetricEngine)this.getSymmetricEngine(), (String)content, (boolean)true)) {
                    System.err.println(String.format("ERROR: Imported .csv file doesn't contain current node group (%s)", this.engine.getParameterService().getNodeGroupId()));
                    System.exit(1);
                }
                IDataLoaderService service = this.getSymmetricEngine().getDataLoaderService();
                List batches = service.loadDataBatch(content);
                for (IncomingBatch batch : batches) {
                    if (batch.getStatus() != AbstractBatch.Status.ER) continue;
                    System.err.println("ERROR: batch failed with batch ID " + batch.getBatchId() + ".");
                    System.exit(1);
                }
            } else {
                URL url = configFile.toURI().toURL();
                if (!SymmetricUtils.importContainsCurrentGroup((ISymmetricEngine)this.getSymmetricEngine(), (URL)url, (boolean)false)) {
                    System.err.println(String.format("ERROR: Imported .sql file doesn't contain current node group (%s)", this.engine.getParameterService().getNodeGroupId()));
                    System.exit(1);
                }
                SqlScript script = new SqlScript(url, this.getSymmetricEngine().getDatabasePlatform().getSqlTemplate());
                script.execute();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void exportConfig(CommandLine line, List<String> args) {
        String fileName = this.popArg(args, "file name");
        try (FileWriter fw = new FileWriter(fileName);){
            if (fileName.toLowerCase().endsWith(".csv")) {
                IDataExtractorService dataExtractorService = this.getSymmetricEngine().getDataExtractorService();
                Node me = this.getSymmetricEngine().getNodeService().findIdentity();
                dataExtractorService.extractConfigurationStandalone(me, (Writer)fw, TableConstants.getConfigTablesExcludedFromExport());
            } else if (fileName.toLowerCase().endsWith(".sql")) {
                DbExportUtils.extractConfigurationStandalone((IDatabasePlatform)this.getSymmetricEngine().getDatabasePlatform(), (List)TableConstants.getConfigTablesForExport((String)this.getSymmetricEngine().getTablePrefix()), (Writer)fw);
            } else {
                System.err.println("ERROR: Expected a .csv or .sql file.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void listEngines(CommandLine line, List<String> args) {
        File[] files;
        System.out.println("Engines directory is " + new File(PropertiesUtil.getEnginesDir()).getAbsolutePath());
        System.out.println("The following engines and properties files are available:");
        int count = 0;
        for (File file : files = PropertiesUtil.findEnginePropertiesFiles()) {
            Properties properties = new Properties();
            try (FileInputStream is = new FileInputStream(file);){
                properties.load(is);
                String name = properties.getProperty("engine.name");
                System.out.println(name + " -> " + file.getAbsolutePath());
                ++count;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println(count + " engines returned");
    }

    private void runJob(CommandLine line, List<String> args) throws Exception {
        String jobName = this.popArg(args, "job name");
        if (jobName.equals("pull")) {
            this.getSymmetricEngine().pull();
            this.getSymmetricEngine().getNodeCommunicationService().stop();
        } else if (jobName.equals("push")) {
            this.getSymmetricEngine().push();
            this.getSymmetricEngine().getNodeCommunicationService().stop();
        } else if (jobName.equals("route")) {
            this.getSymmetricEngine().route();
        } else if (jobName.equals("purge")) {
            this.getSymmetricEngine().purge();
        } else if (jobName.equals("heartbeat")) {
            this.getSymmetricEngine().heartbeat(false);
        } else {
            throw new ParseException("ERROR: no job named '" + jobName + "' was found.");
        }
    }

    private void runPurge(CommandLine line, List<String> args) {
        boolean all;
        IPurgeService purgeService = this.getSymmetricEngine().getPurgeService();
        boolean bl = all = args.contains("all") || args.size() == 0;
        if (args.contains("outgoing") || all) {
            purgeService.purgeOutgoing(true);
        }
        if (args.contains("incoming") || all) {
            purgeService.purgeIncoming(true);
        }
    }

    private void exportBatch(CommandLine line, List<String> args) throws Exception {
        IDataExtractorService dataExtractorService = this.getSymmetricEngine().getDataExtractorService();
        String nodeId = this.popArg(args, "Node ID");
        String batchId = this.popArg(args, "Batch ID");
        OutputStreamWriter writer = this.getWriter(args);
        dataExtractorService.extractBatchRange((Writer)writer, nodeId, Long.valueOf(batchId).longValue(), Long.valueOf(batchId).longValue());
        writer.close();
    }

    private void importBatch(CommandLine line, List<String> args) throws Exception {
        IDataLoaderService service = this.getSymmetricEngine().getDataLoaderService();
        InputStream in = null;
        in = args.size() == 0 ? System.in : new FileInputStream(args.get(0));
        service.loadDataFromPush(this.getSymmetricEngine().getNodeService().findIdentity(), in, (OutputStream)System.out);
        System.out.flush();
        in.close();
    }

    private void encryptText(CommandLine line, List<String> args) {
        String plainText;
        if (args.size() != 0) {
            plainText = this.popArg(args, "Text");
        } else {
            Scanner textScanner = new Scanner(System.in);
            System.out.print("Enter Text: ");
            plainText = textScanner.next();
        }
        ISecurityService service = this.createSecurityService();
        System.out.println("enc:" + service.encrypt(plainText));
    }

    private ISecurityService createSecurityService() {
        TypedProperties properties = PropertiesUtil.createTypedPropertiesFactory((File)this.propertiesFile, (Properties)new Properties()).reload();
        return SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.SERVER, (TypedProperties)properties);
    }

    private void obfuscateText(CommandLine line, List<String> args) {
        String plainText = this.popArg(args, "Text");
        ISecurityService service = this.createSecurityService();
        System.out.println("obf:" + service.obfuscate(plainText));
    }

    private void unobfuscateText(CommandLine line, List<String> args) {
        String obfText = this.popArg(args, "Text");
        ISecurityService service = this.createSecurityService();
        System.out.println(service.unobfuscate(obfText.substring("obf:".length())));
    }

    private void openRegistration(CommandLine line, List<String> args) {
        String nodeGroupId = this.popArg(args, "Node Group ID");
        String externalId = this.popArg(args, "External ID");
        String syncUrl = args.size() > 0 ? args.remove(0) : null;
        IRegistrationService registrationService = this.getSymmetricEngine().getRegistrationService();
        registrationService.openRegistration(nodeGroupId, externalId, syncUrl, null, null);
        System.out.println(String.format("Opened registration for node group of '%s' external ID of '%s'", nodeGroupId, externalId));
    }

    private void removeNode(CommandLine line, List<String> args) {
        String node = line.getOptionValue(OPTION_NODE);
        this.getSymmetricEngine().removeAndCleanupNode(node);
        System.out.println(String.format("Removed node '%s' from engine '%s'", node, this.getSymmetricEngine().getEngineName()));
    }

    private void reloadNode(CommandLine line, List<String> args) {
        String nodeId = this.popArg(args, "Node ID");
        boolean reverse = line.hasOption(OPTION_REVERSE);
        IDataService dataService = this.getSymmetricEngine().getDataService();
        String message = dataService.reloadNode(nodeId, reverse, "symadmin");
        System.out.println(message);
    }

    private void backup(CommandLine line, List<String> args) throws IOException {
        Object filename = line.getOptionValue(OPTION_OUT);
        if (filename == null) {
            filename = "symmetric-file-configuration-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
        }
        File jarFile = null;
        if (filename != null && (jarFile = new File((String)filename)).getParentFile() != null) {
            jarFile.getParentFile().mkdirs();
        }
        ArrayList<Object> listOfDirs = new ArrayList<Object>();
        listOfDirs.add(PropertiesUtil.getEnginesDir());
        listOfDirs.add(AppUtils.getSymHome() + "/conf");
        listOfDirs.add(AppUtils.getSymHome() + "/patches");
        listOfDirs.add(AppUtils.getSymHome() + "/security");
        String parentDir = new File(DEFAULT_SERVER_PROPERTIES).getParent();
        if (parentDir != null && listOfDirs.indexOf(parentDir) < 0) {
            listOfDirs.add(DEFAULT_SERVER_PROPERTIES);
        }
        File[] arrayOfFile = new File[listOfDirs.size()];
        for (int i = 0; i < listOfDirs.size(); ++i) {
            arrayOfFile[i] = new File((String)listOfDirs.get(i));
        }
        System.out.println("Backing up files to " + (String)filename);
        try {
            ZipBuilder builder = new ZipBuilder(new File(AppUtils.getSymHome()), jarFile, arrayOfFile);
            builder.build();
        }
        catch (Exception e) {
            throw new IoException("Failed to backup configuration files into archive", (Throwable)e);
        }
    }

    private void restore(CommandLine line, List<String> args) throws IOException {
        String filename = line.getOptionValue(OPTION_IN);
        if (filename == null) {
            throw new IoException("Input filename must be specified", new Object[0]);
        }
        try (FileInputStream finput = new FileInputStream(filename);
             ZipInputStream zip = new ZipInputStream(finput);){
            ZipEntry entry = null;
            entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    System.out.println("Restoring " + entry.getName());
                    File fileToOpen = null;
                    File f = new File(entry.getName());
                    if (f.isAbsolute()) {
                        f.getParentFile().mkdirs();
                        fileToOpen = f;
                    } else {
                        fileToOpen = new File(AppUtils.getSymHome(), entry.getName());
                    }
                    try (FileOutputStream foutput = new FileOutputStream(fileToOpen);){
                        int readCount;
                        byte[] buffer = new byte[4096];
                        while ((readCount = zip.read(buffer, 0, buffer.length)) > 0) {
                            foutput.write(buffer, 0, readCount);
                        }
                    }
                }
                entry = zip.getNextEntry();
            }
        }
    }

    private void syncTrigger(CommandLine line, List<String> args) throws IOException {
        boolean genAlways = line.hasOption(OPTION_FORCE);
        String filename = line.getOptionValue(OPTION_OUT);
        String catalogName = line.getOptionValue(OPTION_CATALOG);
        String schemaName = line.getOptionValue(OPTION_SCHEMA);
        File file = null;
        if (filename != null && (file = new File(filename)).getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        ITriggerRouterService triggerService = this.getSymmetricEngine().getTriggerRouterService();
        StringBuilder sqlBuffer = new StringBuilder();
        if (args.size() == 0) {
            triggerService.syncTriggers(file != null ? sqlBuffer : null, genAlways);
        } else {
            for (String tablename : args) {
                Table table = this.platform.getTableFromCache(catalogName, schemaName, tablename, true);
                if (table != null) {
                    triggerService.syncTriggers(table, genAlways);
                    continue;
                }
                System.out.println("Unable to find table " + tablename);
            }
        }
        if (file != null) {
            FileUtils.writeStringToFile((File)file, (String)sqlBuffer.toString(), (Charset)Charset.defaultCharset(), (boolean)false);
        }
    }

    private void dropTrigger(CommandLine line, List<String> args) throws IOException {
        ITriggerRouterService triggerService = this.getSymmetricEngine().getTriggerRouterService();
        if (args.size() == 0) {
            boolean includeSymTriggers = line.hasOption(OPTION_SYM);
            if (includeSymTriggers) {
                String prefix = this.getSymmetricEngine().getParameterService().getTablePrefix();
                System.out.println("Dropping all triggers, including " + prefix + " triggers...");
            } else {
                System.out.println("Dropping all user-configured triggers...");
            }
            triggerService.dropTriggers(includeSymTriggers);
        } else {
            for (String tablename : args) {
                System.out.println("Dropping trigger for table " + tablename);
                HashSet<String> tables = new HashSet<String>();
                tables.add(tablename);
                triggerService.dropTriggers(tables);
            }
        }
    }

    private void generateWar(CommandLine line, List<String> args) throws Exception {
        boolean useProperties;
        String warFileName = this.popArg(args, "Filename");
        File workingDirectory = new File(AppUtils.getSymHome() + "/.war");
        FileUtils.deleteDirectory((File)workingDirectory);
        for (File file : FileUtils.listFiles((File)new File(AppUtils.getSymHome() + "/web/WEB-INF/lib"), (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.prefixFileFilter((String)"jetty-"), FileFilterUtils.prefixFileFilter((String)"websocket-")})), null)) {
            FileUtils.copyToDirectory((File)file, (File)new File(workingDirectory, "WEB-INF/lib"));
        }
        File instanceIdFile = new File(AppUtils.getSymHome() + "/conf/instance.uuid");
        if (instanceIdFile.canRead()) {
            FileUtils.copyToDirectory((File)instanceIdFile, (File)new File(workingDirectory, "WEB-INF/classes"));
        }
        boolean bl = useProperties = (line.hasOption("properties") || line.hasOption("engine")) && this.propertiesFile != null && this.propertiesFile.exists();
        if (useProperties) {
            System.out.println("Copying symmetric.properties");
            FileUtils.copyFile((File)this.propertiesFile, (File)new File(workingDirectory, "WEB-INF/classes/symmetric.properties"));
        }
        if (!line.hasOption(OPTION_EXTERNAL_SECURITY)) {
            System.out.println("Copying security files");
            FileUtils.copyToDirectory((File)new File(AppUtils.getSymHome() + "/security/keystore"), (File)new File(workingDirectory, "WEB-INF/classes"));
            FileUtils.copyToDirectory((File)new File(AppUtils.getSymHome() + "/security/cacerts"), (File)new File(workingDirectory, "WEB-INF/classes"));
            File restPropFile = new File(AppUtils.getSymHome() + "/security/rest.properties");
            if (restPropFile.exists()) {
                FileUtils.copyToDirectory((File)restPropFile, (File)new File(workingDirectory, "WEB-INF/classes"));
            }
        }
        if (!line.hasOption(OPTION_EXCLUDE_LOG4J)) {
            System.out.println("Copying log4j files");
            FileUtils.copyToDirectory((File)new File(AppUtils.getSymHome() + "/conf/log4j2.xml"), (File)new File(workingDirectory, "WEB-INF/classes"));
            for (File file : FileUtils.listFiles((File)new File(AppUtils.getSymHome() + "/lib"), (IOFileFilter)FileFilterUtils.prefixFileFilter((String)"log4j-"), null)) {
                FileUtils.copyToDirectory((File)file, (File)new File(workingDirectory, "WEB-INF/lib"));
            }
        }
        System.out.println("Copying symmetric-server.properties");
        Properties prop = new Properties();
        try (FileInputStream in = new FileInputStream(AppUtils.getSymHome() + "/conf/symmetric-server.properties");){
            prop.load(in);
            prop.remove("host.bind.name");
            prop.remove("http.enable");
            prop.remove("https.enable");
            prop.remove("https2.enable");
            prop.remove("http.port");
            prop.remove("https.port");
            if (StringUtils.isNotBlank((CharSequence)System.getProperty("javax.net.ssl.keyStorePassword"))) {
                ISecurityService service = this.createSecurityService();
                String password = "obf:" + service.obfuscate(System.getProperty("javax.net.ssl.keyStorePassword"));
                prop.put("javax.net.ssl.keyStorePassword", password);
            }
            try (FileOutputStream out = new FileOutputStream(new File(workingDirectory, "WEB-INF/classes/symmetric-server.properties"));){
                prop.store(out, warFileName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to process symmetric-server.properties", (Throwable)e);
        }
        System.out.println("Building web archive");
        JarBuilder builder = new JarBuilder(workingDirectory, new File(warFileName), new File[]{workingDirectory}, Version.version());
        builder.build();
        System.out.println("Cleaning up");
        FileUtils.deleteDirectory((File)workingDirectory);
        System.out.println("Created " + warFileName);
        System.out.println("\nRemember to:");
        if (!line.hasOption(OPTION_EXCLUDE_LOG4J)) {
            System.out.println("- Edit " + warFileName + ":/WEB-INF/classes/log4j2.xml to set the path and filename to the log file");
        }
        if (useProperties) {
            System.out.println("- Edit " + warFileName + ":/WEB-INF/classes/symmetric.properties to set sync.url to match web server");
        } else {
            System.out.println("- Set system property for engines directory: -Dsymmetric.engines.dir=/path/to/dir");
        }
        if (line.hasOption(OPTION_EXTERNAL_SECURITY)) {
            System.out.println("- Set system property for security file: -Dsym.keystore.file=/path/to/keystore");
            System.out.println("- Set system property for cacerts file: -Djavax.net.ssl.trustStore=/path/to/cacerts");
            System.out.println("- Set system property for REST file: -Dsym.rest.properties.file=/path/to/rest.properties");
        }
        if (line.hasOption(OPTION_EXCLUDE_LOG4J)) {
            System.out.println("- Provide a SLF4J binding JAR for your logging framework");
        }
        System.out.println("- Provide JDBC driver JAR for your database");
    }

    private void exportSymTables(CommandLine line, List<String> args) throws IOException {
        OutputStreamWriter os = this.getWriter(args);
        if (line.hasOption(OPTION_ALTERS)) {
            os.write(this.getSymmetricEngine().getSymmetricDialect().getSymmetricDdlChanges());
        } else {
            os.write(this.getSymmetricEngine().getSymmetricDialect().getCreateSymmetricDDL());
        }
        os.close();
    }

    private void exportSymObjects(CommandLine line, List<String> args) throws IOException {
        ISymmetricEngine engine = this.getSymmetricEngine();
        ISymmetricDialect dialect = engine.getSymmetricDialect();
        OutputStreamWriter os = this.getWriter(args);
        os.write(dialect.getCreateRequiredDatabaseObjectsDDL());
        if (!line.hasOption(OPTION_EXCLUDE_TABLES)) {
            os.write(dialect.getCreateSymmetricDDL());
        }
        os.close();
    }

    private void exportDefaultProperties(CommandLine line, List<String> args) throws IOException {
        OutputStreamWriter os = this.getWriter(args);
        BufferedReader is = new BufferedReader(new InputStreamReader(SymmetricAdmin.class.getResourceAsStream("/symmetric-default.properties"), Charset.defaultCharset()));
        String str = is.readLine();
        while (str != null) {
            os.write(str);
            os.write(System.getProperty("line.separator"));
            str = is.readLine();
        }
        is.close();
        os.close();
    }

    private void createSymTables() {
        this.getSymmetricEngine().setupDatabase(true);
    }

    private void uninstall(CommandLine line, List<String> args) {
        this.getSymmetricEngine().uninstall();
    }

    private void sendSql(CommandLine line, List<String> args) {
        String sql;
        String tableName = this.popArg(args, "Table Name");
        String catalogName = line.getOptionValue(OPTION_CATALOG);
        String schemaName = line.getOptionValue(OPTION_SCHEMA);
        String fileName = line.getOptionValue(OPTION_FILE);
        if (fileName != null) {
            try {
                File sqlFile = new File(fileName);
                sql = FileUtils.readFileToString((File)sqlFile, (Charset)Charset.defaultCharset());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            sql = this.popArg(args, "SQL");
        }
        for (Node node : this.getNodes(line)) {
            System.out.println("Sending SQL to node '" + node.getNodeId() + "'");
            this.getSymmetricEngine().getDataService().sendSQL(node.getNodeId(), catalogName, schemaName, tableName, sql);
        }
    }

    private void reloadTable(CommandLine line, List<String> args) {
        String catalogName = line.getOptionValue(OPTION_CATALOG);
        String schemaName = line.getOptionValue(OPTION_SCHEMA);
        if (args.size() == 0) {
            System.out.println("ERROR: Expected argument for: Table Name");
            System.exit(1);
        }
        for (String tableName : args) {
            for (Node node : this.getNodes(line)) {
                System.out.println("Reloading table '" + tableName + "' to node '" + node.getNodeId() + "'");
                if (line.hasOption(OPTION_WHERE)) {
                    System.out.println(this.getSymmetricEngine().getDataService().reloadTable(node.getNodeId(), catalogName, schemaName, tableName, line.getOptionValue(OPTION_WHERE)));
                    continue;
                }
                System.out.println(this.getSymmetricEngine().getDataService().reloadTable(node.getNodeId(), catalogName, schemaName, tableName));
            }
        }
    }

    private void sendSchema(CommandLine line, List<String> args) {
        block10: {
            Collection<Node> nodes;
            boolean excludeDefaults;
            boolean excludeForeignKeys;
            boolean excludeIndices;
            String schema;
            String catalog;
            block9: {
                catalog = line.getOptionValue(OPTION_CATALOG);
                schema = line.getOptionValue(OPTION_SCHEMA);
                excludeIndices = line.hasOption(OPTION_EXCLUDE_INDICES);
                excludeForeignKeys = line.hasOption(OPTION_EXCLUDE_FOREIGN_KEYS);
                excludeDefaults = line.hasOption(OPTION_EXCLUDE_DEFAULTS);
                nodes = this.getNodes(line);
                if (args.size() != 0) break block9;
                List activeTriggerHistories = this.engine.getTriggerRouterService().getActiveTriggerHistories();
                for (TriggerHistory hist : activeTriggerHistories) {
                    for (Node node : nodes) {
                        if (catalog != null && !catalog.equals(hist.getSourceCatalogName()) || schema != null && !schema.equals(hist.getSourceSchemaName())) continue;
                        this.getSymmetricEngine().getDataService().sendSchema(node.getNodeId(), hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), false, excludeIndices, true, excludeDefaults);
                    }
                }
                if (excludeForeignKeys) break block10;
                for (TriggerHistory hist : activeTriggerHistories) {
                    for (Node node : nodes) {
                        if (catalog != null && !catalog.equals(hist.getSourceCatalogName()) || schema != null && !schema.equals(hist.getSourceSchemaName())) continue;
                        this.getSymmetricEngine().getDataService().sendSchema(node.getNodeId(), hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), false, excludeIndices, excludeForeignKeys, excludeDefaults);
                    }
                }
                break block10;
            }
            for (String tableName : args) {
                for (Node node : nodes) {
                    this.getSymmetricEngine().getDataService().sendSchema(node.getNodeId(), catalog, schema, tableName, false, excludeIndices, true, excludeDefaults);
                }
            }
            if (!excludeForeignKeys) {
                for (String tableName : args) {
                    for (Node node : nodes) {
                        this.getSymmetricEngine().getDataService().sendSchema(node.getNodeId(), catalog, schema, tableName, false, excludeIndices, excludeForeignKeys, excludeDefaults);
                    }
                }
            }
        }
    }

    private void sendScript(CommandLine line, List<String> args) throws Exception {
        String scriptName = this.popArg(args, "Script Name");
        String scriptData = FileUtils.readFileToString((File)new File(scriptName), (Charset)Charset.defaultCharset());
        for (Node node : this.getNodes(line)) {
            System.out.println("Sending script to node '" + node.getNodeId() + "'");
            this.getSymmetricEngine().getDataService().sendScript(node.getNodeId(), scriptData, false);
        }
    }

    private Collection<Node> getNodes(CommandLine line) {
        if (line.hasOption(OPTION_NODE_GROUP)) {
            return this.getSymmetricEngine().getNodeService().findEnabledNodesFromNodeGroup(line.getOptionValue(OPTION_NODE_GROUP));
        }
        if (line.hasOption(OPTION_NODE)) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            String nodeId = line.getOptionValue(OPTION_NODE);
            Node node = this.getSymmetricEngine().getNodeService().findNode(nodeId);
            if (node == null) {
                System.out.println("ERROR: Unable to find node '" + nodeId + "'");
                System.exit(1);
            }
            nodes.add(node);
            return nodes;
        }
        System.out.println("ERROR: Must specify one option: node, node-group");
        System.exit(1);
        return null;
    }

    private OutputStreamWriter getWriter(List<String> args) throws IOException {
        OutputStreamWriter os = null;
        if (args.size() == 0) {
            os = new OutputStreamWriter(System.out);
        } else {
            File file = new File(args.get(0));
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            os = new FileWriter(file);
        }
        return os;
    }

    private void module(CommandLine line, List<String> args) throws Exception {
        String action = this.popArg(args, "Action");
        String moduleArgName = "Module";
        try {
            ModuleManager mgr = ModuleManager.getInstance();
            if (action.equals("install")) {
                mgr.install(this.popArg(args, "Module"));
            } else if (action.equals("remove")) {
                mgr.remove(this.popArg(args, "Module"));
            } else if (action.equals("list-files")) {
                String module = this.popArg(args, "Module");
                List files = mgr.listFiles(module);
                System.out.println("Files associated with module " + module + ":");
                for (String file : files) {
                    System.out.println(file);
                }
            } else if (action.equals("list-deps")) {
                String module = this.popArg(args, "Module");
                List files = mgr.listDependencies(module);
                System.out.println("Files associated with module " + module + ":");
                for (String file : files) {
                    System.out.println(file);
                }
            } else if (action.equals("list")) {
                List modules = mgr.list();
                System.out.println("Installed modules:");
                if (modules.size() == 0) {
                    System.out.println("<none>");
                } else {
                    for (String module : modules) {
                        System.out.println(module);
                    }
                }
            } else if (action.equals("list-all")) {
                List modules = mgr.listAll();
                System.out.println("Available modules:");
                for (String module : modules) {
                    System.out.println(module);
                }
            } else if (action.equals("upgrade")) {
                System.out.println("Upgrading modules");
                mgr.upgradeAll();
            } else if (action.equals("list-upgrade")) {
                List files = mgr.listUpgrade();
                System.out.println("Files that need upgraded:");
                for (String file : files) {
                    System.out.println(file);
                }
            } else if (action.equals("convert")) {
                System.out.println("Converting to modules");
                mgr.convertToModules();
            }
        }
        catch (ModuleException e) {
            if (!e.isLogged()) {
                System.err.println("ERROR: " + e.getMessage());
            }
            System.exit(1);
        }
    }

    private void importCert(CommandLine line, List<String> args) {
        String urlString = this.popArg(args, "URL");
        try {
            Certificate[] certs = SymmetricUtils.getCertificates((String)urlString);
            if (certs == null) {
                System.err.println("ERROR: URL must use HTTPS protocol");
                System.exit(1);
                return;
            }
            for (Certificate cert : certs) {
                if (!(cert instanceof X509Certificate)) continue;
                try {
                    String certString = FormatUtils.convertToPem((X509Certificate)((X509Certificate)cert));
                    this.importCert(certString.getBytes(), null, null, line.hasOption(OPTION_ACCEPT_ALL));
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    // empty catch block
                }
            }
        }
        catch (MalformedURLException e) {
            System.err.println("ERROR: URL is invalid");
            System.exit(1);
            return;
        }
        catch (IOException e) {
            System.err.println("ERROR: Failed to connect to URL");
            System.exit(1);
            return;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            System.err.println("ERROR: Failed to initialize SSL context");
            System.exit(1);
            return;
        }
    }

    private void importCert(byte[] certData, String alias, String password, boolean acceptAll) {
        try {
            ISecurityService bouncyCastleSecurityService = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.SERVER, (TypedProperties)new TypedProperties(System.getProperties()));
            KeyStore.TrustedCertificateEntry entry = bouncyCastleSecurityService.createTrustedCert(certData, "pem", alias, password);
            if (acceptAll) {
                this.getSymmetricEngine().getSecurityService().installTrustedCert(entry);
            } else {
                Certificate trustedCertificate = entry.getTrustedCertificate();
                String subject = "";
                String issuer = "";
                Object keyType = "";
                String effective = "";
                String expiration = "";
                boolean isValid = false;
                if (trustedCertificate instanceof X509Certificate) {
                    Date now;
                    Date expirationDate;
                    X509Certificate x509Certificate = (X509Certificate)trustedCertificate;
                    subject = x509Certificate.getSubjectX500Principal().getName().replace(",", ", ");
                    issuer = x509Certificate.getIssuerX500Principal().getName().replace(",", ", ");
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    if (publicKey instanceof RSAPublicKey) {
                        keyType = "RSA " + ((RSAPublicKey)publicKey).getModulus().bitLength() + "-bit";
                    } else if (publicKey instanceof DSAPublicKey) {
                        keyType = "DSA " + ((DSAPublicKey)publicKey).getParams().getP().bitLength() + "-bit";
                    }
                    Date effectiveDate = x509Certificate.getNotBefore();
                    if (effectiveDate != null) {
                        effective = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aaa").format(effectiveDate);
                    }
                    if ((expirationDate = x509Certificate.getNotAfter()) != null) {
                        expiration = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aaa").format(expirationDate);
                    }
                    isValid = (now = new Date()).compareTo(effectiveDate) >= 0 && now.compareTo(expirationDate) <= 0;
                }
                System.out.println("Subject: " + subject);
                System.out.println("Issuer: " + issuer);
                System.out.println("Key Type: " + (String)keyType);
                System.out.println("Effective Date: " + effective);
                System.out.println("Expiration Date: " + expiration);
                if (isValid) {
                    while (true) {
                        String answer;
                        if ("Y".equalsIgnoreCase(answer = System.console().readLine("Accept this certificate? (Y/N): ", new Object[0])) || "YES".equalsIgnoreCase(answer)) {
                            this.getSymmetricEngine().getSecurityService().installTrustedCert(entry);
                        } else if (!"N".equalsIgnoreCase(answer) && !"NO".equalsIgnoreCase(answer)) {
                            System.err.println("ERROR: Invalid answer");
                            continue;
                        }
                        break;
                    }
                } else {
                    System.out.println("This certificate is not valid!");
                }
            }
        }
        catch (KeystoreAliasException e) {
            System.out.println("Select which certificate to import");
            List aliasList = e.getAliases();
            for (int i = 0; i < aliasList.size(); ++i) {
                System.out.println(i + 1 + ". " + (String)aliasList.get(i));
            }
            while (true) {
                try {
                    int selectedIndex = Integer.parseInt(System.console().readLine("Enter your selection: ", new Object[0]));
                    this.importCert(certData, (String)aliasList.get(selectedIndex - 1), password, acceptAll);
                }
                catch (NumberFormatException ex) {
                    System.err.println("ERROR: Selection was not an integer");
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    System.err.println("ERROR: Invalid selection");
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) {
                this.importCert(certData, alias, new String(System.console().readPassword("Enter password to access certificate: ", new Object[0])), acceptAll);
            }
            if (e.getMessage() != null) {
                System.err.println("ERROR: Import failed: " + e.getMessage());
            } else {
                System.err.println("ERROR: Import failed");
            }
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSnapshot(CommandLine line, List<String> args) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        String secret = this.getSymmetricEngine().getSecurityService().nextSecureHexString(16);
        File secretFile = new File(tmpDir, secret);
        try {
            secretFile.createNewFile();
        }
        catch (IOException e) {
            System.err.println("ERROR: Failed to create shared secret file in the following directory: " + tmpDir);
            e.printStackTrace();
            System.exit(1);
            return;
        }
        Object snapshotUrl = this.getSymmetricEngine().getSyncUrl();
        if (!((String)snapshotUrl).endsWith("/")) {
            snapshotUrl = (String)snapshotUrl + "/";
        }
        snapshotUrl = (String)snapshotUrl + "snapshot";
        System.out.println("Contacting " + (String)snapshotUrl);
        HttpURLConnection snapshotHttpUrlConnection = null;
        boolean success = false;
        try {
            URLConnection snapshotUrlConnection = new URL((String)snapshotUrl).openConnection();
            if (snapshotUrlConnection instanceof HttpURLConnection) {
                snapshotHttpUrlConnection = (HttpURLConnection)snapshotUrlConnection;
                snapshotHttpUrlConnection.setDoInput(true);
                snapshotHttpUrlConnection.setDoOutput(true);
                snapshotHttpUrlConnection.setRequestMethod("POST");
                snapshotHttpUrlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                System.out.println("Requesting snapshot");
                snapshotHttpUrlConnection.connect();
                snapshotHttpUrlConnection.getOutputStream().write(secret.getBytes(StandardCharsets.UTF_8));
                success = snapshotHttpUrlConnection.getResponseCode() == 200;
                BufferedReader httpReader = new BufferedReader(new InputStreamReader(snapshotHttpUrlConnection.getInputStream()));
                String httpOutputLine = null;
                while ((httpOutputLine = httpReader.readLine()) != null) {
                    System.out.println(httpOutputLine);
                }
                httpReader.close();
            }
        }
        catch (MalformedURLException e) {
            System.err.println("ERROR: Snapshot URL is invalid");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("ERROR: Exception when connecting to snapshot URL");
            e.printStackTrace();
        }
        finally {
            if (snapshotHttpUrlConnection != null) {
                snapshotHttpUrlConnection.disconnect();
            }
            secretFile.delete();
            if (success) {
                System.out.println("Success");
                System.exit(0);
            } else {
                System.out.println("Failed");
                System.exit(1);
            }
        }
    }
}

