/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Pre;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlScriptReader;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.sqlexplorer.AbortedQueryException;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.QueryPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlExplorer;
import org.jumpmind.vaadin.ui.sqlexplorer.TabularResultLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRunner
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(SqlRunner.class);
    private SqlExplorer explorer;
    private static List<SqlRunner> sqlRunners = new ArrayList<SqlRunner>();
    private ISqlRunnerListener listener;
    private QueryPanel queryPanel;
    private boolean isInQueryGeneralResults;
    private boolean runAsScript;
    private String sqlText;
    private Connection connection;
    private Date startTime = new Date();
    private Date endTime = null;
    private boolean rowsUpdated = false;
    private boolean createdConnection = true;
    private boolean showSqlOnResults = true;
    private IDb db;
    private String user;
    private boolean autoCommit;
    private boolean logAtDebug;
    private static final String COMMIT_COMMAND = "commit";
    private Settings settings;
    private boolean isCanceled = false;
    private PreparedStatement stmt;

    public static List<SqlRunner> getSqlRunners() {
        return sqlRunners;
    }

    public SqlRunner(String sqlText, boolean runAsScript, String user, IDb db, Settings settings) {
        this(sqlText, runAsScript, user, db, settings, null, null);
    }

    public SqlRunner(String sqlText, boolean runAsScript, String user, IDb db, Settings settings, ISqlRunnerListener listener) {
        this(sqlText, runAsScript, user, db, settings, null, listener);
    }

    public SqlRunner(String sqlText, boolean runAsScript, String user, IDb db, Settings settings, SqlExplorer explorer) {
        this(sqlText, runAsScript, user, db, settings, explorer, null);
    }

    public SqlRunner(String sqlText, boolean runAsScript, String user, IDb db, Settings settings, SqlExplorer explorer, ISqlRunnerListener listener) {
        this(sqlText, runAsScript, user, db, settings, explorer, listener, null, false);
    }

    public SqlRunner(String sqlText, boolean runAsScript, String user, IDb db, Settings settings, QueryPanel queryPanel, boolean isInQueryGeneralResults) {
        this(sqlText, runAsScript, user, db, settings, null, null, queryPanel, isInQueryGeneralResults);
    }

    public SqlRunner(String sqlText, boolean runAsScript, String user, IDb db, Settings settings, SqlExplorer explorer, ISqlRunnerListener listener, QueryPanel queryPanel, boolean isInQueryGeneralResults) {
        this.setName("sql-runner-" + this.getId());
        this.sqlText = sqlText;
        this.runAsScript = runAsScript;
        this.db = db;
        this.listener = listener;
        this.settings = settings;
        this.autoCommit = settings.getProperties().is("sql.explorer.auto.commit");
        this.user = user;
        this.explorer = explorer;
        this.queryPanel = queryPanel;
        this.isInQueryGeneralResults = isInQueryGeneralResults;
        sqlRunners.add(0, this);
    }

    public void setLogAtDebug(boolean logAtDebug) {
        this.logAtDebug = logAtDebug;
    }

    public void setShowSqlOnResults(boolean showSqlOnResults) {
        this.showSqlOnResults = showSqlOnResults;
    }

    public static void commit(Connection connection) throws SQLException {
        if (connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
                JdbcSqlTemplate.close((Connection)connection);
            }
        }
    }

    public static void rollback(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
            }
            finally {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
                JdbcSqlTemplate.close((Connection)connection);
            }
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        DataSource dataSource;
        boolean autoCommitBefore;
        boolean committed;
        VaadinIcon icon;
        ArrayList<Component> resultComponents;
        boolean ignoreWhenRunAsScript;
        String delimiter;
        int maxResultsSize;
        boolean resultsAsText;
        block59: {
            TypedProperties properties = this.settings.getProperties();
            resultsAsText = properties.is("sql.explorer.result.as.text");
            maxResultsSize = properties.getInt("sql.explorer.max.results");
            delimiter = properties.get("sql.explorer.delimiter");
            ignoreWhenRunAsScript = properties.is("sql.explorer.ignore.errors.when.running.scripts");
            resultComponents = new ArrayList<Component>();
            icon = VaadinIcon.CHECK_CIRCLE;
            this.rowsUpdated = false;
            committed = false;
            autoCommitBefore = true;
            dataSource = (DataSource)this.db.getPlatform().getDataSource();
            if (this.db.getPlatform().getSqlTemplate() instanceof JdbcSqlTemplate) break block59;
            resultComponents.add((Component)this.wrapTextInComponent("<span style='color: red'> SQL queries are not available for this platform. </span>", "marked"));
            this.endTime = new Date();
            if (this.listener != null) {
                this.listener.finished(icon, resultComponents, this.endTime.getTime() - this.startTime.getTime(), !this.autoCommit && this.rowsUpdated, committed);
                return;
            }
            if (this.autoCommit) return;
            SqlRunner.rollback(this.connection);
            return;
        }
        try {
            JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.db.getPlatform().getSqlTemplate();
            this.stmt = null;
            StringBuilder results = new StringBuilder();
            try {
                if (this.connection == null) {
                    this.connection = dataSource.getConnection();
                    this.connection.setAutoCommit(this.autoCommit);
                }
                autoCommitBefore = this.connection.getAutoCommit();
                if (this.connection.getTransactionIsolation() != sqlTemplate.getIsolationLevel()) {
                    this.connection.setTransactionIsolation(sqlTemplate.getIsolationLevel());
                }
                if (sqlTemplate.isRequiresAutoCommitFalseToSetFetchSize()) {
                    this.connection.setAutoCommit(false);
                }
                try (SqlScriptReader sqlReader = new SqlScriptReader((Reader)new StringReader(this.sqlText));){
                    sqlReader.setDelimiter(delimiter);
                    sqlReader.setStripOutComments(true);
                    String sql = sqlReader.readSqlStatement();
                    while (sql != null) {
                        JdbcSqlTemplate.close((PreparedStatement)this.stmt);
                        this.stmt = this.db.getPlatform().getName().equals("voltdb") ? this.connection.prepareStatement(sql, 1004, 1007) : this.connection.prepareStatement(sql, 1003, 1007);
                        String lowercaseSql = sql.trim().toLowerCase();
                        if (!(lowercaseSql.startsWith("delete") || lowercaseSql.startsWith("update") || lowercaseSql.startsWith("insert"))) {
                            if (this.db.getPlatform().getName().equals("mysql")) {
                                this.stmt.setFetchSize(Integer.MIN_VALUE);
                            } else {
                                this.stmt.setFetchSize(maxResultsSize < 100 ? maxResultsSize : 100);
                            }
                        }
                        if (this.settings != null && !this.settings.isAllowQueries()) {
                            log.info("[{}] Blocked execution by {} in hidden mode: {}", new Object[]{this.db.getName(), this.user, sql.trim()});
                            throw new AbortedQueryException("No query access in hidden mode");
                        }
                        if (this.settings != null && !this.settings.isAllowDml() && !lowercaseSql.startsWith("select")) {
                            log.info("[{}] Blocked execution by {} in read-only mode: {}", new Object[]{this.db.getName(), this.user, sql.trim()});
                            throw new AbortedQueryException("Only select statements are allowed in read-only mode");
                        }
                        if (this.logAtDebug) {
                            log.debug("[" + this.db.getName() + "] Executing by {}: {}", (Object)this.user, (Object)sql.trim());
                        } else {
                            log.info("[" + this.db.getName() + "] Executing by {}: {}", (Object)this.user, (Object)sql.trim());
                        }
                        committed = sql.replaceAll("\\s", "").equalsIgnoreCase(COMMIT_COMMAND);
                        boolean hasResults = false;
                        try {
                            hasResults = this.stmt.execute();
                        }
                        catch (SQLException e) {
                            if (!this.runAsScript || !ignoreWhenRunAsScript) throw e;
                            results.append(sql);
                            results.append("\n");
                            results.append(this.buildErrorMessage(e));
                            results.append("\n");
                            results.append("\n");
                        }
                        int updateCount = this.stmt.getUpdateCount();
                        boolean firstTimeThrough = true;
                        while (hasResults || updateCount != -1 || firstTimeThrough) {
                            ResultSet rs;
                            block60: {
                                rs = null;
                                try {
                                    if (hasResults) {
                                        rs = this.stmt.getResultSet();
                                        if (!this.runAsScript) {
                                            if (!resultsAsText) {
                                                resultComponents.add((Component)new TabularResultLayout(this.explorer, this.db, sql, rs, this.listener, this.user, this.settings, this.queryPanel, this.showSqlOnResults, this.isInQueryGeneralResults));
                                            } else {
                                                resultComponents.add((Component)this.putResultsInArea(rs, maxResultsSize));
                                            }
                                        } else {
                                            int rowsRetrieved = 0;
                                            while (rs.next()) {
                                                ++rowsRetrieved;
                                            }
                                            results.append(sql);
                                            results.append("\n");
                                            results.append("Rows Retrieved: ");
                                            results.append(rowsRetrieved);
                                            results.append("\n");
                                            results.append("\n");
                                        }
                                    } else {
                                        boolean bl = this.rowsUpdated = updateCount > 0;
                                        if (!this.runAsScript) {
                                            String message = null;
                                            message = updateCount > 0 ? String.format("%d rows affected", updateCount) : "Statement(s) executed";
                                            resultComponents.add((Component)this.wrapTextInComponent(message));
                                        } else {
                                            results.append(sql);
                                            results.append("\n");
                                            if (updateCount > 0) {
                                                results.append("Rows Affected: ");
                                                results.append(updateCount);
                                            } else {
                                                results.append("Statement executed");
                                            }
                                            results.append("\n");
                                            results.append("\n");
                                        }
                                    }
                                    hasResults = this.stmt.getMoreResults();
                                    updateCount = this.stmt.getUpdateCount();
                                    if (!this.db.getPlatform().getName().equals("firebird") || hasResults || updateCount != 0) break block60;
                                    updateCount = -1;
                                }
                                catch (Throwable throwable) {
                                    JdbcSqlTemplate.close(rs);
                                    firstTimeThrough = false;
                                    throw throwable;
                                }
                            }
                            JdbcSqlTemplate.close((ResultSet)rs);
                            firstTimeThrough = false;
                        }
                        sql = sqlReader.readSqlStatement();
                    }
                }
            }
            catch (AbortedQueryException ex) {
                resultComponents.add((Component)this.wrapTextInComponent(this.buildErrorMessage(ex.getMessage()), "marked"));
            }
            catch (Throwable ex) {
                if (this.isCanceled) {
                    String canceledMessage = "Canceled successfully.\n\n" + this.sqlText;
                    resultComponents.add((Component)this.wrapTextInComponent(canceledMessage));
                } else {
                    icon = VaadinIcon.BAN;
                    resultComponents.add((Component)this.wrapTextInComponent(this.buildErrorMessage(ex), "marked"));
                }
            }
            finally {
                if (autoCommitBefore) {
                    try {
                        this.connection.commit();
                        this.connection.setAutoCommit(autoCommitBefore);
                    }
                    catch (SQLException ex) {}
                }
                JdbcSqlTemplate.close((PreparedStatement)this.stmt);
                if (this.autoCommit || !this.autoCommit && !this.rowsUpdated && this.createdConnection) {
                    JdbcSqlTemplate.close((Connection)this.connection);
                    this.connection = null;
                }
            }
            if (resultComponents.size() == 0 && StringUtils.isNotBlank((CharSequence)results.toString())) {
                resultComponents.add((Component)this.wrapTextInComponent(results.toString(), icon == VaadinIcon.BAN ? "marked" : null));
            }
            this.endTime = new Date();
            if (this.listener != null) {
                this.listener.finished(icon, resultComponents, this.endTime.getTime() - this.startTime.getTime(), !this.autoCommit && this.rowsUpdated, committed);
                return;
            }
            if (this.autoCommit) return;
        }
        catch (Throwable throwable) {
            this.endTime = new Date();
            if (this.listener != null) {
                this.listener.finished(icon, resultComponents, this.endTime.getTime() - this.startTime.getTime(), !this.autoCommit && this.rowsUpdated, committed);
                throw throwable;
            } else {
                if (this.autoCommit) throw throwable;
                SqlRunner.rollback(this.connection);
            }
            throw throwable;
        }
        SqlRunner.rollback(this.connection);
    }

    protected String buildErrorMessage(Throwable ex) {
        StringBuilder errorMessage = new StringBuilder("<span style='color: red'>");
        if (ex instanceof SQLException) {
            SQLException sqlException = (SQLException)ex;
            errorMessage.append("SQL Message: ").append(ex.getMessage());
            errorMessage.append("\nSQL State: ");
            errorMessage.append(sqlException.getSQLState());
            errorMessage.append("\nError Code: ");
            errorMessage.append(sqlException.getErrorCode());
        } else {
            errorMessage.append(ex.getMessage());
            errorMessage.append(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        errorMessage.append("</span>");
        return errorMessage.toString();
    }

    protected String buildErrorMessage(String message) {
        StringBuilder errorMessage = new StringBuilder("<span style='color: red'>");
        errorMessage.append(message);
        errorMessage.append("</span>");
        return errorMessage.toString();
    }

    protected Class<?> getClass(ResultSetMetaData meta, int i) throws SQLException {
        try {
            return Class.forName(meta.getColumnClassName(i));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Scroller wrapTextInComponent(String text) {
        return this.wrapTextInComponent(text, null);
    }

    protected Scroller wrapTextInComponent(String text, String style) {
        Scroller panel = new Scroller();
        VerticalLayout content = new VerticalLayout();
        content.setMargin(false);
        panel.setContent((Component)content);
        Label label = new Label("<pre>" + text + "</pre>");
        label.getStyle().set("margin", null);
        if (StringUtils.isNotBlank((CharSequence)style)) {
            label.setClassName(style);
        }
        content.add(new Component[]{label});
        return panel;
    }

    protected Scroller putResultsInArea(ResultSet rs, int maxResultSize) throws SQLException {
        Scroller panel = new Scroller();
        Pre pre = new Pre(this.resultsAsText(rs, maxResultSize));
        panel.setContent((Component)pre);
        pre.getStyle().set("margin", "0");
        pre.getStyle().set("white-space", "pre");
        pre.setWidth("max-content");
        return panel;
    }

    protected String resultsAsText(ResultSet rs, int maxResultSize) throws SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        int columns = meta.getColumnCount();
        int[] maxColumnSizes = new int[columns];
        for (int i2 = 1; i2 <= columns; ++i2) {
            String columnName = meta.getColumnName(i2);
            maxColumnSizes[i2 - 1] = columnName.length();
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (int rowNumber = 1; rs.next() && rowNumber <= maxResultSize; ++rowNumber) {
            Object[] row = new Object[columns];
            for (i = 1; i <= columns; ++i) {
                int size;
                Object obj;
                row[i - 1] = obj = CommonUiUtils.getObject(rs, i);
                if (obj == null || maxColumnSizes[i - 1] >= (size = obj.toString().length())) continue;
                maxColumnSizes[i - 1] = size;
            }
            rows.add(row);
        }
        StringBuilder text = new StringBuilder();
        for (i = 1; i <= columns; ++i) {
            String columnName = meta.getColumnName(i);
            text.append(StringUtils.rightPad((String)columnName, (int)maxColumnSizes[i - 1]));
            text.append(" ");
        }
        text.append("\n");
        for (i = 1; i <= columns; ++i) {
            text.append(StringUtils.rightPad((String)"", (int)maxColumnSizes[i - 1], (String)"-"));
            text.append(" ");
        }
        text.append("\n");
        for (Object[] objects : rows) {
            for (int i3 = 0; i3 < objects.length; ++i3) {
                text.append(StringUtils.rightPad((String)(objects[i3] != null ? objects[i3].toString() : "<null>"), (int)maxColumnSizes[i3]));
                text.append(" ");
            }
            text.append("\n");
        }
        return text.toString();
    }

    public void setListener(ISqlRunnerListener listener) {
        this.listener = listener;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        if (connection != null) {
            this.createdConnection = false;
        }
        this.connection = connection;
    }

    public String getUser() {
        return this.user;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isRowsUpdated() {
        return this.rowsUpdated;
    }

    public boolean isRunAsScript() {
        return this.runAsScript;
    }

    public void cancel() {
        try {
            this.stmt.cancel();
            this.isCanceled = true;
        }
        catch (SQLException e) {
            log.error("Failed to cancel", (Throwable)e);
        }
    }

    static interface ISqlRunnerListener
    extends Serializable {
        public void writeSql(String var1);

        public void reExecute(String var1);

        public void finished(VaadinIcon var1, List<Component> var2, long var3, boolean var5, boolean var6);
    }
}

