/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.sqlexplorer.DbTreeNode;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.IDbProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.ISettingsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTree
extends TreeGrid<DbTreeNode> {
    public static final String PROPERTY_SCHEMA_NAME = "schemaName";
    public static final String PROPERTY_CATALOG_NAME = "catalogName";
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String[] TABLE_TYPES = new String[]{"TABLE", "SYSTEM TABLE", "SYSTEM VIEW"};
    public static final String NODE_TYPE_DATABASE = "Database";
    public static final String NODE_TYPE_CATALOG = "Catalog";
    public static final String NODE_TYPE_SCHEMA = "Schema";
    public static final String NODE_TYPE_TABLE = "Table";
    public static final String NODE_TYPE_TRIGGER = "Trigger";
    public static final String NODE_TYPE_PLACEHOLDER = "Placeholder";
    IDbProvider databaseProvider;
    ISettingsProvider settingsProvider;
    TreeData<DbTreeNode> treeData;
    TreeDataProvider<DbTreeNode> treeDataProvider;
    Set<DbTreeNode> rootNodes;
    Set<DbTreeNode> expandedNodes;

    public DbTree(IDbProvider databaseProvider, ISettingsProvider settingsProvider) {
        this.databaseProvider = databaseProvider;
        this.settingsProvider = settingsProvider;
        this.setWidthFull();
        this.setPartNameGenerator(new DbTreePartNameGenerator());
        this.addThemeName("dbTree");
        this.expandedNodes = new LinkedHashSet<DbTreeNode>();
        this.addComponentHierarchyColumn((ValueProvider)new ValueProvider<DbTreeNode, Label>(){
            private static final long serialVersionUID = 1L;

            public Label apply(DbTreeNode node) {
                Label label = new Label(node.getName());
                if (node.getIcon() != null) {
                    label.setLeftIcon(node.getIcon());
                }
                return label;
            }
        });
        this.addExpandListener((ComponentEventListener & Serializable)event -> {
            Collection items = event.getItems();
            if (!items.isEmpty()) {
                DbTreeNode node = (DbTreeNode)items.iterator().next();
                this.expandedNodes.add(node);
                if (!node.getType().equals(NODE_TYPE_TRIGGER) && !node.hasChildren()) {
                    this.loadChildren(node);
                }
                DbTreeNode firstChild = (DbTreeNode)this.treeData.getChildren((Object)node).get(0);
                if (node.hasChildren() && firstChild.getType().equals(NODE_TYPE_PLACEHOLDER)) {
                    this.treeData.removeItem((Object)firstChild);
                    for (DbTreeNode child : node.getChildren()) {
                        this.treeData.addItem((Object)node, (Object)child);
                        String childType = child.getType();
                        if (childType.equals(NODE_TYPE_TRIGGER) || !settingsProvider.get().getProperties().get("sql.explorer.show.triggers", "").equals("true") && childType.equals(NODE_TYPE_TABLE)) continue;
                        this.treeData.addItem((Object)child, (Object)new DbTreeNode(this, NODE_TYPE_PLACEHOLDER, child));
                    }
                }
            }
        });
        this.addCollapseListener((ComponentEventListener & Serializable)event -> {
            Collection items = event.getItems();
            if (!items.isEmpty()) {
                DbTreeNode node = (DbTreeNode)event.getItems().iterator().next();
                this.expandedNodes.remove(node);
                for (DbTreeNode child : new ArrayList(this.treeData.getChildren((Object)node))) {
                    if (this.expandedNodes.contains(child)) {
                        this.collapse(new DbTreeNode[]{child});
                    }
                    this.deselect(child);
                    this.treeData.removeItem((Object)child);
                }
                this.treeData.addItem((Object)node, (Object)new DbTreeNode(this, NODE_TYPE_PLACEHOLDER, node));
            }
        });
    }

    public void refresh(boolean fullRefresh) {
        HashSet<DbTreeNode> selected = this.getSelectedItems();
        DbTreeNode firstNode = null;
        if (fullRefresh || this.rootNodes == null) {
            List<IDb> databases = this.databaseProvider.getDatabases();
            if (this.treeData == null) {
                this.treeData = new TreeData();
            } else {
                this.treeData.clear();
            }
            this.expandedNodes.clear();
            this.rootNodes = new LinkedHashSet<DbTreeNode>();
            for (IDb database : databases) {
                DbTreeNode databaseNode = new DbTreeNode(this, database.getName(), NODE_TYPE_DATABASE, VaadinIcon.DATABASE, null);
                this.treeData.addItem(null, (Object)databaseNode);
                this.treeData.addItem((Object)databaseNode, (Object)new DbTreeNode(this, NODE_TYPE_PLACEHOLDER, databaseNode));
                this.rootNodes.add(databaseNode);
                if (firstNode != null) continue;
                firstNode = databaseNode;
            }
        } else {
            this.treeData.clear();
            for (DbTreeNode databaseNode : this.rootNodes) {
                this.treeData.addItem(null, (Object)databaseNode);
                this.treeData.addItem((Object)databaseNode, (Object)new DbTreeNode(this, NODE_TYPE_PLACEHOLDER, databaseNode));
            }
        }
        this.treeDataProvider = new TreeDataProvider(this.treeData);
        this.setDataProvider((HierarchicalDataProvider)this.treeDataProvider);
        this.expand(this.expandedNodes);
        if (selected == null || selected.size() == 0) {
            selected = new HashSet<DbTreeNode>();
            selected.add(firstNode);
        }
        for (DbTreeNode node : selected) {
            if (node == null) continue;
            this.select(node);
        }
        this.focus();
    }

    public Set<DbTreeNode> getSelected(String type) {
        HashSet<DbTreeNode> nodes = new HashSet<DbTreeNode>();
        Set selected = this.getSelectedItems();
        for (DbTreeNode treeNode : selected) {
            if (!treeNode.getType().equals(type)) continue;
            nodes.add(treeNode);
        }
        return nodes;
    }

    public Set<Table> getSelectedTables() {
        HashSet<Table> tables = new HashSet<Table>();
        for (DbTreeNode treeNode : this.getSelectedItems()) {
            Table table = treeNode.getTableFor();
            if (table == null) continue;
            tables.add(table);
        }
        return tables;
    }

    protected IDb getDbForNode(DbTreeNode node) {
        while (node.getParent() != null) {
            node = node.getParent();
        }
        String databaseName = node.getName();
        List<IDb> databases = this.databaseProvider.getDatabases();
        for (IDb database : databases) {
            if (!database.getName().equals(databaseName)) continue;
            return database;
        }
        return null;
    }

    protected void loadChildren(DbTreeNode treeNode) {
        try {
            IDatabasePlatform platform = this.getDbForNode(treeNode).getPlatform();
            IDdlReader reader = platform.getDdlReader();
            if (treeNode.getType().equals(NODE_TYPE_DATABASE)) {
                List catalogs = reader.getCatalogNames();
                if (catalogs.size() > 0) {
                    this.addCatalogNodes(reader, treeNode, platform, catalogs);
                } else {
                    List schemas = reader.getSchemaNames(null);
                    this.addSchemaNodes(reader, treeNode, platform, schemas);
                }
                if (treeNode.getChildren().size() == 0) {
                    this.addTableNodes(reader, treeNode, null, null);
                }
            } else if (treeNode.getType().equals(NODE_TYPE_CATALOG)) {
                List schemas = reader.getSchemaNames(treeNode.getName());
                this.addSchemaNodes(reader, treeNode, platform, schemas);
                if (treeNode.getChildren().size() == 0) {
                    this.addTableNodes(reader, treeNode, treeNode.getName(), null);
                }
            } else if (treeNode.getType().equals(NODE_TYPE_SCHEMA)) {
                String catalogName = null;
                DbTreeNode parent = treeNode.getParent();
                if (parent != null && parent.getType().equals(NODE_TYPE_CATALOG)) {
                    catalogName = parent.getName();
                }
                this.addTableNodes(reader, treeNode, catalogName, treeNode.getName());
            } else if (treeNode.getType().equals(NODE_TYPE_TABLE)) {
                String catalogName = null;
                String schemaName = null;
                DbTreeNode parent = treeNode.getParent();
                if (parent != null && parent.getType().equals(NODE_TYPE_SCHEMA)) {
                    schemaName = parent.getName();
                    DbTreeNode grandparent = parent.getParent();
                    if (grandparent != null && grandparent.getType().equals(NODE_TYPE_CATALOG)) {
                        catalogName = grandparent.getName();
                    }
                } else if (parent != null && parent.getType().equals(NODE_TYPE_CATALOG)) {
                    catalogName = parent.getName();
                }
                this.addTriggerNodes(reader, treeNode, catalogName, schemaName);
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            CommonUiUtils.notifyError(ex.getMessage());
        }
    }

    protected List<DbTreeNode> getTableTreeNodes(IDdlReader reader, DbTreeNode parent, String catalogName, String schemaName) {
        ArrayList<DbTreeNode> list = new ArrayList<DbTreeNode>();
        List tables = reader.getTableNames(catalogName, schemaName, TABLE_TYPES);
        Collections.sort(tables, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toUpperCase().compareTo(o2.toUpperCase());
            }
        });
        for (String tableName : tables) {
            String excludeRegex;
            if (tableName.matches(excludeRegex = this.settingsProvider.get().getProperties().get("sql.explorer.exclude.tables.regex")) || tableName.toUpperCase().matches(excludeRegex) || tableName.toLowerCase().matches(excludeRegex)) continue;
            DbTreeNode treeNode = new DbTreeNode(this, tableName, NODE_TYPE_TABLE, VaadinIcon.TABLE, parent);
            if (catalogName != null) {
                treeNode.getProperties().setProperty(PROPERTY_CATALOG_NAME, catalogName);
            }
            if (schemaName != null) {
                treeNode.getProperties().setProperty(PROPERTY_SCHEMA_NAME, schemaName);
            }
            list.add(treeNode);
        }
        return list;
    }

    protected void addTableNodes(IDdlReader reader, DbTreeNode parent, String catalogName, String schemaName) {
        List<DbTreeNode> nodes = this.getTableTreeNodes(reader, parent, catalogName, schemaName);
        for (DbTreeNode treeNode : nodes) {
            parent.getChildren().add(treeNode);
        }
    }

    protected List<DbTreeNode> getTriggerTreeNodes(IDdlReader reader, DbTreeNode parent, String catalogName, String schemaName) {
        ArrayList<DbTreeNode> list = new ArrayList<DbTreeNode>();
        List triggers = new ArrayList();
        try {
            triggers = reader.getTriggers(catalogName, schemaName, parent.getName());
        }
        catch (Exception e) {
            this.log.warn("Unable to look up triggers for catalog, schema, table : " + catalogName + "." + schemaName + "." + parent.getName());
        }
        for (Trigger trigger : triggers) {
            DbTreeNode treeNode = new DbTreeNode(this, trigger.getName(), NODE_TYPE_TRIGGER, VaadinIcon.CROSSHAIRS, parent);
            if (catalogName != null) {
                treeNode.getProperties().setProperty(PROPERTY_CATALOG_NAME, catalogName);
            }
            if (schemaName != null) {
                treeNode.getProperties().setProperty(PROPERTY_SCHEMA_NAME, schemaName);
            }
            list.add(treeNode);
        }
        return list;
    }

    protected void addTriggerNodes(IDdlReader reader, DbTreeNode parent, String catalogName, String schemaName) {
        if (this.settingsProvider.get().getProperties().get("sql.explorer.show.triggers", "").equals("true")) {
            List<DbTreeNode> nodes = this.getTriggerTreeNodes(reader, parent, catalogName, schemaName);
            for (DbTreeNode treeNode : nodes) {
                parent.getChildren().add(treeNode);
            }
        }
    }

    protected void addCatalogNodes(IDdlReader reader, DbTreeNode parent, IDatabasePlatform platform, List<String> catalogs) {
        Collections.sort(catalogs);
        if (catalogs.remove(platform.getDefaultCatalog())) {
            catalogs.add(0, platform.getDefaultCatalog());
        }
        for (String catalog : catalogs) {
            DbTreeNode catalogNode = new DbTreeNode(this, catalog, NODE_TYPE_CATALOG, VaadinIcon.BOOK, parent);
            parent.getChildren().add(catalogNode);
        }
    }

    protected void addSchemaNodes(IDdlReader reader, DbTreeNode parent, IDatabasePlatform platform, List<String> schemas) {
        Collections.sort(schemas);
        if (schemas.remove(platform.getDefaultSchema())) {
            schemas.add(0, platform.getDefaultSchema());
        }
        for (String schema : schemas) {
            DbTreeNode schemaNode = new DbTreeNode(this, schema, NODE_TYPE_SCHEMA, VaadinIcon.BOOK, parent);
            parent.getChildren().add(schemaNode);
        }
    }

    class DbTreePartNameGenerator
    implements SerializableFunction<DbTreeNode, String> {
        private static final long serialVersionUID = 1L;

        DbTreePartNameGenerator() {
        }

        public String apply(DbTreeNode node) {
            try {
                String schema;
                IDatabasePlatform platform;
                String catalog;
                if (node.getType().equals(DbTree.NODE_TYPE_CATALOG) ? (catalog = (platform = DbTree.this.getDbForNode(node).getPlatform()).getDefaultCatalog()) != null && catalog.equals(node.getName()) : node.getType().equals(DbTree.NODE_TYPE_SCHEMA) && (schema = (platform = DbTree.this.getDbForNode(node).getPlatform()).getDefaultSchema()) != null && schema.equals(node.getName())) {
                    return "bold";
                }
            }
            catch (Exception e) {
                DbTree.this.log.error("Failed to see if this node is the default catalog and/or schema", (Throwable)e);
            }
            return null;
        }
    }
}

