/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.IInfoPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseInfoPanel
extends VerticalLayout
implements IInfoPanel {
    private static final long serialVersionUID = 1L;
    Logger log;
    IDb db;
    Settings settings;
    TabSheet tabSheet;
    String selectedCaption;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseInfoPanel(IDb db, Settings settings, String selectedTabCaption) {
        Connection c;
        block29: {
            this.log = LoggerFactory.getLogger(DatabaseInfoPanel.class);
            this.db = db;
            this.settings = settings;
            this.setSizeFull();
            this.tabSheet = CommonUiUtils.createTabSheet();
            this.tabSheet.addSelectedTabChangeListener((ComponentEventListener<Tabs.SelectedChangeEvent>)(ComponentEventListener & Serializable)event -> {
                this.selectedCaption = this.tabSheet.getSelectedTab().getName();
            });
            this.add(new Component[]{this.tabSheet});
            c = null;
            try {
                if (db.getPlatform().getDataSource() == null) break block29;
                c = ((DataSource)db.getPlatform().getDataSource()).getConnection();
                DatabaseMetaData metaData = c.getMetaData();
                this.tabSheet.add((Component)this.createTabData(this.createGridWithReflection(DatabaseMetaData.class, metaData), null), "Meta Data");
                this.tabSheet.add((Component)this.createTabData(this.createGridWithReflection(Connection.class, c), null), "Connection");
                try {
                    ResultSet rs = null;
                    try {
                        rs = metaData.getClientInfoProperties();
                    }
                    catch (SQLException e) {
                        this.log.debug("Could not create Client Info Properties tab", (Object)e.getMessage());
                    }
                    ColumnVisibilityToggler clientInfoPropertiesToggler = new ColumnVisibilityToggler();
                    Grid<List<Object>> clientInfoProperties = CommonUiUtils.putResultsInGrid(clientInfoPropertiesToggler, rs, Integer.MAX_VALUE, false, new String[0]);
                    clientInfoProperties.setSizeFull();
                    this.tabSheet.add((Component)this.createTabData(clientInfoProperties, clientInfoPropertiesToggler), "Client Info Properties");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create Client Info Properties tab", (Throwable)e);
                }
                try {
                    ColumnVisibilityToggler catalogsToggler = new ColumnVisibilityToggler();
                    Grid<List<Object>> catalogs = CommonUiUtils.putResultsInGrid(catalogsToggler, metaData.getCatalogs(), Integer.MAX_VALUE, false, new String[0]);
                    catalogs.setSizeFull();
                    this.tabSheet.add((Component)this.createTabData(catalogs, catalogsToggler), "Catalogs");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create Catalogs tab", (Throwable)e);
                }
                try {
                    Grid<List<Object>> schemas;
                    ColumnVisibilityToggler schemasToggler = new ColumnVisibilityToggler();
                    try {
                        schemas = CommonUiUtils.putResultsInGrid(schemasToggler, metaData.getSchemas(), Integer.MAX_VALUE, false, new String[0]);
                    }
                    catch (SQLException e) {
                        schemas = CommonUiUtils.putResultsInGrid(schemasToggler, metaData.getSchemas("", null), Integer.MAX_VALUE, false, new String[0]);
                    }
                    schemas.setSizeFull();
                    this.tabSheet.add((Component)this.createTabData(schemas, schemasToggler), "Schemas");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create Schemas tab", (Throwable)e);
                }
                try {
                    ColumnVisibilityToggler tableTypesToggler = new ColumnVisibilityToggler();
                    Grid<List<Object>> tableTypes = CommonUiUtils.putResultsInGrid(tableTypesToggler, metaData.getTableTypes(), Integer.MAX_VALUE, false, new String[0]);
                    tableTypes.setSizeFull();
                    this.tabSheet.add((Component)this.createTabData(tableTypes, tableTypesToggler), "Table Types");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create Table Types tab", (Throwable)e);
                }
                try {
                    ColumnVisibilityToggler dataTypesToggler = new ColumnVisibilityToggler();
                    Grid<List<Object>> dataTypes = CommonUiUtils.putResultsInGrid(dataTypesToggler, metaData.getTypeInfo(), Integer.MAX_VALUE, false, new String[0]);
                    dataTypes.setSizeFull();
                    this.tabSheet.add((Component)this.createTabData(dataTypes, dataTypesToggler), "Data Types");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create Data Types tab", (Throwable)e);
                }
                try {
                    this.tabSheet.add((Component)this.createTabData(this.createGridFromString(metaData.getNumericFunctions(), "Numeric Functions"), null), "Numeric Functions");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create Numeric Functions tab", (Throwable)e);
                }
                try {
                    this.tabSheet.add((Component)this.createTabData(this.createGridFromString(metaData.getStringFunctions(), "String Functions"), null), "String Functions");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create String Functions tab", (Throwable)e);
                }
                try {
                    this.tabSheet.add((Component)this.createTabData(this.createGridFromString(metaData.getSystemFunctions(), "System Functions"), null), "System Functions");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create System Functions tab", (Throwable)e);
                }
                try {
                    this.tabSheet.add((Component)this.createTabData(this.createGridFromString(metaData.getTimeDateFunctions(), "Date/Time Functions"), null), "Date/Time Functions");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create Date/Time Functions tab", (Throwable)e);
                }
                try {
                    this.tabSheet.add((Component)this.createTabData(this.createGridFromString(metaData.getSQLKeywords(), "Keywords"), null), "Keywords");
                }
                catch (AbstractMethodError e) {
                    this.log.debug("Could not create Keywords tab", (Throwable)e);
                }
            }
            catch (SQLException e) {
                try {
                    this.log.error("", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JdbcSqlTemplate.close(c);
                    throw throwable;
                }
                JdbcSqlTemplate.close((Connection)c);
            }
        }
        JdbcSqlTemplate.close(c);
        Iterator<Component> i = this.tabSheet.iterator();
        while (i.hasNext()) {
            Component component = i.next();
            TabSheet.EnhancedTab tab = this.tabSheet.getTab(component);
            if (!tab.getLabel().equals(selectedTabCaption)) continue;
            this.tabSheet.setSelectedTab(component);
            break;
        }
    }

    public VerticalLayout createTabData(Grid<?> grid, ColumnVisibilityToggler columnVisibilityToggler) {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(false);
        layout.setSizeFull();
        if (columnVisibilityToggler != null && !columnVisibilityToggler.isEmpty()) {
            layout.add(new Component[]{columnVisibilityToggler});
            layout.setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{columnVisibilityToggler});
        }
        layout.addAndExpand(new Component[]{grid});
        return layout;
    }

    private Grid<List<Object>> createGridWithReflection(Class<?> reflectionClass, Object instance) {
        Method[] methods;
        Grid grid = new Grid();
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.setSizeFull();
        grid.addItemClickListener((ComponentEventListener & Serializable)event -> {
            if (event.getColumn() != null) {
                grid.deselectAll();
                grid.select((Object)((List)event.getItem()));
            }
        });
        grid.addColumn((ValueProvider & Serializable)row -> row.get(0)).setHeader("Property").setWidth("400px").setResizable(true);
        grid.addColumn((ValueProvider & Serializable)row -> row.get(1)).setHeader("Value").setResizable(true);
        ArrayList outerList = new ArrayList();
        for (Method method : methods = reflectionClass.getMethods()) {
            if (!method.getReturnType().equals(Integer.TYPE) && !method.getReturnType().equals(String.class) && !method.getReturnType().equals(Boolean.TYPE) || method.getParameterTypes().length != 0) continue;
            try {
                ArrayList<Object> innerList = new ArrayList<Object>();
                Object value = method.invoke(instance, new Object[0]);
                innerList.add(this.cleanMethodName(method.getName()));
                innerList.add(value);
                outerList.add(innerList);
            }
            catch (Exception e) {
                this.log.debug("Could not invoke method " + method.getName(), (Throwable)e);
            }
        }
        grid.setItems(outerList);
        return grid;
    }

    private String cleanMethodName(String methodName) {
        if (((String)methodName).startsWith("get")) {
            methodName = ((String)methodName).substring(3);
        } else if (((String)methodName).startsWith("is")) {
            methodName = ((String)methodName).substring(2);
        }
        if (!((String)methodName).isEmpty()) {
            methodName = ((String)methodName).substring(0, 1).toUpperCase() + ((String)methodName).substring(1);
            for (int i = 0; i < ((String)methodName).length() - 1; ++i) {
                if (!Character.isUpperCase(((String)methodName).charAt(i)) || !Character.isLowerCase(((String)methodName).charAt(i + 1)) && (i <= 0 || !Character.isLowerCase(((String)methodName).charAt(i - 1)))) continue;
                methodName = ((String)methodName).substring(0, i) + " " + ((String)methodName).substring(i);
                ++i;
            }
        }
        return methodName;
    }

    private Grid<String> createGridFromString(String data, String columnName) {
        Grid grid = new Grid();
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.setSizeFull();
        grid.addItemClickListener((ComponentEventListener & Serializable)event -> {
            if (event.getColumn() != null) {
                grid.deselectAll();
                grid.select((Object)((String)event.getItem()));
            }
        });
        grid.addColumn((ValueProvider & Serializable)row -> row).setHeader(columnName);
        ArrayList<String> values = new ArrayList<String>();
        int lastComma = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != ',') continue;
            values.add(data.substring(lastComma, i).trim());
            lastComma = i + 1;
        }
        grid.setItems(values);
        return grid;
    }

    @Override
    public String getSelectedTabCaption() {
        return this.selectedCaption;
    }

    @Override
    public void selected() {
    }

    @Override
    public void unselected() {
    }
}

