/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.editor.Editor;
import com.vaadin.flow.component.grid.editor.EditorCloseListener;
import com.vaadin.flow.component.grid.editor.EditorOpenListener;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.tabs.TabsVariant;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.Command;
import de.f0rce.ace.AceEditor;
import de.f0rce.ace.enums.AceTheme;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.common.ThemeChangedEvent;

public final class CommonUiUtils {
    static final FastDateFormat DATETIMEFORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    static final FastDateFormat TIMEFORMAT = FastDateFormat.getInstance((String)"HH:mm:ss.SSS");
    public static final String NULL_TEXT = "<null>";

    private CommonUiUtils() {
    }

    public static void styleTabSheet(TabSheet tabSheet) {
        tabSheet.setSizeFull();
        tabSheet.addThemeVariants(TabsVariant.LUMO_SMALL);
    }

    public static TabSheet createTabSheet() {
        TabSheet tabSheet = new TabSheet();
        CommonUiUtils.styleTabSheet(tabSheet);
        return tabSheet;
    }

    public static Button createPrimaryButton(String name) {
        return CommonUiUtils.createPrimaryButton(name, null);
    }

    public static Button createPrimaryButton(String name, ComponentEventListener<ClickEvent<Button>> listener) {
        Button button = new Button(name);
        if (listener != null) {
            button.addClickListener(listener);
        }
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        return button;
    }

    public static AceEditor createAceEditor() {
        AceEditor editor = new AceEditor();
        editor.setSizeFull();
        editor.setHighlightActiveLine(false);
        editor.setHighlightSelectedWord(false);
        editor.setShowPrintMargin(false);
        editor.setBaseUrl("../ace-builds/src-min-noconflict/");
        UI ui = UI.getCurrent();
        if (ui.getElement().getThemeList().contains((Object)"dark")) {
            editor.setTheme(AceTheme.nord_dark);
        } else {
            editor.setTheme(AceTheme.eclipse);
        }
        ComponentUtil.addListener((Component)ui, ThemeChangedEvent.class, (ComponentEventListener & Serializable)event -> {
            if (event.getTheme().equals("dark")) {
                editor.setTheme(AceTheme.nord_dark);
            } else {
                editor.setTheme(AceTheme.eclipse);
            }
        });
        return editor;
    }

    public static Notification notify(String message) {
        return CommonUiUtils.notify("", message);
    }

    public static Notification notify(String message, Consumer<Boolean> shortcutToggler) {
        return CommonUiUtils.notify("", message, shortcutToggler);
    }

    public static Notification notify(String caption, String message) {
        return CommonUiUtils.notify(caption, message, null);
    }

    public static Notification notify(String caption, String message, Consumer<Boolean> shortcutToggler) {
        Page page = UI.getCurrent().getPage();
        if (page != null) {
            HorizontalLayout layout = new HorizontalLayout();
            Notification notification = new Notification(new Component[]{layout});
            if (message != null && message.length() <= 250) {
                layout.getStyle().set("max-width", "400px");
                Label label = !StringUtils.isBlank((CharSequence)caption) ? new Label(caption + "<hr>" + CommonUiUtils.contactWithLineFeed(FormatUtils.wordWrap((String)message, (int)150))) : new Label(CommonUiUtils.contactWithLineFeed(FormatUtils.wordWrap((String)message, (int)150)));
                layout.add(new Component[]{label});
            } else {
                layout.setWidth("700px");
                VerticalLayout vLayout = new VerticalLayout();
                vLayout.setWidthFull();
                if (!StringUtils.isBlank((CharSequence)caption)) {
                    Label label = new Label(caption + "<hr>");
                    label.setWidthFull();
                    vLayout.add(new Component[]{label});
                }
                if (message != null) {
                    TextArea textArea = new TextArea();
                    textArea.setWidthFull();
                    textArea.setHeight("400px");
                    textArea.setValue(message);
                    textArea.setReadOnly(true);
                    vLayout.add(new Component[]{textArea});
                    layout.add(new Component[]{vLayout});
                }
            }
            Icon closeIcon = new Icon(VaadinIcon.CLOSE_SMALL);
            closeIcon.setSize("16px");
            closeIcon.getStyle().set("position", "absolute").set("top", "50%").set("left", "50%").set("transform", "translate(-50%, -50%)");
            Div closeDiv = new Div(new Component[]{closeIcon});
            closeDiv.setHeight("24px");
            closeDiv.setWidth("24px");
            closeDiv.getStyle().set("min-height", "24px").set("min-width", "24px").set("position", "relative").set("-webkit-border-radius", "50%").set("-moz-border-radius", "50%").set("border-radius", "50%").set("background-color", "var(--lumo-contrast-10pct)").set("cursor", "pointer");
            closeDiv.addClickListener((ComponentEventListener & Serializable)event -> notification.close());
            layout.add(new Component[]{closeDiv});
            layout.setVerticalComponentAlignment(FlexComponent.Alignment.START, new Component[]{closeDiv});
            if (shortcutToggler != null) {
                notification.addOpenedChangeListener((ComponentEventListener & Serializable)event -> shortcutToggler.accept(event.isOpened()));
            }
            notification.setPosition(Notification.Position.MIDDLE);
            notification.setDuration(-1);
            Shortcuts.addShortcutListener((Component)notification, (Command & Serializable)() -> notification.close(), (Key)Key.ESCAPE, (KeyModifier[])new KeyModifier[0]);
            notification.open();
            return notification;
        }
        return null;
    }

    private static String contactWithLineFeed(String[] lines) {
        StringBuilder line = new StringBuilder();
        for (String l : lines) {
            line.append(l).append("\n");
        }
        return line.toString();
    }

    public static Notification notifyError() {
        return CommonUiUtils.notifyError((Consumer<Boolean>)null);
    }

    public static Notification notifyError(Consumer<Boolean> shortcutToggler) {
        return CommonUiUtils.notify("An unexpected error occurred", "See the log file for additional details", shortcutToggler);
    }

    public static Notification notifyError(String message) {
        return CommonUiUtils.notifyError(message, null);
    }

    public static Notification notifyError(String message, Consumer<Boolean> shortcutToggler) {
        return CommonUiUtils.notify("An error occurred", message, shortcutToggler);
    }

    public static Object getObject(ResultSet rs, int i) throws SQLException {
        Object obj = JdbcSqlTemplate.getResultSetValue((ResultSet)rs, (ResultSetMetaData)rs.getMetaData(), (int)i, (boolean)false, (boolean)false);
        if (obj instanceof byte[]) {
            obj = new String(Hex.encodeHex((byte[])((byte[])obj)));
        }
        if (obj instanceof String) {
            obj = StringUtils.abbreviate((String)((String)obj), (int)4096);
        }
        return obj;
    }

    public static String[] getHeaderCaptions(Grid<?> grid) {
        ArrayList<String> headers = new ArrayList<String>();
        for (Grid.Column column : grid.getColumns()) {
            headers.add(column.getKey());
        }
        return headers.toArray(new String[headers.size()]);
    }

    public static Grid<List<Object>> putResultsInGrid(ColumnVisibilityToggler columnVisibilityToggler, ResultSet rs, int maxResultSize, boolean showRowNumbers, String ... excludeValues) throws SQLException {
        Grid grid = new Grid();
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.setColumnReorderingAllowed(true);
        grid.addItemClickListener((ComponentEventListener & Serializable)event -> {
            if (event.getColumn() != null) {
                grid.deselectAll();
                grid.select((Object)((List)event.getItem()));
            }
        });
        ArrayList outerList = new ArrayList();
        if (rs != null) {
            ((Grid.Column)((Grid.Column)grid.addColumn((ValueProvider & Serializable)row -> outerList.indexOf(row) + 1).setHeader("#").setKey("#").setFrozen(true)).setResizable(true)).setVisible(showRowNumbers);
            grid.addAttachListener((ComponentEventListener & Serializable)e -> grid.getElement().executeJs("this.querySelector('vaadin-grid-flow-selection-column').frozen = true", new Serializable[0]));
            ResultSetMetaData meta = rs.getMetaData();
            int totalColumns = meta.getColumnCount();
            HashSet<Integer> skipColumnIndexes = new HashSet<Integer>();
            HashSet<String> columnNames = new HashSet<String>();
            int[] types = new int[totalColumns];
            int[] columnCounter = new int[]{1};
            while (columnCounter[0] <= totalColumns) {
                String realColumnName = meta.getColumnName(columnCounter[0]);
                Object columnName = realColumnName;
                if (!Arrays.asList(excludeValues).contains(columnName)) {
                    int index = 1;
                    while (columnNames.contains(columnName)) {
                        columnName = realColumnName + "_" + index++;
                    }
                    columnNames.add((String)columnName);
                    int colNum = columnCounter[0] - 1 - skipColumnIndexes.size();
                    columnVisibilityToggler.addColumn((Grid.Column)grid.addColumn((ValueProvider & Serializable)row -> row.get(colNum)).setKey((String)columnName).setHeader((String)columnName).setPartNameGenerator((SerializableFunction & Serializable)row -> {
                        if (row.get(colNum) == null) {
                            return "italics";
                        }
                        return null;
                    }).setResizable(true), (String)columnName);
                    types[columnCounter[0] - 1] = meta.getColumnType(columnCounter[0]);
                } else {
                    skipColumnIndexes.add(columnCounter[0] - 1);
                }
                columnCounter[0] = columnCounter[0] + 1;
            }
            for (int rowNumber = 1; rs.next() && rowNumber <= maxResultSize; ++rowNumber) {
                ArrayList<Object> innerList = new ArrayList<Object>();
                for (int i = 0; i < totalColumns; ++i) {
                    if (skipColumnIndexes.contains(i)) continue;
                    Object o = CommonUiUtils.getObject(rs, i + 1);
                    int type = types[i];
                    switch (type) {
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: {
                            if (o == null || o instanceof BigDecimal) break;
                            o = new BigDecimal(CommonUiUtils.castToNumber(o.toString()));
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            if (o == null || o instanceof Long) break;
                            o = Long.parseLong(CommonUiUtils.castToNumber(o.toString()));
                            break;
                        }
                    }
                    innerList.add(o == null ? NULL_TEXT : o);
                }
                outerList.add(innerList);
                if (rowNumber < 100) {
                    grid.getColumnByKey("#").setWidth("75px");
                    continue;
                }
                if (rowNumber < 1000) {
                    grid.getColumnByKey("#").setWidth("95px");
                    continue;
                }
                grid.getColumnByKey("#").setWidth("115px");
            }
        } else {
            grid.addColumn((ValueProvider & Serializable)row -> row.get(0)).setHeader("Status").setKey("Status").setResizable(true);
            ArrayList<String> innerList = new ArrayList<String>();
            innerList.add("Metadata unavailable");
            outerList.add(innerList);
        }
        grid.setItems(outerList);
        return grid;
    }

    public static String castToNumber(String value) {
        if ("NO".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value)) {
            return "0";
        }
        if ("YES".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value)) {
            return "1";
        }
        return value.replace(",", ".");
    }

    public static String formatDuration(long timeInMs) {
        if (timeInMs > 60000L) {
            long minutes = timeInMs / 60000L;
            long seconds = (timeInMs - minutes * 60000L) / 1000L;
            return minutes + " m " + seconds + " s";
        }
        if (timeInMs > 1000L) {
            long seconds = timeInMs / 1000L;
            return seconds + " s";
        }
        return timeInMs + " ms";
    }

    public static String formatDateTime(Date dateTime) {
        if (dateTime != null) {
            Calendar cal = Calendar.getInstance();
            Calendar ref = Calendar.getInstance();
            ref.setTime(dateTime);
            if (ref.get(6) == cal.get(6) && ref.get(1) == cal.get(1)) {
                return TIMEFORMAT.format(dateTime);
            }
            return DATETIMEFORMAT.format(dateTime);
        }
        return null;
    }

    public static String getJdbcTypeValue(String type) {
        String value = null;
        if (type.equalsIgnoreCase("CHAR")) {
            value = "";
        } else if (type.equalsIgnoreCase("VARCHAR")) {
            value = "";
        } else if (type.equalsIgnoreCase("LONGVARCHAR")) {
            value = "";
        } else if (type.equalsIgnoreCase("NUMERIC")) {
            value = "0";
        } else if (type.equalsIgnoreCase("DECIMAL")) {
            value = "0.00";
        } else if (type.equalsIgnoreCase("BIT")) {
            value = "0";
        } else if (type.equalsIgnoreCase("BOOLEAN")) {
            value = "0";
        } else if (type.equalsIgnoreCase("TINYINT")) {
            value = "0";
        } else if (type.equalsIgnoreCase("SMALLINT")) {
            value = "0";
        } else if (type.equalsIgnoreCase("INTEGER")) {
            value = "0";
        } else if (type.equalsIgnoreCase("BIGINT")) {
            value = "0";
        } else if (type.equalsIgnoreCase("REAL")) {
            value = "0";
        } else if (type.equalsIgnoreCase("DOUBLE")) {
            value = "0.0";
        } else if (type.equalsIgnoreCase("BINARY")) {
            value = null;
        } else if (type.equalsIgnoreCase("VARBINARY")) {
            value = null;
        } else if (type.equalsIgnoreCase("LONGBINARY")) {
            value = null;
        } else if (type.equalsIgnoreCase("DATE")) {
            value = "'2014-07-08'";
        } else if (type.equalsIgnoreCase("TIME")) {
            value = "'12:00:00'";
        } else if (type.equalsIgnoreCase("TIMESTAMP")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            value = dateFormat.format(date);
        } else {
            value = type.equalsIgnoreCase("CLOB") ? "''" : (type.equalsIgnoreCase("BLOB") ? "''" : (type.equalsIgnoreCase("ARRAY") ? "[]" : (type.equalsIgnoreCase("DISTINCT") ? null : (type.equalsIgnoreCase("STRUCT") ? null : (type.equalsIgnoreCase("REF") ? null : (type.equalsIgnoreCase("DATALINK") ? null : (type.equalsIgnoreCase("JAVA_OBJECT") ? null : null)))))));
        }
        return value;
    }

    public static Span createSeparator() {
        Span separator = new Span(" ");
        separator.setClassName("vrule");
        separator.setHeightFull();
        separator.setWidth(null);
        return separator;
    }

    public static void configureEditor(Grid<?> grid) {
        Editor editor = grid.getEditor();
        Set editButtons = Collections.newSetFromMap(new WeakHashMap());
        editor.setBuffered(true);
        Grid.Column editorColumn = grid.addComponentColumn((ValueProvider & Serializable)item -> {
            Button edit = new Button("Edit");
            edit.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
            edit.addClassName("edit");
            edit.addClickListener((ComponentEventListener & Serializable)event -> editor.editItem(item));
            edit.setEnabled(!editor.isOpen());
            editButtons.add(edit);
            return edit;
        }).setWidth("175px").setFlexGrow(0);
        editor.addOpenListener((EditorOpenListener & Serializable)event -> editButtons.stream().forEach(button -> button.setEnabled(!editor.isOpen())));
        editor.addCloseListener((EditorCloseListener & Serializable)event -> editButtons.stream().forEach(button -> button.setEnabled(!editor.isOpen())));
        Button save = new Button("Save", (ComponentEventListener & Serializable)event -> editor.save());
        Button cancel = new Button("Cancel", (ComponentEventListener & Serializable)event -> editor.cancel());
        cancel.getStyle().set("margin-left", "8px");
        grid.getElement().addEventListener("keyup", (DomEventListener & Serializable)event -> editor.cancel()).setFilter("event.key === 'Escape' || event.key === 'Esc'");
        Div buttons = new Div(new Component[]{save, cancel});
        editorColumn.setEditorComponent((Component)buttons);
    }

    public static Icon createMenuBarIcon(VaadinIcon icon) {
        Icon menuBarIcon = new Icon(icon);
        menuBarIcon.getStyle().set("padding", "var(--lumo-space-xs)");
        menuBarIcon.getStyle().set("box-sizing", "border-box");
        return menuBarIcon;
    }

    public static boolean isFilteredOut(String text, String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return false;
        }
        return filter.length() > 2 ? !Strings.CI.contains((CharSequence)text, (CharSequence)filter) : !Strings.CI.startsWith((CharSequence)text, (CharSequence)filter);
    }
}

