/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.postgresql;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddTableLoggingChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.ColumnRequiredChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemoveFunctionChange;
import org.jumpmind.db.alter.RemoveTableLoggingChange;
import org.jumpmind.db.alter.RemoveTriggerChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class PostgreSqlDdlBuilder
extends AbstractDdlBuilder {
    public PostgreSqlDdlBuilder() {
        super("postgres");
        this.databaseInfo.setMaxIdentifierLength(63);
        this.databaseInfo.setRequiresSavePointsInTransaction(true);
        this.databaseInfo.setRequiresAutoCommitForDdl(false);
        this.databaseInfo.addNativeTypeMapping(2003, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(-2, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(-7, "BOOLEAN");
        this.databaseInfo.addNativeTypeMapping(2004, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(2005, "TEXT", -1);
        this.databaseInfo.addNativeTypeMapping(2011, "TEXT", -1);
        this.databaseInfo.addNativeTypeMapping(3, "NUMERIC", 2);
        this.databaseInfo.addNativeTypeMapping(2001, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(8, "DOUBLE PRECISION");
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE PRECISION", 8);
        this.databaseInfo.addNativeTypeMapping(2000, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(-4, "BYTEA");
        this.databaseInfo.addNativeTypeMapping(-1, "TEXT", -1);
        this.databaseInfo.addNativeTypeMapping(0, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(1111, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(2006, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(2002, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(-3, "BYTEA", -4);
        this.databaseInfo.addNativeTypeMapping("BOOLEAN", "BOOLEAN", "BIT");
        this.databaseInfo.addNativeTypeMapping("DATALINK", "BYTEA", "LONGVARBINARY");
        this.databaseInfo.addNativeTypeMapping(-9, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-16, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-15, "CHAR", 1);
        this.databaseInfo.addNativeTypeMapping(-101, "TIMESTAMPTZ");
        this.databaseInfo.addNativeTypeMapping(-102, "TIMESTAMPTZ", -101);
        this.databaseInfo.addNativeTypeMapping(-103, "TIMETZ");
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setHasSize(92, true);
        this.databaseInfo.setHasSize(-103, true);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setDefaultSize(93, 6);
        this.databaseInfo.setDefaultSize(-101, 6);
        this.databaseInfo.setDefaultSize(-102, 6);
        this.databaseInfo.setDefaultSize(92, 6);
        this.databaseInfo.setDefaultSize(-103, 6);
        this.databaseInfo.setMaxSize("TIMESTAMP", 6);
        this.databaseInfo.setMaxSize("TIMESTAMPTZ", 6);
        this.databaseInfo.setMaxSize("TIME", 6);
        this.databaseInfo.setMaxSize("TIMETZ", 6);
        this.databaseInfo.setHasSize(-2, false);
        this.databaseInfo.setHasSize(-3, false);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setBinaryQuoteStart("0x");
        this.databaseInfo.setBinaryQuoteEnd("");
        this.addEscapedCharSequence("\\", "\\\\");
        this.addEscapedCharSequence("\b", "\\b");
        this.addEscapedCharSequence("\f", "\\f");
        this.addEscapedCharSequence("\n", "\\n");
        this.addEscapedCharSequence("\r", "\\r");
        this.addEscapedCharSequence("\t", "\\t");
    }

    @Override
    public String mapDefaultValue(Object defaultValue, Column column) {
        Object newValue = super.mapDefaultValue(defaultValue, column);
        if (this.databaseInfo.getDefaultValuesToTranslate().containsKey(defaultValue.toString())) {
            return newValue;
        }
        int typeCode = column.getMappedTypeCode();
        if (!(typeCode != 93 && typeCode != -101 && typeCode != -102 || column.allPlatformColumnNamesContain("postgres"))) {
            String uppercaseValue = ((String)newValue).trim().toUpperCase();
            if (uppercaseValue.startsWith("CURRENT_DATE") || uppercaseValue.startsWith("CURRENT DATE") || column.anyPlatformColumnNameContains("oracle") && uppercaseValue.startsWith("SYSDATE") || column.anyPlatformColumnNameContains("mysql") && !uppercaseValue.matches(".*\\d.*") && (uppercaseValue.startsWith("NOW") || uppercaseValue.startsWith("CURRENT_TIMESTAMP") || uppercaseValue.startsWith("LOCALTIME") || uppercaseValue.startsWith("SYSDATE"))) {
                newValue = "CURRENT_TIMESTAMP(0)";
            } else if (column.anyPlatformColumnNameContains("mssql") && (uppercaseValue.startsWith("GETDATE(") || uppercaseValue.startsWith("CURRENT_TIMESTAMP"))) {
                newValue = "CURRENT_TIMESTAMP(3)";
            } else if (uppercaseValue.startsWith("SYSTIMESTAMP") || uppercaseValue.startsWith("SYSDATETIME(")) {
                newValue = "CURRENT_TIMESTAMP";
            } else if (column.anyPlatformColumnNameContains("mysql") && uppercaseValue.startsWith("SYSDATE(")) {
                newValue = Strings.CI.replaceOnce((String)newValue, "sysdate", "CURRENT_TIMESTAMP");
            } else if (uppercaseValue.startsWith("SYSDATETIMEOFFSET(")) {
                newValue = "LOCALTIMESTAMP";
            } else if (uppercaseValue.startsWith("GETUTCDATE(")) {
                newValue = "TIMEZONE('utc', CURRENT_TIMESTAMP(3))";
            } else if (uppercaseValue.startsWith("SYSUTCDATETIME(")) {
                newValue = "TIMEZONE('utc', CURRENT_TIMESTAMP)";
            } else if (uppercaseValue.startsWith("UTC_TIMESTAMP")) {
                if (uppercaseValue.matches(".*\\d.*")) {
                    Matcher matcher = Pattern.compile("\\d").matcher(uppercaseValue);
                    matcher.find();
                    int precision = Integer.valueOf(matcher.group());
                    if (precision > 6) {
                        precision = 6;
                    }
                    newValue = "TIMEZONE('utc', CURRENT_TIMESTAMP(" + precision + "))";
                } else {
                    newValue = "TIMEZONE('utc', CURRENT_TIMESTAMP(0))";
                }
            }
        } else if (newValue != null && ((String)newValue).equals("newid()")) {
            newValue = "gen_random_uuid()";
        }
        return newValue;
    }

    public static boolean isUsePseudoSequence() {
        return "true".equalsIgnoreCase(System.getProperty("org.jumpmind.symmetric.ddl.use.table.seq", "false"));
    }

    public static boolean isMapCharToJson() {
        return "true".equalsIgnoreCase(System.getProperty("org.jumpmind.symmetric.ddl.use.postgres.map.json", "true"));
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        ddl.append("DROP TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        ddl.append(" CASCADE");
        this.printEndOfStatement(ddl);
        if (!temporary && !recreate) {
            Column[] columns = table.getAutoIncrementColumns();
            for (int idx = 0; idx < columns.length; ++idx) {
                this.dropAutoIncrementSequence(table, columns[idx], ddl);
            }
        }
    }

    @Override
    protected boolean writeAlterColumnDataTypeToBigInt(ColumnDataTypeChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" ALTER COLUMN ");
        Column column = change.getChangedColumn();
        column.setTypeCode(change.getNewTypeCode());
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" TYPE ");
        ddl.append(this.getSqlType(column));
        this.printEndOfStatement(ddl);
        return true;
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX ");
        if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
            ddl.append(this.getDelimitedIdentifier(table.getSchema())).append(".");
        }
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        if (!temporary && !recreate) {
            for (int idx = 0; idx < table.getColumnCount(); ++idx) {
                Column column = table.getColumn(idx);
                if (!column.isAutoIncrement()) continue;
                this.createAutoIncrementSequence(table, column, ddl);
            }
        }
        super.createTable(table, ddl, temporary, recreate);
    }

    @Override
    protected void writeTableCreateOpeningStmt(Table table, StringBuilder ddl) {
        ddl.append("CREATE");
        if (!table.getLogging() && this.databaseInfo.isTableLevelLoggingSupported()) {
            ddl.append(" UNLOGGED");
        }
        ddl.append(" TABLE ");
    }

    private void createAutoIncrementSequence(Table table, Column column, StringBuilder ddl) {
        if (PostgreSqlDdlBuilder.isUsePseudoSequence()) {
            ddl.append("CREATE TABLE ");
            ddl.append(this.getConstraintName(null, table, column.getName(), "tbl"));
            ddl.append("(SEQ_ID int8)");
            this.printEndOfStatement(ddl);
            ddl.append("CREATE FUNCTION ");
            ddl.append(this.getConstraintName(null, table, column.getName(), "seq"));
            ddl.append("() ");
            ddl.append("RETURNS INT8 AS $$ ");
            ddl.append("DECLARE curVal int8; ");
            ddl.append("BEGIN ");
            ddl.append("  select seq_id into curVal from ");
            ddl.append(this.getConstraintName(null, table, column.getName(), "tbl"));
            ddl.append(" for update;");
            ddl.append("  if curVal is null then ");
            ddl.append("      insert into ");
            ddl.append(this.getConstraintName(null, table, column.getName(), "tbl"));
            ddl.append(" values(1); ");
            ddl.append("      curVal = 0; ");
            ddl.append("  else ");
            ddl.append("      update ");
            ddl.append(this.getConstraintName(null, table, column.getName(), "tbl"));
            ddl.append(" set seq_id=curVal+1; ");
            ddl.append("  end if; ");
            ddl.append("  return curVal+1; ");
            ddl.append("END; ");
            this.println("$$ LANGUAGE plpgsql; ", ddl);
        } else {
            ddl.append("CREATE SEQUENCE ");
            if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
                this.printIdentifier(table.getSchema(), ddl);
                ddl.append(".");
            }
            this.printIdentifier(this.getConstraintName(null, table, column.getName(), "seq"), ddl);
            this.printEndOfStatement(ddl);
        }
    }

    private void dropAutoIncrementSequence(Table table, Column column, StringBuilder ddl) {
        if (PostgreSqlDdlBuilder.isUsePseudoSequence()) {
            ddl.append("DROP TABLE ");
            ddl.append(this.getConstraintName(null, table, column.getName(), "tbl"));
            this.printEndOfStatement(ddl);
            ddl.append("DROP FUNCTION ");
            ddl.append(this.getConstraintName(null, table, column.getName(), "seq"));
            ddl.append("()");
            this.printEndOfStatement(ddl);
        } else {
            ddl.append("DROP SEQUENCE ");
            if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
                this.printIdentifier(table.getSchema(), ddl);
                ddl.append(".");
            }
            this.printIdentifier(this.getConstraintName(null, table, column.getName(), "seq"), ddl);
            this.printEndOfStatement(ddl);
        }
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        if (PostgreSqlDdlBuilder.isUsePseudoSequence()) {
            ddl.append(" DEFAULT ");
            ddl.append(this.getConstraintName(null, table, column.getName(), "seq"));
            ddl.append("()");
        } else {
            ddl.append(" DEFAULT nextval('");
            if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
                this.printIdentifier(table.getSchema(), ddl);
                ddl.append(".");
            }
            this.printIdentifier(this.getConstraintName(null, table, column.getName(), "seq"), ddl);
            ddl.append("')");
        }
    }

    @Override
    protected void writeGeneratedColumn(Table table, Column column, StringBuilder ddl) {
        this.writeColumnTypeDefaultRequired(table, column, ddl);
        String definition = this.getDefinitionForGeneratedColumn(table, column);
        if (!StringUtils.isBlank((CharSequence)definition)) {
            if (!definition.startsWith("(") || !definition.endsWith(")")) {
                ddl.append(" GENERATED ALWAYS AS ").append("(").append(definition).append(") STORED");
            } else {
                ddl.append(" GENERATED ALWAYS AS ").append(definition).append(" STORED");
            }
        }
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        for (int idx = 0; idx < columns.length; ++idx) {
            if (idx > 0) {
                result.append(", ");
            }
            result.append("currval('");
            result.append(this.getDelimitedIdentifier(this.getConstraintName(null, table, columns[idx].getName(), "seq")));
            result.append("') AS ");
            result.append(this.getDelimitedIdentifier(columns[idx].getName()));
        }
        return result.toString();
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn, StringBuilder ddl) {
        if (sourceColumn != null && targetColumn != null) {
            if (sourceColumn.getMappedTypeCode() == 92 && targetColumn.getMappedTypeCode() == 93) {
                ddl.append("date_trunc('DAY', localtimestamp) + ");
                this.printIdentifier(this.getColumnName(sourceColumn), ddl);
            } else {
                super.writeCastExpression(sourceColumn, targetColumn, ddl);
            }
        }
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChange change = changeIt.next();
            if (change instanceof AddTableLoggingChange) {
                this.processChange(currentModel, desiredModel, (AddTableLoggingChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof RemoveTableLoggingChange) {
                this.processChange(currentModel, desiredModel, (RemoveTableLoggingChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof AddColumnChange) {
                AddColumnChange addColumnChange = (AddColumnChange)change;
                this.processChange(currentModel, desiredModel, addColumnChange, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof RemoveColumnChange) {
                this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof CopyColumnValueChange) {
                CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
                this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnDefaultValueChange) {
                this.processChange(currentModel, desiredModel, (ColumnDefaultValueChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnRequiredChange) {
                this.processChange(currentModel, desiredModel, (ColumnRequiredChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnSizeChange) {
                this.processChange(currentModel, desiredModel, (ColumnSizeChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof PrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (PrimaryKeyChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof ColumnAutoIncrementChange) || !this.processChange(currentModel, desiredModel, (ColumnAutoIncrementChange)change, ddl)) continue;
            changeIt.remove();
        }
        super.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, changes, ddl);
    }

    protected void processChange(Database currentModel, Database desiredModel, PrimaryKeyChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        this.printIndent(ddl);
        ddl.append(" DROP CONSTRAINT ");
        this.printIdentifier(change.getChangedTable().getPrimaryKeyConstraintName(), ddl);
        this.printEndOfStatement(ddl);
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        this.printIndent(ddl);
        ddl.append(" ADD ");
        this.writePrimaryKeyStmt(change.getChangedTable(), change.getNewPrimaryKeyColumns(), ddl);
        this.printEndOfStatement(ddl);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        this.printIndent(ddl);
        ddl.append(" ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        if (change.getColumn().isAutoIncrement()) {
            this.dropAutoIncrementSequence(change.getChangedTable(), change.getColumn(), ddl);
        }
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    protected void processChange(Database currentModel, Database desiredModel, AddTableLoggingChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        this.printIndent(ddl);
        ddl.append(" SET LOGGED");
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    protected void processChange(Database currentModel, Database desiredModel, RemoveTableLoggingChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        this.printIndent(ddl);
        ddl.append(" SET UNLOGGED");
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnDefaultValueChange change, StringBuilder ddl) {
        if (change.getNewDefaultValue() == null && change.getChangedColumn().getDefaultValue() != null) {
            this.writeTableAlterStmt(change.getChangedTable(), ddl);
            ddl.append(" ALTER COLUMN ");
            Column column = change.getChangedColumn();
            this.printIdentifier(this.getColumnName(column), ddl);
            ddl.append(" DROP DEFAULT ");
            this.printEndOfStatement(ddl);
        } else {
            this.writeTableAlterStmt(change.getChangedTable(), ddl);
            ddl.append(" ALTER COLUMN ");
            Column column = change.getChangedColumn();
            this.printIdentifier(this.getColumnName(column), ddl);
            ddl.append(" SET DEFAULT ");
            this.printDefaultValue(change.getNewDefaultValue(), column, ddl);
            this.printEndOfStatement(ddl);
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnRequiredChange change, StringBuilder ddl) {
        boolean required = !change.getChangedColumn().isRequired();
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" ALTER COLUMN ");
        Column column = change.getChangedColumn();
        this.printIdentifier(this.getColumnName(column), ddl);
        if (required) {
            ddl.append(" SET NOT NULL ");
        } else {
            ddl.append(" DROP NOT NULL ");
        }
        this.printEndOfStatement(ddl);
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnSizeChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" ALTER COLUMN ");
        Column column = change.getChangedColumn();
        column.setSizeAndScale(change.getNewSize(), change.getNewScale());
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" TYPE ");
        ddl.append(this.getSqlType(column));
        this.printEndOfStatement(ddl);
    }

    protected boolean processChange(Database currentModel, Database desiredModel, ColumnAutoIncrementChange change, StringBuilder ddl) {
        boolean autoIncrement;
        boolean bl = autoIncrement = !change.getColumn().isAutoIncrement();
        if (!autoIncrement) {
            this.writeTableAlterStmt(change.getChangedTable(), ddl);
            ddl.append(" ALTER COLUMN ");
            Column column = change.getColumn();
            this.printIdentifier(this.getColumnName(column), ddl);
            ddl.append(" DROP DEFAULT ");
            this.printEndOfStatement(ddl);
            return true;
        }
        return false;
    }

    @Override
    protected void processChange(Database currentModel, Database desiredModel, RemoveTriggerChange change, StringBuilder ddl) {
        ddl.append("DROP TRIGGER ").append(change.getTrigger().getName());
        ddl.append(" ON ").append(change.getChangedTable().getFullyQualifiedTableName());
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    protected void processChange(Database currentModel, Database desiredModel, RemoveFunctionChange change, StringBuilder ddl) {
        ddl.append("DROP FUNCTION IF EXISTS ");
        if (change.getFunction().getSchemaName() != null && change.getFunction().getSchemaName().length() > 0) {
            ddl.append(change.getFunction().getSchemaName()).append(".");
        }
        ddl.append(change.getFunction().getFunctionName());
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    protected void printDefaultValue(String defaultValue, Column column, StringBuilder ddl) {
        int typeCode = column.getMappedTypeCode();
        if (defaultValue != null && (defaultValue.endsWith("::uuid") && 1111 == typeCode || defaultValue.contains("::") && 2003 == typeCode)) {
            ddl.append(defaultValue);
        } else if (16 == typeCode || -7 == typeCode) {
            boolean isNull = false;
            if (defaultValue == null || defaultValue.equalsIgnoreCase("null")) {
                isNull = true;
            }
            if (!isNull) {
                ddl.append(this.databaseInfo.getValueQuoteToken());
                ddl.append(this.escapeStringValue(defaultValue));
                ddl.append(this.databaseInfo.getValueQuoteToken());
            } else {
                ddl.append(defaultValue);
            }
        } else {
            super.printDefaultValue(defaultValue, column, ddl);
        }
    }

    @Override
    protected boolean shouldUseQuotes(String defaultValue, Column column) {
        String defaultValueStr;
        for (defaultValueStr = this.mapDefaultValue(defaultValue, column); defaultValueStr != null && defaultValueStr.startsWith("(") && defaultValueStr.endsWith(")"); defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1)) {
        }
        return super.shouldUseQuotes(defaultValue, column) && !defaultValueStr.trim().toUpperCase().startsWith("TIMEZONE(");
    }

    @Override
    public String getSqlType(Column column) {
        int size;
        String type = super.getSqlType(column);
        if (type.startsWith("CHAR") && column.getPlatformColumns() != null && PostgreSqlDdlBuilder.isMapCharToJson()) {
            for (Map.Entry<String, PlatformColumn> platformColumn : column.getPlatformColumns().entrySet()) {
                if (platformColumn.getValue() == null || platformColumn.getValue().getType() == null || !platformColumn.getValue().getType().equals("JSON")) continue;
                type = "JSONB";
                return type;
            }
        }
        if ((column.getMappedTypeCode() == 1 || column.getMappedTypeCode() == 12) && (size = column.getSizeAsInt()) > 0xA00000) {
            type = "TEXT";
        }
        return type;
    }

    @Override
    protected void writeExternalIndexCreate(Table table, IIndex index, StringBuilder ddl) {
        super.writeExternalIndexCreate(table, index, ddl);
        if (index.getIncludedColumns() != null && index.getIncludedColumnCount() > 0) {
            ddl.append(" INCLUDE (");
            for (int i = 0; i < index.getIncludedColumnCount(); ++i) {
                if (i > 0) {
                    ddl.append(", ");
                }
                this.printIdentifier(index.getIncludedColumns()[i].getName(), ddl);
            }
            ddl.append(")");
        }
    }
}

