/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import org.jumpmind.db.platform.IDmlStatementFactory;
import org.jumpmind.db.platform.ase.AseDmlStatement;
import org.jumpmind.db.platform.hbase.HbaseDmlStatement;
import org.jumpmind.db.platform.mssql.MsSqlDmlStatement;
import org.jumpmind.db.platform.mysql.MySqlDmlStatement;
import org.jumpmind.db.platform.oracle.OracleDmlStatement;
import org.jumpmind.db.platform.postgresql.PostgreSqlDmlStatement;
import org.jumpmind.db.platform.postgresql.PostgreSqlDmlStatement95;
import org.jumpmind.db.platform.redshift.RedshiftDmlStatement;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhereDmlStatement;
import org.jumpmind.db.platform.sqlite.SqliteDmlStatement;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.util.AppUtils;

public class DmlStatementFactory
implements IDmlStatementFactory {
    protected static IDmlStatementFactory instance;

    protected DmlStatementFactory() {
    }

    public static synchronized IDmlStatementFactory getInstance() {
        if (instance == null) {
            return (IDmlStatementFactory)AppUtils.newInstance(IDmlStatementFactory.class, DmlStatementFactory.class);
        }
        return instance;
    }

    @Override
    public DmlStatement create(String databaseName, DmlStatementOptions options) {
        if ("oracle".equals(databaseName) || "oracle122".equals(databaseName) || "oracle23".equals(databaseName)) {
            return new OracleDmlStatement(options);
        }
        if ("postgres".equals(databaseName) || "postgres95".equals(databaseName) && System.getProperty("postgres.use.on.conflict", "").equalsIgnoreCase("false")) {
            return new PostgreSqlDmlStatement(options);
        }
        if ("postgres95".equals(databaseName)) {
            return new PostgreSqlDmlStatement95(options);
        }
        if ("redshift".equals(databaseName)) {
            return new RedshiftDmlStatement(options);
        }
        if ("mysql".equals(databaseName)) {
            return new MySqlDmlStatement(options);
        }
        if ("sqlite".equals(databaseName)) {
            return new SqliteDmlStatement(options);
        }
        if ("sqlanywhere".equals(databaseName)) {
            return new SqlAnywhereDmlStatement(options);
        }
        if (databaseName != null && databaseName.startsWith("mssql")) {
            return new MsSqlDmlStatement(options);
        }
        if ("hbase".equals(databaseName)) {
            return new HbaseDmlStatement(options);
        }
        if ("ase".equals(databaseName)) {
            return new AseDmlStatement(options);
        }
        return new DmlStatement(options);
    }
}

