/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.symmetric.web.ServerSymmetricEngine;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;

public class ServletUtils {
    public static boolean sendError(HttpServletResponse resp, int statusCode) throws IOException {
        return ServletUtils.sendError(resp, statusCode, null);
    }

    public static String whereAreYou(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static boolean sendError(HttpServletResponse resp, int statusCode, String message) throws IOException {
        boolean retVal = false;
        if (!resp.isCommitted()) {
            resp.sendError(statusCode, StringEscapeUtils.escapeHtml4((String)message));
            retVal = true;
        }
        return retVal;
    }

    public static boolean sendError(ServletResponse resp, int statusCode) throws IOException {
        return ServletUtils.sendError(resp, statusCode, null);
    }

    public static boolean sendError(ServletResponse resp, int statusCode, String message) throws IOException {
        boolean retVal = false;
        if (resp instanceof HttpServletResponse) {
            retVal = ServletUtils.sendError((HttpServletResponse)resp, statusCode, message);
        }
        return retVal;
    }

    public static String normalizeRequestUri(HttpServletRequest httpRequest) {
        String servletPath;
        String contextPath;
        String retVal = httpRequest.getRequestURI();
        if (retVal.startsWith(contextPath = httpRequest.getContextPath())) {
            retVal = retVal.substring(contextPath.length());
        }
        if (retVal.startsWith(servletPath = httpRequest.getServletPath())) {
            retVal = retVal.substring(servletPath.length());
        }
        return retVal;
    }

    public static ServerSymmetricEngine findEngine(HttpServletRequest req, ServletContext ctx) {
        String engineName = ServletUtils.getEngineNameFromUrl(req);
        ServerSymmetricEngine engine = null;
        SymmetricEngineHolder holder = ServletUtils.getSymmetricEngineHolder(ctx);
        if (holder != null) {
            if (engineName != null) {
                engine = holder.getEngines().get(engineName);
            }
            if (holder.getEngineCount() == 1 && engine == null && holder.getNumerOfEnginesStarting() <= 1 && holder.getEngines().size() == 1) {
                engine = holder.getEngines().values().iterator().next();
            }
        }
        return engine;
    }

    public static String getEngineNameFromUrl(HttpServletRequest req) {
        String normalizedUri;
        String engineName = null;
        int startIndex = (normalizedUri = ServletUtils.normalizeRequestUri(req)).startsWith("/") ? 1 : 0;
        int endIndex = normalizedUri.indexOf("/", startIndex);
        if (endIndex > 0) {
            engineName = normalizedUri.substring(startIndex, endIndex);
        }
        return engineName;
    }

    public static String getParameter(HttpServletRequest request, String name) {
        return StringUtils.trimToNull((String)request.getParameter(name));
    }

    public static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trimToNull((String)request.getParameter(name)), (CharSequence)defaultValue);
    }

    public static long getParameterAsNumber(HttpServletRequest request, String name) {
        return NumberUtils.toLong((String)StringUtils.trimToNull((String)request.getParameter(name)));
    }

    public static SymmetricEngineHolder getSymmetricEngineHolder(ServletContext ctx) {
        return (SymmetricEngineHolder)ctx.getAttribute("symmetricEngineHolder");
    }

    public static String getEndpointNameFromUrl(HttpServletRequest request) {
        String endpointName = null;
        String normalizedUri = ServletUtils.normalizeRequestUri(request);
        normalizedUri = normalizedUri.startsWith("/") ? normalizedUri.replaceFirst("/" + ServletUtils.getEngineNameFromUrl(request) + "/", "") : normalizedUri.replaceFirst(ServletUtils.getEngineNameFromUrl(request) + "/", "");
        int endIndex = normalizedUri.indexOf("/");
        endpointName = endIndex > 0 ? normalizedUri.substring(0, endIndex) : normalizedUri;
        return endpointName;
    }
}

