/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class FileSyncPullUriHandler
extends AbstractUriHandler {
    private ISymmetricEngine engine;

    public FileSyncPullUriHandler(ISymmetricEngine engine, IInterceptor ... interceptors) {
        super("/filesync/pull/*", engine.getParameterService(), interceptors);
        this.engine = engine;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String nodeId = ServletUtils.getParameter(req, "nodeId");
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            ServletUtils.sendError(res, 603, "Node must be specified");
            return;
        }
        this.log.debug("File sync pull request received from {}", (Object)nodeId);
        IOutgoingTransport outgoingTransport = this.createOutgoingTransport((OutputStream)res.getOutputStream(), req.getHeader("Accept-Charset"), this.engine.getConfigurationService().getSuspendIgnoreChannelLists(nodeId));
        ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(this.engine.getNodeService().findIdentityNodeId(), nodeId, ProcessType.FILE_SYNC_PULL_HANDLER));
        try {
            this.engine.getFileSyncService().sendFiles(processInfo, this.engine.getNodeService().findNode(nodeId, true), outgoingTransport);
            Node targetNode = this.engine.getNodeService().findNode(nodeId, true);
            if (processInfo.getTotalBatchCount() == 0L && targetNode.isVersionGreaterThanOrEqualTo(new int[]{3, 8, 0})) {
                ServletUtils.sendError(res, 204, "No files to pull.");
            } else {
                res.setContentType("application/zip");
                res.addHeader("Content-Disposition", "attachment; filename=\"file-sync.zip\"");
            }
            processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
        }
        catch (RuntimeException ex) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            throw ex;
        }
        finally {
            if (outgoingTransport != null) {
                outgoingTransport.close();
            }
        }
    }
}

