/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class IncomingPurgeJob
extends AbstractJob {
    public IncomingPurgeJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Purge Incoming", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().schedule("0 0 0 * * *").description("Purge incoming data");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        this.setProcessedCount(this.engine.getPurgeService().purgeIncoming(force));
    }

    @Override
    public String getDeprecatedStartParameter() {
        return "start.purge.incoming.job";
    }
}

