/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.firebird;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.db.firebird.Firebird20TriggerTemplate;
import org.jumpmind.symmetric.db.firebird.FirebirdSymmetricDialect;
import org.jumpmind.symmetric.service.IParameterService;

public class Firebird20SymmetricDialect
extends FirebirdSymmetricDialect {
    public Firebird20SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new Firebird20TriggerTemplate(this);
    }

    @Override
    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.queryForInt("select rdb$set_context('USER_SESSION','sync_triggers_disabled',1) from rdb$database", new Object[0]);
        if (nodeId != null) {
            transaction.queryForInt("select rdb$set_context('USER_SESSION','sync_node_disabled','" + nodeId + "') from rdb$database", new Object[0]);
        }
    }

    @Override
    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.queryForInt("select rdb$set_context('USER_SESSION','sync_triggers_disabled',null) from rdb$database", new Object[0]);
        transaction.queryForInt("select rdb$set_context('USER_SESSION','sync_node_disabled',null) from rdb$database", new Object[0]);
    }

    @Override
    public String getSyncTriggersExpression() {
        return "rdb$get_context('USER_SESSION','sync_triggers_disabled') is null";
    }
}

