/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.io.data.DbFill;
import org.jumpmind.symmetric.io.data.DmlWeight;
import org.jumpmind.symmetric.service.IParameterService;

public class DbFillCommand
extends AbstractCommandLauncher {
    private static final String OPTION_SCHEMA = "schema";
    private static final String OPTION_CATALOG = "catalog";
    private static final String OPTION_COUNT = "count";
    private static final String OPTION_CASCADE = "cascade";
    private static final String OPTION_CASCADE_SELECT = "select";
    private static final String OPTION_IGNORE_TABLES = "ignore";
    private static final String OPTION_PREFIXED_TABLES = "prefixed";
    private static final String OPTION_INTERVAL = "interval";
    private static final String OPTION_WEIGHTS = "weights";
    private static final String OPTION_CONTINUE = "continue";
    private static final String OPTION_PRINT = "print";
    private static final String OPTION_RAND = "rand";
    private static final String OPTION_REPEAT = "repeat";
    private static final String OPTION_COMMIT = "commit";
    private static final String OPTION_COMMIT_DELAY = "commit-delay";
    private static final String OPTION_ROLLBACK = "rollback";
    private static final String OPTION_TRUNCATE = "truncate";
    private static final String OPTION_MAX_TEXT_SIZE = "max-text-size";
    private static final String OPTION_MAX_BYTE_SIZE = "max-byte-size";

    public DbFillCommand() {
        super("dbfill", "[tablename...]", "DbFill.Option.");
    }

    public static void main(String[] args) {
        new DbFillCommand().execute(args);
    }

    @Override
    protected boolean printHelpIfNoOptionsAreProvided() {
        return false;
    }

    @Override
    protected boolean requiresPropertiesFile(CommandLine line) {
        return true;
    }

    @Override
    protected void printHelp(CommandLine cmd, Options options) {
        System.out.println(this.app + " version " + Version.version());
        System.out.println("Fill database tables with random generated data.\n");
        super.printHelp(cmd, options);
    }

    @Override
    protected void buildOptions(Options options) {
        super.buildOptions(options);
        this.addOption(options, null, OPTION_SCHEMA, true);
        this.addOption(options, null, OPTION_CATALOG, true);
        this.addOption(options, null, OPTION_COUNT, true);
        this.addOption(options, null, OPTION_CASCADE, false);
        this.addOption(options, null, OPTION_CASCADE_SELECT, false);
        this.addOption(options, null, OPTION_IGNORE_TABLES, true);
        this.addOption(options, null, OPTION_PREFIXED_TABLES, true);
        this.addOption(options, null, OPTION_INTERVAL, true);
        this.addOption(options, null, OPTION_WEIGHTS, true);
        this.addOption(options, null, OPTION_CONTINUE, false);
        this.addOption(options, null, OPTION_PRINT, false);
        this.addOption(options, null, OPTION_RAND, false);
        this.addOption(options, null, OPTION_REPEAT, true);
        this.addOption(options, null, OPTION_COMMIT, true);
        this.addOption(options, null, OPTION_COMMIT_DELAY, true);
        this.addOption(options, null, OPTION_ROLLBACK, true);
        this.addOption(options, null, OPTION_TRUNCATE, false);
        this.addOption(options, null, OPTION_MAX_TEXT_SIZE, true);
        this.addOption(options, null, OPTION_MAX_BYTE_SIZE, true);
    }

    @Override
    protected boolean executeWithOptions(CommandLine line) throws Exception {
        DbFill dbFill = new DbFill(this.getDatabasePlatform(false));
        if (line.hasOption(OPTION_SCHEMA)) {
            dbFill.setSchema(line.getOptionValue(OPTION_SCHEMA));
        }
        if (line.hasOption(OPTION_CATALOG)) {
            dbFill.setCatalog(line.getOptionValue(OPTION_CATALOG));
        }
        if (line.hasOption(OPTION_COUNT)) {
            dbFill.setRecordCount(Integer.parseInt(line.getOptionValue(OPTION_COUNT)));
        }
        if (line.hasOption(OPTION_CASCADE)) {
            dbFill.setCascading(true);
        }
        if (line.hasOption(OPTION_CASCADE_SELECT)) {
            dbFill.setCascadingSelect(true);
        }
        if (line.hasOption(OPTION_INTERVAL)) {
            dbFill.setInterval(Integer.parseInt(line.getOptionValue(OPTION_INTERVAL)));
        }
        if (line.hasOption(OPTION_WEIGHTS)) {
            dbFill.setDmlWeight(new DmlWeight(line.getOptionValue(OPTION_WEIGHTS)));
        }
        if (line.hasOption("debug")) {
            dbFill.setDebug(true);
        }
        if (line.hasOption("verbose")) {
            dbFill.setVerbose(true);
        }
        Object[] ignore = null;
        if (line.hasOption(OPTION_IGNORE_TABLES)) {
            ignore = line.getOptionValue(OPTION_IGNORE_TABLES).split(",");
        }
        String[] prefixed = null;
        if (line.hasOption(OPTION_PREFIXED_TABLES)) {
            prefixed = line.getOptionValue(OPTION_PREFIXED_TABLES).split(",");
        }
        if (line.hasOption(OPTION_CONTINUE)) {
            dbFill.setContinueOnError(true);
        }
        if (line.hasOption(OPTION_PRINT)) {
            dbFill.setPrint(true);
        }
        if (line.hasOption(OPTION_RAND)) {
            dbFill.setUseRandomCount(true);
        }
        if (line.hasOption(OPTION_REPEAT)) {
            dbFill.setRepeat(Integer.parseInt(line.getOptionValue(OPTION_REPEAT)));
        }
        if (line.hasOption(OPTION_COMMIT)) {
            dbFill.setMaxRowsCommit(Integer.parseInt(line.getOptionValue(OPTION_COMMIT)));
        }
        if (line.hasOption(OPTION_COMMIT_DELAY)) {
            dbFill.setCommitDelay(Integer.parseInt(line.getOptionValue(OPTION_COMMIT_DELAY)));
        }
        if (line.hasOption(OPTION_ROLLBACK)) {
            dbFill.setPercentRollback(Integer.parseInt(line.getOptionValue(OPTION_ROLLBACK)));
        }
        if (line.hasOption(OPTION_TRUNCATE)) {
            dbFill.setTruncate(true);
        }
        if (line.hasOption(OPTION_MAX_TEXT_SIZE)) {
            dbFill.setMaxTextSize(Integer.parseInt(line.getOptionValue(OPTION_MAX_TEXT_SIZE)));
        }
        if (line.hasOption(OPTION_MAX_BYTE_SIZE)) {
            dbFill.setMaxByteSize(Integer.parseInt(line.getOptionValue(OPTION_MAX_BYTE_SIZE)));
        }
        this.getSymmetricEngine();
        IParameterService parameterService = this.engine.getParameterService();
        String cfgPrefix = parameterService.getString("sync.table.prefix");
        dbFill.setIgnore((String[])ArrayUtils.add((Object[])ignore, (Object)cfgPrefix));
        dbFill.setPrefixed(prefixed);
        Map<String, DmlWeight> tableProperties = this.parseTableProperties();
        String[] tableNames = null;
        tableNames = tableProperties.size() != 0 ? tableProperties.keySet().toArray(new String[0]) : line.getArgs();
        if (!dbFill.getPrint()) {
            dbFill.fillTables(tableNames, tableProperties);
        } else {
            for (String tableName : tableNames) {
                Table table = this.platform.readTableFromDatabase(dbFill.getCatalogToUse(), dbFill.getSchemaToUse(), tableName);
                if (table == null) continue;
                for (int i = 0; i < dbFill.getRecordCount(); ++i) {
                    String sql;
                    int j;
                    for (j = 0; j < dbFill.getInsertWeight(); ++j) {
                        sql = dbFill.createDynamicRandomInsertSql(table);
                        System.out.println(sql);
                    }
                    for (j = 0; j < dbFill.getUpdateWeight(); ++j) {
                        sql = dbFill.createDynamicRandomUpdateSql(table);
                        System.out.println(sql);
                    }
                    for (j = 0; j < dbFill.getDeleteWeight(); ++j) {
                        sql = dbFill.createDynamicRandomDeleteSql(table);
                        System.out.println(sql);
                    }
                }
            }
        }
        return true;
    }

    private Map<String, DmlWeight> parseTableProperties() {
        HashMap<String, DmlWeight> tableProperties = new HashMap<String, DmlWeight>();
        Properties properties = this.engine.getProperties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)properties.get(key);
            if (!key.startsWith("fill.")) continue;
            String tableName = null;
            tableName = key.substring(key.lastIndexOf(".") + 1);
            DmlWeight dmlWeight = new DmlWeight(value);
            tableProperties.put(tableName, dmlWeight);
        }
        return tableProperties;
    }
}

